/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.ui.search.generate;

import com.alibabacloud.intellij.qoder.chat.model.ChatSessionContext;
import com.alibabacloud.intellij.qoder.constants.CosyKey;
import com.alibabacloud.intellij.qoder.constants.InputConstants;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.AuthStateEnum;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.AuthStatus;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.AuthWhitelistStatusEnum;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.ChatModeItem;
import com.alibabacloud.intellij.qoder.service.ModeService;
import com.alibabacloud.intellij.qoder.ui.chat.BaseChatPanel;
import com.alibabacloud.intellij.qoder.ui.search.component.AutoHeightTextArea;
import com.alibabacloud.intellij.qoder.ui.search.component.RoundRectPanel;
import com.alibabacloud.intellij.qoder.ui.search.enums.ChatContextTypeEnum;
import com.alibabacloud.intellij.qoder.ui.search.enums.ChatMode;
import com.alibabacloud.intellij.qoder.ui.search.enums.ComponentTypeEnum;
import com.alibabacloud.intellij.qoder.ui.search.generate.SuggestPromptPopupPanel;
import com.alibabacloud.intellij.qoder.ui.search.generate.input.ChatContextTagsPanel;
import com.alibabacloud.intellij.qoder.ui.search.generate.input.ChatInputContext;
import com.alibabacloud.intellij.qoder.ui.search.generate.input.ChatInputFocusController;
import com.alibabacloud.intellij.qoder.ui.search.generate.input.ChatInputOperationPanel;
import com.alibabacloud.intellij.qoder.ui.search.generate.input.ChatInputPasteController;
import com.alibabacloud.intellij.qoder.ui.search.generate.input.ChatInputSuggester;
import com.alibabacloud.intellij.qoder.ui.search.generate.input.ChatInputTagsController;
import com.alibabacloud.intellij.qoder.ui.search.generate.input.ChatInputTextArea;
import com.alibabacloud.intellij.qoder.ui.search.listener.InputTextAreaCursorDisableListener;
import com.alibabacloud.intellij.qoder.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.qoder.ui.search.model.ActiveFileInfo;
import com.alibabacloud.intellij.qoder.ui.search.model.ChatContextTag;
import com.alibabacloud.intellij.qoder.ui.search.model.GenerateInput;
import com.alibabacloud.intellij.qoder.ui.search.model.SuggestPrompt;
import com.alibabacloud.intellij.qoder.ui.search.model.tag.ChatAskTag;
import com.alibabacloud.intellij.qoder.ui.search.topic.AddToChatNotifier;
import com.alibabacloud.intellij.qoder.ui.search.topic.EditorActiveFileNotifier;
import com.alibabacloud.intellij.qoder.ui.search.topic.EditorSelectedCodeNotifier;
import com.alibabacloud.intellij.qoder.util.ColorUtil;
import com.alibabacloud.intellij.qoder.util.FileUtil;
import com.alibabacloud.intellij.qoder.util.FontUtil;
import com.alibabacloud.intellij.qoder.util.SwingUtil;
import com.alibabacloud.intellij.qoder.util.TagUtil;
import com.google.common.collect.Sets;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.project.Project;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseMotionListener;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class AskInputPanel
extends JPanel
implements SwingUtil.IgnoreForeachChildComponent {
    private static final Logger Log = Logger.getInstance(AskInputPanel.class);
    private static final int MAX_TEXTFIELD_HEIGHT = 300;
    private static final int SEND_PANEL_WIDTH = 22;
    private static final int SEND_BUTTON_LEFT_MARGIN = 2;
    private static final int MIN_TEXTFIELD_HEIGHT = 20;
    public ChatInputTextArea textArea;
    protected JPanel basePanel;
    protected ChatInputOperationPanel inputOperationPanel;
    JPanel rightPanel;
    protected RoundRectPanel inputPanel;
    public ChatContextTagsPanel inputTagsPanel;
    protected JPanel inputInternalPanel;
    Project project;
    protected JBScrollPane jbScrollPane;
    protected ChatInputContext chatInputContext;
    ChatInputPasteController inputController;
    ChatInputFocusController inputFocusController;
    ChatInputTagsController inputTagsController;
    MessageBusConnection messageBusConnection;
    ChatInputSuggester chatInputSuggester;
    DocumentListener defaultDocumentListener = new DocumentAdapter(){

        protected void textChanged(@NotNull DocumentEvent e) {
            if (e == null) {
                1.$$$reportNull$$$0(0);
            }
            AskInputPanel.this.checkTextValid();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/alibabacloud/intellij/qoder/ui/search/generate/AskInputPanel$1", "textChanged"));
        }
    };
    protected String sessionTab;
    private String sessionType;

    public AskInputPanel(Project project, BaseChatPanel baseChatPanel, String sessionTab) {
        this.sessionType = baseChatPanel.getSessionTypeEnum().getType();
        this.project = project;
        this.sessionTab = sessionTab;
        this.chatInputContext = new ChatInputContext(project, this, baseChatPanel, this.sessionType);
        this.setLayout(new BorderLayout());
        this.setBorder(JBUI.Borders.customLine((Color)ColorUtil.getEditorBackgroundColor(), (int)1, (int)0, (int)0, (int)0));
        this.inputTagsPanel = new ChatContextTagsPanel(this.chatInputContext, ChatContextTagsPanel.USAGE_INPUT_PANE);
        this.buildInputInternalField();
        this.jbScrollPane = new JBScrollPane(10){

            public Dimension getPreferredSize() {
                Dimension textDim = AskInputPanel.this.inputInternalPanel.getPreferredSize();
                return new Dimension(textDim.width, Math.min(textDim.height, 300));
            }

            public void doLayout() {
                super.doLayout();
                AskInputPanel.this.updateSendLayout();
            }
        };
        this.jbScrollPane.setViewportView((Component)this.inputInternalPanel);
        this.jbScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jbScrollPane.setHorizontalScrollBarPolicy(31);
        this.jbScrollPane.setVerticalScrollBarPolicy(20);
        this.inputOperationPanel = new ChatInputOperationPanel(this.chatInputContext, this);
        this.inputOperationPanel.addSendListener(e -> this.doSendMessage());
        this.configInputPanel();
        this.configBasePanel();
        this.inputFocusController = new ChatInputFocusController(this.chatInputContext, this.textArea);
        this.chatInputSuggester = new ChatInputSuggester(this.chatInputContext);
        this.checkSendButtonState();
        this.messageBusConnection = project.getMessageBus().connect();
        this.messageBusConnection.subscribe(EditorSelectedCodeNotifier.EDITOR_SELECTED_CODE_NOTIFICATION, this::notifySelectedCode);
        this.messageBusConnection.subscribe(EditorActiveFileNotifier.EDITOR_ACTIVE_FILE_NOTIFICATION, this::notifyActiveFile);
        this.messageBusConnection.subscribe(AddToChatNotifier.ADD_TO_CHAT_NOTIFICATION, this::addToChat);
        this.inputController = new ChatInputPasteController(this.chatInputContext, this.inputTagsPanel, this.textArea, this.messageBusConnection);
        this.inputTagsController = new ChatInputTagsController(this.chatInputContext, this.inputTagsPanel, this.textArea);
        this.setupFocusListener();
        SwingUtil.preventRecursiveBackgroundUpdateOnToolwindow(this.inputPanel);
    }

    private void addToChat(ActiveFileInfo meta) {
        SuggestPrompt suggestPrompt = InputConstants.SCOPE_SUGGEST_PROMPT_MAP.get(ChatContextTypeEnum.SELECTED_CODE.getType());
        if (null != suggestPrompt) {
            this.addContextTag(ChatContextTag.builder().id(TagUtil.getSelectCodeTagId(meta.getFilePath(), meta.getStatLine(), meta.getEndLine())).type(ChatContextTypeEnum.SELECTED_CODE.getType()).text(meta.getFileName()).statLine(meta.getStatLine()).endLine(meta.getEndLine()).payload(meta.getFilePath()).contextProvider(suggestPrompt).componentType(ComponentTypeEnum.COMBOBOX.getType()).extra(ChatContextTag.buildExtraOfChatContextTag(meta.getStatLine(), meta.getEndLine(), meta.getFilePath(), meta.getFileName(), meta.getSelectedCode())).sourceType(suggestPrompt.getSourceType()).sticky(true).build());
        }
    }

    protected void configBasePanel() {
        this.basePanel = new JPanel(new BorderLayout());
        this.basePanel.setBorder((Border)JBUI.Borders.empty((int)10, (int)12));
        this.basePanel.setBackground(ColorUtil.getToolWindowBackgroundColor());
        this.add((Component)this.basePanel, "Center");
        this.basePanel.add((Component)this.inputPanel, "Center");
    }

    protected void configInputPanel() {
        this.inputPanel = new RoundRectPanel(new BorderLayout()){

            @Override
            public void setBackground(Color bg) {
                super.setBackground(ColorUtil.getEditorBackgroundColor());
            }

            @Override
            public void refreshColor(EditorColorsScheme scheme, Color themeColor) {
                this.setBackground(ColorUtil.getEditorBackgroundColor());
            }
        };
        this.inputPanel.setBorder((Border)JBUI.Borders.empty((int)8, (int)12));
        this.inputPanel.setBackground(ColorUtil.getEditorBackgroundColor());
        this.inputPanel.add((Component)this.inputTagsPanel, "North");
        this.inputPanel.add((Component)this.jbScrollPane, "Center");
        this.inputPanel.add((Component)this.inputOperationPanel, "South");
    }

    private void notifySelectedCode(ActiveFileInfo afi) {
        if (null == afi) {
            this.inputTagsPanel.removeTagsOfTypes(Sets.newHashSet((Object[])new ChatContextTypeEnum[]{ChatContextTypeEnum.CURRENT_FILE}));
        } else {
            ChatContextTag tag = ChatContextTag.buildFromActiveFileInfo(afi);
            this.inputTagsPanel.removeCurrentTag(tag, AskInputPanel.compareContextTag(false, false));
            this.inputTagsPanel.addOrUpdateTag(1, tag, AskInputPanel.compareContextTag(true, false));
            if (ChatAskTag.nonContext(this.getTags()).booleanValue()) {
                this.updateContextTagsExceptReserves(Sets.newHashSet((Object[])new ChatContextTypeEnum[]{ChatContextTypeEnum.CURRENT_FILE}), 1);
            }
        }
    }

    private void notifyActiveFile(ActiveFileInfo afi) {
        if (null == afi || StringUtils.isBlank((CharSequence)afi.getFilePath()) || afi.getIsBinary().booleanValue()) {
            this.inputTagsPanel.removeTagsOfTypes(Sets.newHashSet((Object[])new ChatContextTypeEnum[]{ChatContextTypeEnum.CURRENT_FILE}));
            return;
        }
        ChatSessionContext chatSessionContext = (ChatSessionContext)ApplicationManager.getApplication().getUserData(CosyKey.CHAT_SESSION_CONTEXT);
        if (null != chatSessionContext && chatSessionContext.isCurrentFileRemoved()) {
            this.inputTagsPanel.removeTagsOfTypes(Sets.newHashSet((Object[])new ChatContextTypeEnum[]{ChatContextTypeEnum.CURRENT_FILE}));
            return;
        }
        ChatContextTag tag = ChatContextTag.buildFromActiveFileInfo(afi);
        this.inputTagsPanel.removeCurrentTag(tag, AskInputPanel.compareContextTag(false, false));
        if (!(null == tag || ChatContextTypeEnum.CURRENT_FILE.getType().equals(tag.getType()) && ChatMode.AGENT.getMode().equals(this.getChatMode()))) {
            this.inputTagsPanel.addOrUpdateTag(1, tag, AskInputPanel.compareContextTag(true, false));
        }
    }

    public String getChatMode() {
        if (null == this.inputOperationPanel || null == this.inputOperationPanel.getModeChooser()) {
            return null;
        }
        return ModeService.getInstance().getSelectionModeItem(this.project).getMode();
    }

    @NotNull
    public static BiFunction<ChatContextTag, ChatContextTag, Boolean> compareContextTag(Boolean currentFileEquals, Boolean imageEquals) {
        BiFunction<ChatContextTag, ChatContextTag, Boolean> biFunction = (tag1, tag2) -> {
            if (currentFileEquals.booleanValue() && ChatContextTypeEnum.CURRENT_FILE.getType().equals(tag1.getType()) && ChatContextTypeEnum.CURRENT_FILE.getType().equals(tag2.getType())) {
                return true;
            }
            boolean equals = Objects.equals(tag1.getId(), tag2.getId());
            if (!equals && imageEquals.booleanValue() && tag1.getStatLine() == null && tag2.getStatLine() == null && ChatContextTypeEnum.IMAGE.getType().equals(tag1.getType()) && ChatContextTypeEnum.IMAGE.getType().equals(tag2.getType())) {
                String filePath1 = tag1.getFilePath();
                String filePath2 = tag2.getFilePath();
                String fileUrl1 = FileUtil.getTempPath(tag1.getRemoteFileUrl(), tag1.getLocalFilePath());
                String fileUrl2 = FileUtil.getTempPath(tag2.getRemoteFileUrl(), tag2.getLocalFilePath());
                return StringUtils.isNotBlank((CharSequence)filePath1) && Objects.equals(filePath1, filePath2) || StringUtils.isNotBlank((CharSequence)filePath1) && Objects.equals(filePath1, fileUrl2) || StringUtils.isNotBlank((CharSequence)fileUrl1) && Objects.equals(fileUrl1, filePath2) || StringUtils.isNotBlank((CharSequence)fileUrl1) && Objects.equals(fileUrl1, fileUrl2);
            }
            return equals;
        };
        if (biFunction == null) {
            AskInputPanel.$$$reportNull$$$0(0);
        }
        return biFunction;
    }

    protected void buildInputInternalField() {
        this.buildTextArea();
        this.inputInternalPanel = new JPanel(new BorderLayout());
        this.inputInternalPanel.add((Component)this.textArea, "Center");
    }

    private void buildTextArea() {
        this.textArea = new ChatInputTextArea(this.chatInputContext, this, "", -1);
        this.textArea.setFont(FontUtil.LABEL_DEFAILT_FONT);
        this.textArea.addOnShowPlaceHolderListener(new AutoHeightTextArea.OnShowPlaceHolderListener(){

            @Override
            public void onShowPlaceHolder() {
                AskInputPanel.this.checkSendButtonState();
            }

            @Override
            public void onHiddenPlaceHolder() {
                AskInputPanel.this.checkSendButtonState();
            }
        });
        this.textArea.getDocument().addDocumentListener(this.defaultDocumentListener);
        this.textArea.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                AskInputPanel.this.updateLayout();
            }
        });
    }

    private void setupFocusListener() {
        SwingUtil.foreachChildComponent(this.inputPanel, com -> com.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                AskInputPanel.this.inputTagsPanel.setFocusState(true);
                AskInputPanel.this.showInputPanelBorder();
            }

            @Override
            public void focusLost(FocusEvent e) {
                SuggestPromptPopupPanel suggestPromptPopupPanel = AskInputPanel.this.chatInputSuggester.getSuggestPromptPopupPanel();
                if (suggestPromptPopupPanel == null || !suggestPromptPopupPanel.isShowPopup()) {
                    if (!AskInputPanel.this.inputTagsPanel.getContextAddButton().isDisableBackgoundColorEvent()) {
                        AskInputPanel.this.inputTagsPanel.setFocusState(false);
                    }
                    AskInputPanel.this.inputPanel.setBorderColor(null);
                }
                AskInputPanel.this.inputPanel.invalidate();
                AskInputPanel.this.inputPanel.repaint();
            }
        }));
    }

    public void showInputPanelBorder() {
        this.inputPanel.setBorderColor(JBUI.CurrentTheme.Focus.focusColor());
        this.inputPanel.invalidate();
        this.inputPanel.repaint();
    }

    public void resetRecentQueryIndex() {
        this.chatInputContext.getRecentQueryIndexMap().clear();
        this.chatInputContext.getRecentQueryStartMap().clear();
    }

    public void doSendMessage() {
        if (this.textArea.isEnabled() && this.inputOperationPanel.isSendEnabled() && this.chatInputContext.isSendEnabled() && this.textArea.canSend()) {
            this.textArea.doSendMessage();
            this.clearAfterSent();
        }
    }

    public void clearTextArea() {
        this.textArea.clearTextArea();
    }

    public void clearAfterSent() {
        List<ChatContextTag> tags = this.getInputTagsPanel().getTags();
        this.textArea.clearAfterSent();
        this.clearTagsAfterSend(tags);
    }

    public void clearTagsAfterSend(List<ChatContextTag> tags) {
        this.inputTagsPanel.removeAllTags();
    }

    public void updateLayout() {
        this.revalidate();
        this.repaint();
    }

    public void updateSendLayout() {
    }

    public void setState(AuthStatus status) {
        if (status.getStatus() != null && AuthStateEnum.LOGIN.getValue() == status.getStatus().intValue()) {
            if (status.getWhitelist() == null) {
                status.setWhitelist(AuthWhitelistStatusEnum.UNKNOWN.getValue());
            }
            if (status.getWhitelist().intValue() == AuthWhitelistStatusEnum.PASS.getValue()) {
                this.textArea.setEnabled(true);
                this.textArea.setCursor(Cursor.getPredefinedCursor(2));
                this.textArea.setPlaceholder(this.getNormalPlaceHolderBySessionTab());
                this.setIsHistoryEmpty(true);
                this.inputTagsPanel.setComponentEnabled(true);
            } else {
                this.textArea.setEnabled(false);
                this.inputTagsPanel.setComponentEnabled(false);
                this.textArea.setCursor(Cursor.getPredefinedCursor(0));
                this.textArea.setPlaceholder(CosyBundle.message("chat.input.placeholder.require.access", new Object[0]));
            }
        } else {
            this.textArea.setText("");
            this.textArea.setEnabled(false);
            this.textArea.setCursor(Cursor.getPredefinedCursor(0));
            this.textArea.setPlaceholder(CosyBundle.message("chat.input.placeholder.require.login", new Object[0]));
            this.inputTagsPanel.setComponentEnabled(false);
        }
    }

    private String getNormalPlaceHolderBySessionTab() {
        ChatModeItem modeItem = ModeService.getInstance().getSelectionModeItem(this.project);
        if (ChatMode.CHAT.getMode().equals(modeItem.getMode())) {
            return CosyBundle.message("chat.input.placeholder.normal.ask", new Object[0]);
        }
        if (ChatMode.EDIT.getMode().equals(modeItem.getMode())) {
            return CosyBundle.message("chat.input.placeholder.normal.edit", new Object[0]);
        }
        return CosyBundle.message("chat.input.placeholder.normal.agent", new Object[0]);
    }

    private String getContinuePlaceHolderBySessionTab() {
        return CosyBundle.message("chat.input.placeholder.continue", new Object[0]);
    }

    private void checkTextValid() {
        this.updateLayout();
        this.inputTagsPanel.checkState();
        this.checkSendButtonState();
    }

    public void checkSendButtonState() {
        if (StringUtils.isEmpty((CharSequence)this.textArea.getText())) {
            this.inputOperationPanel.setSendEnabled(false);
        } else {
            this.checkSendButtonStateByTags();
        }
    }

    private void checkSendButtonStateByTags() {
        if (this.getTextArea().canSend() && this.chatInputContext.isSendEnabled()) {
            this.inputOperationPanel.setSendEnabled(true);
        } else {
            this.inputOperationPanel.setSendEnabled(false);
        }
    }

    public void disableInputPanel() {
        this.addMouseMotionListener(new InputTextAreaCursorDisableListener(this.textArea));
        this.textArea.setEditable(false);
        this.textArea.setEnabled(false);
        this.textArea.setCursor(Cursor.getPredefinedCursor(0));
        this.inputOperationPanel.setSendEnabled(false);
        this.inputTagsPanel.setComponentEnabled(false);
    }

    public void enableInputPanel() {
        MouseMotionListener[] listeners;
        for (MouseMotionListener listener : listeners = this.getMouseMotionListeners()) {
            if (!(listener instanceof InputTextAreaCursorDisableListener)) continue;
            this.removeMouseMotionListener(listener);
        }
        this.textArea.setEditable(true);
        this.textArea.enablePlaceHolder();
        this.textArea.setEnabled(true);
        this.textArea.setCursor(Cursor.getPredefinedCursor(2));
        this.inputOperationPanel.setSendEnabled(true);
        this.inputTagsPanel.setComponentEnabled(true);
    }

    public void disableSendButton() {
        this.inputOperationPanel.setSendEnabled(false);
        this.chatInputContext.setSendEnabled(false);
    }

    public void enableSendButton() {
        this.inputOperationPanel.setSendEnabled(true);
        this.chatInputContext.setSendEnabled(true);
    }

    public void setText(String text) {
        if (this.textArea != null) {
            this.textArea.setText(text);
        }
    }

    public void setTextFocus() {
        if (this.textArea != null && this.textArea.isEnabled() && this.textArea.isEditable()) {
            this.textArea.requestFocusInWindow();
            this.textArea.grabFocus();
            Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new FocusEvent(this.textArea, 1004));
        }
    }

    public void addTag(ChatAskTag tag) {
        if (this.textArea != null) {
            this.textArea.addTag(tag);
        }
    }

    public void addTag(int startOffset, int endOffset, ChatAskTag tag) {
        if (this.textArea != null) {
            this.textArea.addTag(startOffset, endOffset, tag);
        }
    }

    public void addContextTag(ChatContextTag chatContextTag) {
        if (this.inputTagsPanel != null && chatContextTag != null) {
            this.inputTagsPanel.addOrUpdateTag(-1, chatContextTag, AskInputPanel.compareContextTag(true, true));
        }
    }

    public boolean checkImageContextTagLimit(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return true;
        }
        List<ChatContextTag> tags = this.inputTagsPanel.getTags();
        boolean isExist = tags.stream().anyMatch(item -> id.equals(item.getId()));
        if (isExist) {
            return true;
        }
        int count = 0;
        for (ChatContextTag item2 : tags) {
            String fileType;
            Map<String, Object> extra = item2.getExtra();
            if (extra == null || !extra.containsKey("contextType") || !"image".equalsIgnoreCase(fileType = (String)extra.get("fileType"))) continue;
            ++count;
        }
        return count < 5;
    }

    public void clearAllContextTags() {
        if (this.inputTagsPanel != null) {
            this.inputTagsPanel.removeAllTags();
        }
    }

    public void updateContextTagsExceptReserves(Set<ChatContextTypeEnum> reserveTagTypes, int mode) {
        if (this.inputTagsPanel == null) {
            return;
        }
        if (reserveTagTypes.contains((Object)ChatContextTypeEnum.SELECTED_CODE)) {
            reserveTagTypes.add(ChatContextTypeEnum.CURRENT_FILE);
            Optional<ChatContextTag> currentFileTag = this.inputTagsPanel.getTags().stream().filter(item -> item.getType() != null && item.getType().equals(ChatContextTypeEnum.CURRENT_FILE.getType())).findFirst();
            if (currentFileTag.isPresent() && currentFileTag.get().getStatLine() == null) {
                this.inputTagsPanel.removeById(currentFileTag.get().getId());
                this.inputTagsPanel.removeAskInputTags(currentFileTag.get());
            }
        }
        this.inputTagsPanel.updateTagsExcept(reserveTagTypes, mode);
    }

    public void transferAutoContextTag(ChatContextTag tag) {
        if (!ChatContextTypeEnum.CURRENT_FILE.getType().equals(tag.getType())) {
            return;
        }
        if (tag.getStatLine() == null) {
            tag.setType(ChatContextTypeEnum.FILE.getType());
        } else {
            tag.setType(ChatContextTypeEnum.SELECTED_CODE.getType());
        }
        tag.setContextProvider(InputConstants.SCOPE_SUGGEST_PROMPT_MAP.get(tag.getType()));
        this.inputTagsPanel.addOrUpdateTag(-1, tag, AskInputPanel.compareContextTag(false, false));
    }

    public List<ChatAskTag> getTags() {
        if (this.textArea != null) {
            return this.textArea.getTags();
        }
        return List.of();
    }

    public void replaceTagWithText(ChatAskTag targetTag) {
        if (this.textArea != null && targetTag != null) {
            this.textArea.replaceTagWithText(targetTag, targetTag.getDisplayText(), (tag1, tag2) -> Objects.equals(tag1.getId(), tag2.getId()));
        }
    }

    public void clearTags() {
        this.inputTagsPanel.removeAllTags();
        this.inputTagsPanel.initTags();
    }

    public void clearAll() {
        this.clearAllContextTags();
        this.textArea.setText("");
    }

    public void setTextAreaPlaceholder() {
        if (CollectionUtils.isEmpty(this.getTags())) {
            this.inputTagsPanel.updateUiTexts();
            if ("AiDeveloper".equals(this.sessionTab)) {
                if (!this.textArea.isEnabled()) {
                    this.textArea.setPlaceholder(this.getContinuePlaceHolderBySessionTab());
                } else {
                    this.textArea.setPlaceholder(this.getNormalPlaceHolderBySessionTab());
                }
            } else {
                boolean isFirstRoundChat;
                GenerateInput initInput = this.chatInputContext.getBaseChatPanel().getInitInput();
                boolean bl = isFirstRoundChat = initInput.getChatHistory() != null && CollectionUtils.isEmpty(initInput.getChatHistory().getAskAnswerList());
                if (BooleanUtils.isTrue((Boolean)isFirstRoundChat)) {
                    this.textArea.setPlaceholder(this.getNormalPlaceHolderBySessionTab());
                } else {
                    this.textArea.setPlaceholder(this.getContinuePlaceHolderBySessionTab());
                }
            }
        }
    }

    public void setTextFocusLost() {
        if (this.textArea != null) {
            Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new FocusEvent(this.textArea, 1005));
        }
    }

    @Override
    public void addKeyListener(KeyListener listener) {
        if (this.textArea != null) {
            this.textArea.addKeyListener(listener);
        }
    }

    public void addEnterKeyListener(AutoHeightTextArea.EnterKeyListener listener) {
        if (this.textArea != null) {
            this.textArea.addEnterKeyListener(listener);
        }
    }

    public void setIsHistoryEmpty(boolean isHistoryEmpty) {
        this.chatInputContext.getHistoryEmpty().set(isHistoryEmpty);
    }

    public boolean isSendEnabled() {
        return this.chatInputContext.isSendEnabled();
    }

    public void setSendEnabled(boolean sendEnabled) {
        this.chatInputContext.setSendEnabled(sendEnabled);
    }

    @Generated
    public ChatInputTextArea getTextArea() {
        return this.textArea;
    }

    @Generated
    public JPanel getBasePanel() {
        return this.basePanel;
    }

    @Generated
    public ChatInputOperationPanel getInputOperationPanel() {
        return this.inputOperationPanel;
    }

    @Generated
    public RoundRectPanel getInputPanel() {
        return this.inputPanel;
    }

    @Generated
    public ChatContextTagsPanel getInputTagsPanel() {
        return this.inputTagsPanel;
    }

    @Generated
    public Project getProject() {
        return this.project;
    }

    @Generated
    public ChatInputContext getChatInputContext() {
        return this.chatInputContext;
    }

    @Generated
    public ChatInputTagsController getInputTagsController() {
        return this.inputTagsController;
    }

    @Generated
    public ChatInputSuggester getChatInputSuggester() {
        return this.chatInputSuggester;
    }

    @Generated
    public DocumentListener getDefaultDocumentListener() {
        return this.defaultDocumentListener;
    }

    @Generated
    public String getSessionType() {
        return this.sessionType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/alibabacloud/intellij/qoder/ui/search/generate/AskInputPanel", "compareContextTag"));
    }
}

