/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.ui.search.generate;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibabacloud.intellij.qoder.chat.model.BadFeedbackContent;
import com.alibabacloud.intellij.qoder.chat.model.BadFeedbackParam;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.FeedbackResult;
import com.alibabacloud.intellij.qoder.service.CosyService;
import com.alibabacloud.intellij.qoder.service.impl.CosyServiceImpl;
import com.alibabacloud.intellij.qoder.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.qoder.util.ColorUtil;
import com.alibabacloud.intellij.qoder.util.SwingUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBTextArea;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class BadFeedbackDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance(BadFeedbackDialog.class);
    private static final int MAX_ADVICE_LENGTH = 100;
    private JPanel basePanel;
    private JCheckBox incompleteCheckBox;
    private JCheckBox notAccurateCheckBox;
    private JCheckBox lowResponseCheckBox;
    private JCheckBox incorrectOrMessyFormatCheckBox;
    private JCheckBox notHelpfulCheckBox;
    private JCheckBox answeringADifferentQuestionCheckBox;
    private JBTextArea adviceText;
    private JCheckBox shareTheContextOfCheckBox;
    private JPanel advicePanel;
    private JPanel adviceTextPanel;
    private JLabel adviceLabel;
    private JPanel leftCheckBoxPanel;
    private JPanel rightCheckBoxPanel;
    private JScrollPane adviceScrollPanel;
    private BadFeedbackParam badFeedbackParam;
    private BadFeedbackContent badFeedbackContent;
    private CosyService cosyService;
    private Project project;

    protected BadFeedbackDialog(String requestId, String sessionId, Project project, String chatTask, Component parentComponent) {
        super(parentComponent, true);
        this.$$$setupUI$$$();
        this.init();
        this.setTitle(CosyBundle.message("bad.feedback.title", new Object[0]));
        this.setOKButtonText(CosyBundle.message("bad.feedback.submit", new Object[0]));
        this.setOKActionEnabled(false);
        this.setCancelButtonText(CosyBundle.message("bad.feedback.cancel", new Object[0]));
        this.setResizable(false);
        this.adviceText = new JBTextArea();
        this.adviceText.getEmptyText().setText(CosyBundle.message("bad.feedback.more.advice.optional", new Object[0]));
        this.adviceText.setBorder(JBUI.Borders.empty((int)10));
        this.adviceText.setLineWrap(true);
        this.adviceText.setWrapStyleWord(true);
        this.adviceText.setEditable(true);
        this.adviceLabel.setBorder((Border)JBUI.Borders.empty((int)20, (int)0, (int)10, (int)0));
        this.adviceScrollPanel.setBorder((Border)JBUI.Borders.emptyBottom((int)10));
        this.adviceScrollPanel.setViewportView((Component)this.adviceText);
        SwingUtil.foreachChildComponent(this.adviceScrollPanel, cp -> cp.setBackground(ColorUtil.getEditorBackgroundColor()));
        this.setInitialLocationCallback(() -> {
            Rectangle ideBounds = SwingUtilities.getWindowAncestor(parentComponent).getBounds();
            int displayY = (int)parentComponent.getLocationOnScreen().getY();
            int displayX = (int)parentComponent.getLocationOnScreen().getX();
            int height = (int)this.getPreferredSize().getHeight();
            Point topPosition = new Point(displayX - 50, displayY - height);
            Point bottomPosition = new Point(displayX - 50, displayY + parentComponent.getHeight());
            return topPosition.y >= ideBounds.y ? topPosition : bottomPosition;
        });
        this.cosyService = new CosyServiceImpl();
        this.project = project;
        this.badFeedbackParam = new BadFeedbackParam();
        this.badFeedbackContent = new BadFeedbackContent();
        this.badFeedbackParam.setRequestId(requestId);
        this.badFeedbackParam.setSessionId(sessionId);
        this.badFeedbackParam.setChatTask(chatTask);
        this.incompleteCheckBox.addChangeListener(e -> {
            if (this.incompleteCheckBox.isSelected()) {
                this.setOKActionEnabled(true);
                this.badFeedbackContent.setIncomplete(true);
            } else {
                this.badFeedbackContent.setIncomplete(false);
                this.checkSendButtonEnable(this.badFeedbackParam, this.badFeedbackContent);
            }
        });
        this.notAccurateCheckBox.addChangeListener(e -> {
            if (this.notAccurateCheckBox.isSelected()) {
                this.setOKActionEnabled(true);
                this.badFeedbackContent.setNotAccurate(true);
            } else {
                this.badFeedbackContent.setNotAccurate(false);
                this.checkSendButtonEnable(this.badFeedbackParam, this.badFeedbackContent);
            }
        });
        this.lowResponseCheckBox.addChangeListener(e -> {
            if (this.lowResponseCheckBox.isSelected()) {
                this.setOKActionEnabled(true);
                this.badFeedbackContent.setLowResponse(true);
            } else {
                this.badFeedbackContent.setLowResponse(false);
                this.checkSendButtonEnable(this.badFeedbackParam, this.badFeedbackContent);
            }
        });
        this.incorrectOrMessyFormatCheckBox.addChangeListener(e -> {
            if (this.incorrectOrMessyFormatCheckBox.isSelected()) {
                this.setOKActionEnabled(true);
                this.badFeedbackContent.setIncorrectOrMessyFormat(true);
            } else {
                this.badFeedbackContent.setIncorrectOrMessyFormat(false);
                this.checkSendButtonEnable(this.badFeedbackParam, this.badFeedbackContent);
            }
        });
        this.notHelpfulCheckBox.addChangeListener(e -> {
            if (this.notHelpfulCheckBox.isSelected()) {
                this.setOKActionEnabled(true);
                this.badFeedbackContent.setNotHelpful(true);
            } else {
                this.badFeedbackContent.setNotHelpful(false);
                this.checkSendButtonEnable(this.badFeedbackParam, this.badFeedbackContent);
            }
        });
        this.answeringADifferentQuestionCheckBox.addChangeListener(e -> {
            if (this.answeringADifferentQuestionCheckBox.isSelected()) {
                this.setOKActionEnabled(true);
                this.badFeedbackContent.setIrrelevantAnswer(true);
            } else {
                this.badFeedbackContent.setIrrelevantAnswer(false);
                this.checkSendButtonEnable(this.badFeedbackParam, this.badFeedbackContent);
            }
        });
        this.shareTheContextOfCheckBox.addChangeListener(e -> {
            if (this.shareTheContextOfCheckBox.isSelected()) {
                this.badFeedbackParam.setShareContext(true);
            } else {
                this.badFeedbackParam.setShareContext(false);
                this.checkSendButtonEnable(this.badFeedbackParam, this.badFeedbackContent);
            }
        });
        this.adviceText.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                BadFeedbackDialog.this.checkLength();
            }
        });
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JPanel dialogPanel = new JPanel(new BorderLayout());
        dialogPanel.add((Component)this.basePanel, "Center");
        return dialogPanel;
    }

    protected void doOKAction() {
        String advice = this.adviceText.getText();
        this.badFeedbackParam.setAdviceText(advice);
        this.badFeedbackParam.setCheckBoxItems(JSON.toJSONString((Object)this.badFeedbackContent));
        super.doOKAction();
        LOG.debug("advice is " + advice + ",badFeedbackParam is " + JSONObject.toJSONString((Object)this.badFeedbackParam));
        FeedbackResult feedbackResult = this.cosyService.submitFeedback(this.project, this.badFeedbackParam);
        if (feedbackResult == null || !BooleanUtils.isTrue((Boolean)feedbackResult.getSuccess())) {
            LOG.warn("submit feedback error, badFeedbackParam is " + JSON.toJSONString((Object)this.badFeedbackParam) + ",result is " + feedbackResult);
        }
    }

    private void checkLength() {
        if (this.adviceText.getDocument().getLength() > 100) {
            String text = this.adviceText.getText();
            SwingUtilities.invokeLater(() -> {
                String content = text.substring(0, 100);
                this.adviceText.setText(content);
                this.adviceText.invalidate();
                this.advicePanel.revalidate();
            });
        }
        this.advicePanel.revalidate();
    }

    private void checkSendButtonEnable(BadFeedbackParam badFeedbackParam, BadFeedbackContent badFeedbackContent) {
        if (StringUtils.isNotBlank((CharSequence)badFeedbackParam.getAdviceText())) {
            this.setOKActionEnabled(true);
            return;
        }
        if (badFeedbackContent.getIncomplete().booleanValue() || badFeedbackContent.getNotAccurate().booleanValue() || badFeedbackContent.getLowResponse().booleanValue() || badFeedbackContent.getNotHelpful().booleanValue() || badFeedbackContent.getIncorrectOrMessyFormat().booleanValue() || badFeedbackContent.getIrrelevantAnswer().booleanValue()) {
            this.setOKActionEnabled(true);
            return;
        }
        this.setOKActionEnabled(false);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JPanel jPanel;
        JScrollPane jScrollPane;
        JLabel jLabel;
        JPanel jPanel2;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JPanel jPanel3;
        JCheckBox jCheckBox5;
        JCheckBox jCheckBox6;
        JCheckBox jCheckBox7;
        JPanel jPanel4;
        JPanel jPanel5;
        this.basePanel = jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout(0, 0));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(10, 0, 0, 10), -1, -1, false, false));
        jPanel5.add((Component)jPanel6, "North");
        this.leftCheckBoxPanel = jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(0, 5));
        jPanel6.add((Component)jPanel4, new GridConstraints(0, 0, 3, 1, 8, 2, 3, 3, null, null, null));
        this.incompleteCheckBox = jCheckBox7 = new JCheckBox();
        jCheckBox7.setHideActionText(false);
        jCheckBox7.setHorizontalAlignment(2);
        this.$$$loadButtonText$$$(jCheckBox7, ResourceBundle.getBundle("messageBundle").getString("bad.feedback.incomplete"));
        jPanel4.add((Component)jCheckBox7, "First");
        this.lowResponseCheckBox = jCheckBox6 = new JCheckBox();
        jCheckBox6.setHorizontalAlignment(2);
        this.$$$loadButtonText$$$(jCheckBox6, ResourceBundle.getBundle("messageBundle").getString("bad.feedback.low.response"));
        jPanel4.add((Component)jCheckBox6, "West");
        this.notHelpfulCheckBox = jCheckBox5 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox5, ResourceBundle.getBundle("messageBundle").getString("bad.feedback.not.helpful"));
        jPanel4.add((Component)jCheckBox5, "South");
        this.rightCheckBoxPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel6.add((Component)jPanel3, new GridConstraints(0, 1, 3, 1, 0, 3, 3, 3, null, null, null));
        this.notAccurateCheckBox = jCheckBox4 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox4, ResourceBundle.getBundle("messageBundle").getString("bad.feedback.not.accurate"));
        jPanel3.add((Component)jCheckBox4, "North");
        this.incorrectOrMessyFormatCheckBox = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("messageBundle").getString("bad.feedback.incorrect.format"));
        jPanel3.add((Component)jCheckBox3, "Center");
        this.answeringADifferentQuestionCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setHorizontalAlignment(10);
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messageBundle").getString("bad.feedback.answer.different"));
        jPanel3.add((Component)jCheckBox2, "South");
        this.advicePanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel5.add((Component)jPanel2, "Center");
        this.adviceLabel = jLabel = new JLabel();
        jLabel.setAlignmentY(0.5f);
        jLabel.setHorizontalAlignment(2);
        jLabel.setHorizontalTextPosition(11);
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messageBundle").getString("bad.feedback.more.advice"));
        jLabel.setVerticalAlignment(0);
        jPanel2.add((Component)jLabel, "North");
        this.adviceScrollPanel = jScrollPane = new JScrollPane();
        jScrollPane.setFocusable(true);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setPreferredSize(new Dimension(-1, 100));
        jScrollPane.setVerticalScrollBarPolicy(20);
        jPanel2.add((Component)jScrollPane, "Center");
        this.adviceTextPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(-1, -1));
        jPanel.setAlignmentX(0.5f);
        jPanel.setAlignmentY(0.5f);
        jPanel.setAutoscrolls(false);
        jPanel.setPreferredSize(new Dimension(-1, 100));
        jPanel.setRequestFocusEnabled(true);
        jScrollPane.setViewportView(jPanel);
        this.shareTheContextOfCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messageBundle").getString("bad.feedback.share.context"));
        jPanel5.add((Component)jCheckBox, "Last");
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.basePanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

