/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.ui.search.generate;

import com.alibabacloud.intellij.qoder.chat.model.ChatAskInput;
import com.alibabacloud.intellij.qoder.core.Cosy;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.AuthStatus;
import com.alibabacloud.intellij.qoder.core.lsp.model.params.DelChatRecordParams;
import com.alibabacloud.intellij.qoder.icons.QoderIcons;
import com.alibabacloud.intellij.qoder.layout.RightFlowLayout;
import com.alibabacloud.intellij.qoder.service.TelemetryService;
import com.alibabacloud.intellij.qoder.ui.BaseComponent;
import com.alibabacloud.intellij.qoder.ui.chat.AIAssistantPanel;
import com.alibabacloud.intellij.qoder.ui.notifications.NotificationFactory;
import com.alibabacloud.intellij.qoder.ui.search.component.AvatarLabel;
import com.alibabacloud.intellij.qoder.ui.search.component.DynamicPanel;
import com.alibabacloud.intellij.qoder.ui.search.component.RefreshColorComponent;
import com.alibabacloud.intellij.qoder.ui.search.component.RoundRectPanel;
import com.alibabacloud.intellij.qoder.ui.search.component.ToolbarLabel;
import com.alibabacloud.intellij.qoder.ui.search.component.chat.ChatContextTagButton;
import com.alibabacloud.intellij.qoder.ui.search.component.markdown.MarkdownComponent;
import com.alibabacloud.intellij.qoder.ui.search.component.markdown.MarkdownStreamPanel;
import com.alibabacloud.intellij.qoder.ui.search.component.markdown.TextMarkdownComponent;
import com.alibabacloud.intellij.qoder.ui.search.enums.SessionTypeEnum;
import com.alibabacloud.intellij.qoder.ui.search.enums.SnapshotStatusEnum;
import com.alibabacloud.intellij.qoder.ui.search.generate.GenerateAnswerPanel;
import com.alibabacloud.intellij.qoder.ui.search.generate.input.ChatContextTagsPanel;
import com.alibabacloud.intellij.qoder.ui.search.generate.input.ChatInputContext;
import com.alibabacloud.intellij.qoder.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.qoder.ui.search.model.ChatContextTag;
import com.alibabacloud.intellij.qoder.ui.search.model.Snapshot;
import com.alibabacloud.intellij.qoder.ui.search.topic.AnswerPanelMouseEnteredNotifier;
import com.alibabacloud.intellij.qoder.ui.search.topic.AnswerPanelMouseExitedNotifier;
import com.alibabacloud.intellij.qoder.ui.search.topic.ChatFilteredNotifier;
import com.alibabacloud.intellij.qoder.ui.search.topic.LanguageChangedNotifier;
import com.alibabacloud.intellij.qoder.ui.search.topic.QuestionFormDisableNotifier;
import com.alibabacloud.intellij.qoder.ui.search.topic.QuestionFormEnableNotifier;
import com.alibabacloud.intellij.qoder.ui.search.topic.QuestionFormMouseEnteredNotifier;
import com.alibabacloud.intellij.qoder.ui.search.topic.QuestionFormMouseExitedNotifier;
import com.alibabacloud.intellij.qoder.util.ColorUtil;
import com.alibabacloud.intellij.qoder.util.CosyDateUtil;
import com.alibabacloud.intellij.qoder.util.CosyKeymapUtil;
import com.alibabacloud.intellij.qoder.util.LoginUtil;
import com.alibabacloud.intellij.qoder.util.SwingUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Computable;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ChatQuestionForm
implements BaseComponent {
    private static final Logger LOG = Logger.getInstance(ChatQuestionForm.class);
    public static final String BASE_PANEL_NAME_PREFIX = "ChatQuestionForm_BasePanel_";
    private static final int CODE_BLOCK_MAX_HEIGHT = 400;
    protected JPanel basePanel;
    protected JPanel headerPanel;
    protected JPanel contentPanel;
    private JPanel headerToolbarPanel;
    private JLabel userInfoLabel;
    private JLabel timeLabel;
    private JLabel filteredIconLabel;
    private JLabel restoreLabel;
    protected JLabel deleteLabel;
    private Balloon filterBalloon;
    protected MarkdownStreamPanel questionText;
    private String value;
    private String requestId;
    private Date date;
    private String sessionId;
    private MessageBusConnection messageBusConnection;
    private Project project;
    private String chatTask;
    private String sessionType;
    private boolean restored;
    ChatContextTagsPanel tagsPanel;
    JPanel seperatorPanel;
    private GenerateAnswerPanel generateAnswerPanel;
    protected MouseListener baseMouseListener;

    public ChatQuestionForm(Project project, JComponent parentComponent, String value, Date questionTime, ChatAskInput chatAskInput, String requestId, String chatTask, String sessionType, GenerateAnswerPanel generateAnswerPanel) {
        this.$$$setupUI$$$();
        this.baseMouseListener = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                ChatQuestionForm.this.timeLabel.setVisible(true);
                ChatQuestionForm.this.deleteLabel.setVisible(!SessionTypeEnum.DEVELOPER.getType().equals(ChatQuestionForm.this.sessionType));
                ChatQuestionForm.this.restoreLabel.setVisible(ChatQuestionForm.this.hasChanges());
                ((QuestionFormMouseEnteredNotifier)ChatQuestionForm.this.project.getMessageBus().syncPublisher(QuestionFormMouseEnteredNotifier.MOUSE_ENTERED_NOTIFIER)).mouseEntered(ChatQuestionForm.this.getRequestId());
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ChatQuestionForm.this.timeLabel.setVisible(false);
                ChatQuestionForm.this.deleteLabel.setVisible(false);
                ChatQuestionForm.this.restoreLabel.setVisible(false);
                ((QuestionFormMouseExitedNotifier)ChatQuestionForm.this.project.getMessageBus().syncPublisher(QuestionFormMouseExitedNotifier.MOUSE_EXITED_NOTIFIER)).mouseExited(ChatQuestionForm.this.getRequestId());
            }
        };
        this.value = value;
        this.project = project;
        this.chatTask = chatTask;
        this.sessionType = sessionType;
        this.requestId = requestId;
        this.generateAnswerPanel = generateAnswerPanel;
        this.restored = false;
        this.questionText = new MarkdownStreamPanel(project, parentComponent, generateAnswerPanel, 400);
        this.tagsPanel = new ChatContextTagsPanel(new ChatInputContext(project, null, null, sessionType), ChatContextTagsPanel.USAGE_QUESTION_PANEL);
        this.tagsPanel.setBorder((Border)JBUI.Borders.empty((int)0, (int)12, (int)8, (int)12));
        List<ChatContextTag> tags = null;
        if (chatAskInput != null) {
            if (chatAskInput.getTags() != null) {
                this.questionText.setTags(chatAskInput.getTags());
            }
            if (chatAskInput.getChatInputElements() != null) {
                this.questionText.append(chatAskInput.toMarkdownLabelString(true), false);
                this.questionText.append("\n", false);
            }
            tags = chatAskInput.getContextTags();
        }
        if (tags != null) {
            tags.forEach(this.tagsPanel::addTag);
        }
        if (tags != null && tags.size() > 0) {
            this.seperatorPanel = new JPanel(new BorderLayout());
            JSeparator separator = new JSeparator(0);
            separator.setForeground(ColorUtil.getToolWindowBackgroundColor());
            this.seperatorPanel.add((Component)separator, "Center");
            this.seperatorPanel.setBorder((Border)JBUI.Borders.empty((int)0, (int)12, (int)8, (int)12));
            this.contentPanel.add((Component)this.tagsPanel, "North");
            this.contentPanel.add((Component)this.seperatorPanel, "Center");
            this.contentPanel.add((Component)this.questionText, "South");
        } else {
            this.contentPanel.add((Component)this.questionText, "Center");
        }
        if (StringUtils.isNotBlank((CharSequence)value)) {
            this.questionText.append(value, false);
        }
        AuthStatus authStatus = LoginUtil.getAuthStatusCacheFirst(project);
        ((AvatarLabel)this.userInfoLabel).setStatus(authStatus);
        this.date = new Date();
        if (questionTime != null) {
            this.date = questionTime;
        }
        this.headerToolbarPanel.setBorder((Border)JBUI.Borders.emptyTop((int)8));
        this.headerToolbarPanel.setLayout(new RightFlowLayout(2, 16, 0));
        this.timeLabel.setText(CosyDateUtil.getAskTime(this.date));
        this.timeLabel.setForeground(ColorUtil.getAuxiliaryForegroundColor());
        this.timeLabel.setVisible(false);
        this.filteredIconLabel.setText("");
        this.filteredIconLabel.setIcon(QoderIcons.SecurityIcon);
        this.filteredIconLabel.setBorder((Border)JBUI.Borders.emptyRight((int)6));
        this.filteredIconLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                ChatQuestionForm.this.filterBalloon = NotificationFactory.showToast((JComponent)ChatQuestionForm.this.filteredIconLabel, MessageType.INFO, CosyBundle.message("message.chat.filtered", new Object[0]));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ChatQuestionForm.this.filterBalloon.hide();
            }
        });
        this.filteredIconLabel.setVisible(false);
        this.filteredIconLabel.setEnabled(false);
        this.basePanel.setBackground(ColorUtil.getChatCardBackgroundColor());
        SwingUtil.foreachChildComponent(this.basePanel, cp -> {
            Boolean isCodePane = (Boolean)cp.getClientProperty("codePane");
            if (isCodePane != null && isCodePane.booleanValue()) {
                return;
            }
            if (cp != this.basePanel && cp instanceof JPanel && !(cp instanceof RoundRectPanel) && !(cp instanceof ChatContextTagButton)) {
                cp.setOpaque(false);
                cp.setBackground(ColorUtil.getChatCardChildBackgroundColor());
            }
        });
        this.headerPanel.setBorder((Border)JBUI.Borders.empty((int)0, (int)12));
        SwingUtil.foreachChildComponent(this.basePanel, cp -> cp.addMouseListener(this.baseMouseListener));
        SwingUtil.foreachChildComponent(this.questionText, cp -> cp.setOpaque(false));
        this.messageBusConnection = project.getMessageBus().connect();
        this.messageBusConnection.subscribe(LanguageChangedNotifier.LANGUAGE_CHANGED_NOTIFIER, this::updateUiTexts);
        this.messageBusConnection.subscribe(ChatFilteredNotifier.CHAT_FILTERED_NOTIFICATION, this::showChatFilteredMessage);
        this.messageBusConnection.subscribe(AnswerPanelMouseEnteredNotifier.MOUSE_ENTERED_NOTIFIER, this::mouseEntered);
        this.messageBusConnection.subscribe(AnswerPanelMouseExitedNotifier.MOUSE_EXITED_NOTIFIER, this::mouseExited);
        this.messageBusConnection.subscribe(QuestionFormDisableNotifier.QUESTION_FORM_DISABLE_NOTIFIER, this::disableChatQuestionForm);
        this.messageBusConnection.subscribe(QuestionFormEnableNotifier.QUESTION_FORM_ENABLE_NOTIFIER, this::enableChatQuestionForm);
    }

    private void mouseEntered(String requestId) {
        if (StringUtils.equals((CharSequence)this.requestId, (CharSequence)requestId)) {
            this.timeLabel.setVisible(true);
            this.deleteLabel.setVisible(!SessionTypeEnum.DEVELOPER.getType().equals(this.sessionType));
            this.restoreLabel.setVisible(this.hasChanges());
            this.headerToolbarPanel.revalidate();
            this.headerToolbarPanel.repaint();
        }
    }

    private void mouseExited(String requestId) {
        if (StringUtils.equals((CharSequence)this.requestId, (CharSequence)requestId)) {
            this.timeLabel.setVisible(false);
            this.deleteLabel.setVisible(false);
            this.restoreLabel.setVisible(false);
            this.headerToolbarPanel.revalidate();
            this.headerToolbarPanel.repaint();
        }
    }

    private boolean hasChanges() {
        AIAssistantPanel panel = (AIAssistantPanel)this.generateAnswerPanel.getGenerateContentForm();
        return panel.getWorkingSpacePanel().getSnapshots().get().stream().anyMatch(e -> StringUtils.equals((CharSequence)e.getRequestId(), (CharSequence)this.requestId) && !SnapshotStatusEnum.OUTDATED.id.equals(e.getStatus()) && (!e.isInvalid() || this.restored));
    }

    @Override
    public int getPreferredWidth() {
        return 0;
    }

    @Override
    public int getPreferredHeight() {
        return 0;
    }

    @Override
    public JComponent getComponent() {
        return this.basePanel;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
        if (StringUtils.isNotBlank((CharSequence)requestId) && this.basePanel != null) {
            this.basePanel.setName(BASE_PANEL_NAME_PREFIX + requestId);
        }
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void showChatFilteredMessage() {
        this.filteredIconLabel.setEnabled(true);
        this.filteredIconLabel.setVisible(true);
    }

    private void createUIComponents() {
        this.basePanel = new RoundRectPanel(){

            @Override
            public void refreshColor(EditorColorsScheme scheme, Color themeColor) {
                SwingUtil.foreachChildComponent(ChatQuestionForm.this.basePanel, cp -> {
                    if (cp instanceof JPanel && !(cp instanceof RefreshColorComponent)) {
                        cp.setBackground(ColorUtil.getChatCardBackgroundColor());
                    }
                });
            }
        };
        ((RoundRectPanel)this.basePanel).setCornorBackgroundColor(ColorUtil.getToolWindowBackgroundColor());
        if (StringUtils.isNotBlank((CharSequence)this.requestId)) {
            this.basePanel.setName(BASE_PANEL_NAME_PREFIX + this.requestId);
        }
        this.basePanel.setBackground(ColorUtil.getChatCardBackgroundColor());
        this.headerPanel = new DynamicPanel(40, ColorUtil.getChatCardBackgroundColor());
        this.headerPanel.setBorder((Border)JBUI.Borders.empty());
        this.userInfoLabel = new AvatarLabel(null, 20);
        this.restoreLabel = new JLabel(QoderIcons.UndoGrey20Icon);
        this.restoreLabel.setBorder((Border)JBUI.Borders.emptyLeft((int)6));
        this.restoreLabel.setCursor(Cursor.getPredefinedCursor(12));
        this.restoreLabel.setVisible(false);
        this.deleteLabel = new ToolbarLabel(QoderIcons.DeleteGreyIcon, QoderIcons.DeleteGreyIcon, QoderIcons.DeleteGreyIcon);
        this.deleteLabel.setBorder((Border)JBUI.Borders.emptyLeft((int)6));
        this.deleteLabel.setCursor(Cursor.getPredefinedCursor(12));
        this.deleteLabel.setVisible(false);
    }

    private void updateUiTexts() {
        this.timeLabel.setText(CosyDateUtil.getAskTime(this.date));
        this.deleteLabel.setToolTipText(CosyBundle.message("chat.delete.tooltip", new Object[0]));
        this.restoreLabel.setToolTipText(CosyBundle.message(this.restored ? "chat.redo.tooltip" : "chat.undo.tooltip", new Object[0]));
    }

    private void showChatFilteredMessage(String requestId) {
        if (this.requestId.equals(requestId)) {
            this.filteredIconLabel.setEnabled(true);
            this.filteredIconLabel.setVisible(true);
        }
    }

    public void addDeleteListener(final JPanel flowPanel, final JComponent chatQuestionForm, final JComponent chatAnswerPanel, final Computable<Boolean> callback) {
        this.deleteLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                for (int index = 0; index < flowPanel.getComponentCount(); ++index) {
                    if (!flowPanel.getComponent(index).equals(chatAnswerPanel) || index >= flowPanel.getComponentCount() - 1) continue;
                    Component nextComponent = flowPanel.getComponent(index + 1);
                    if (nextComponent == null) break;
                    String panelName = nextComponent.getName();
                    if (panelName == null || !panelName.startsWith("clearContext_")) continue;
                    flowPanel.remove(index + 1);
                    String clearChatRequestId = panelName.replace("clearContext_", "");
                    DelChatRecordParams delChatRecordParams = new DelChatRecordParams(ChatQuestionForm.this.sessionId, clearChatRequestId);
                    Cosy.INSTANCE.getLanguageService(ChatQuestionForm.this.project).deleteChatById(delChatRecordParams);
                    break;
                }
                flowPanel.remove(chatAnswerPanel);
                flowPanel.remove(chatQuestionForm);
                callback.compute();
                DelChatRecordParams delChatRecordParams = new DelChatRecordParams(ChatQuestionForm.this.sessionId, ChatQuestionForm.this.requestId);
                Cosy.INSTANCE.getLanguageService(ChatQuestionForm.this.project).deleteChatById(delChatRecordParams);
                TelemetryService.getInstance().telemetryChatDelete(ChatQuestionForm.this.project, ChatQuestionForm.this.requestId, ChatQuestionForm.this.sessionId, ChatQuestionForm.this.chatTask, SessionTypeEnum.getByType(ChatQuestionForm.this.sessionType).getTelemetryType());
            }
        });
    }

    public void addRestoreListener() {
        this.restoreLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                AIAssistantPanel panel = (AIAssistantPanel)ChatQuestionForm.this.generateAnswerPanel.getGenerateContentForm();
                int index = -1;
                List<Snapshot> snapshots = panel.getWorkingSpacePanel().getSnapshots().get();
                for (int i = 0; i < snapshots.size(); ++i) {
                    if (!StringUtils.equals((CharSequence)snapshots.get(i).getRequestId(), (CharSequence)ChatQuestionForm.this.requestId)) continue;
                    index = i;
                    break;
                }
                if (index >= 0 && index < snapshots.size() - 1) {
                    if (ChatQuestionForm.this.restored) {
                        ChatQuestionForm.this.generateAnswerPanel.stopChatSync();
                        panel.getWorkingSpacePanel().switchSnapshot(panel.getWorkingSpacePanel().getCurrentSnapShot().get(), snapshots.get(0));
                        ChatQuestionForm.this.restoreLabel.setIcon(QoderIcons.UndoGrey20Icon);
                        ChatQuestionForm.this.restoreLabel.setToolTipText(CosyBundle.message("chat.undo.tooltip", new Object[0]));
                        ChatQuestionForm.this.restored = false;
                    } else {
                        panel.getWorkingSpacePanel().createSwitchSnapshotConfirmDialog(new Point(e.getLocationOnScreen().x - 10, e.getLocationOnScreen().y + 10), panel.getWorkingSpacePanel().getCurrentSnapShot().get(), snapshots.get(index + 1), CosyBundle.message("chat.undo.dialog.title", new Object[0]), CosyBundle.message("chat.redo.dialog.ok", CosyKeymapUtil.getKeyStrokeShortcutText(KeyStroke.getKeyStroke(10, 0))), CosyBundle.message("chat.redo.dialog.cancel", CosyKeymapUtil.getEscKeyText()), CosyBundle.message("chat.undo.dialog.content", new Object[0]), unused -> {
                            ChatQuestionForm.this.restoreLabel.setIcon(QoderIcons.RedoGrey20Icon);
                            ChatQuestionForm.this.restoreLabel.setToolTipText(CosyBundle.message("chat.redo.tooltip", new Object[0]));
                            ChatQuestionForm.this.restored = true;
                        });
                    }
                }
            }
        });
    }

    public void disableChatQuestionForm(List<String> requestIds) {
        if (CollectionUtils.isEmpty(requestIds)) {
            return;
        }
        if (requestIds.contains(this.getRequestId())) {
            this.userInfoLabel.setForeground(ColorUtil.getAuxiliaryForegroundColor());
            SwingUtil.foreachChildComponent(this.contentPanel, cp -> {
                if (!(cp instanceof JSeparator)) {
                    cp.setForeground(ColorUtil.getAuxiliaryForegroundColor());
                }
            });
            if (CollectionUtils.isNotEmpty(this.questionText.getBlocks())) {
                this.questionText.getBlocks().forEach(block -> {
                    MarkdownComponent component = block.getComponent();
                    if (component != null && component instanceof TextMarkdownComponent) {
                        TextMarkdownComponent textMarkdownComponent = (TextMarkdownComponent)component;
                        textMarkdownComponent.disableTextMarkdown();
                    }
                });
            }
        }
    }

    public void enableChatQuestionForm(List<String> requestIds) {
        if (CollectionUtils.isEmpty(requestIds)) {
            return;
        }
        if (requestIds.contains(this.getRequestId())) {
            this.userInfoLabel.setForeground(ColorUtil.getTextForegroundColor());
            SwingUtil.foreachChildComponent(this.contentPanel, cp -> {
                if (!(cp instanceof JSeparator)) {
                    cp.setForeground(ColorUtil.getTextForegroundColor());
                }
            });
            if (CollectionUtils.isNotEmpty(this.questionText.getBlocks())) {
                this.questionText.getBlocks().forEach(block -> {
                    MarkdownComponent component = block.getComponent();
                    if (component != null && component instanceof TextMarkdownComponent) {
                        TextMarkdownComponent textMarkdownComponent = (TextMarkdownComponent)component;
                        textMarkdownComponent.enableTextMarkdown();
                    }
                });
            }
        }
    }

    @Generated
    public ChatContextTagsPanel getTagsPanel() {
        return this.tagsPanel;
    }

    @Generated
    public JPanel getSeperatorPanel() {
        return this.seperatorPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JLabel jLabel;
        JLabel jLabel2;
        JPanel jPanel2;
        this.createUIComponents();
        JPanel jPanel3 = this.basePanel;
        jPanel3.setLayout(new BorderLayout(0, 0));
        JPanel jPanel4 = this.headerPanel;
        jPanel4.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel4, "North");
        JLabel jLabel3 = this.userInfoLabel;
        jLabel3.setText("Label");
        jPanel4.add((Component)jLabel3, "West");
        this.headerToolbarPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(1, 12, 3));
        jPanel2.setMinimumSize(new Dimension(66, 20));
        jPanel2.setPreferredSize(new Dimension(240, 20));
        jPanel4.add((Component)jPanel2, "East");
        this.timeLabel = jLabel2 = new JLabel();
        jLabel2.setText("");
        Component component = jPanel2.add(jLabel2);
        this.filteredIconLabel = jLabel = new JLabel();
        jLabel.setText("");
        Component component2 = jPanel2.add(jLabel);
        JLabel jLabel4 = this.restoreLabel;
        jLabel4.setText("");
        jLabel4.setToolTipText(ResourceBundle.getBundle("messageBundle").getString("chat.undo.tooltip"));
        Component component3 = jPanel2.add(jLabel4);
        JLabel jLabel5 = this.deleteLabel;
        jLabel5.setText("");
        jLabel5.setToolTipText(ResourceBundle.getBundle("messageBundle").getString("chat.delete.tooltip"));
        Component component4 = jPanel2.add(jLabel5);
        this.contentPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel, "Center");
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.basePanel;
    }
}

