/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.ui.search.generate;

import com.alibabacloud.intellij.qoder.chat.enums.AgentTagEnum;
import com.alibabacloud.intellij.qoder.chat.enums.ChatTaskEnum;
import com.alibabacloud.intellij.qoder.chat.enums.TriggerPlaceEnum;
import com.alibabacloud.intellij.qoder.chat.model.ChatAskInput;
import com.alibabacloud.intellij.qoder.chat.model.task.dto.SimpleTextDto;
import com.alibabacloud.intellij.qoder.chat.processor.ActionTriggerHelper;
import com.alibabacloud.intellij.qoder.common.BuildFeature;
import com.alibabacloud.intellij.qoder.common.CosyCacheKeys;
import com.alibabacloud.intellij.qoder.common.CosyConfig;
import com.alibabacloud.intellij.qoder.constants.ActionConstants;
import com.alibabacloud.intellij.qoder.constants.CosyKey;
import com.alibabacloud.intellij.qoder.constants.InputConstants;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.ChatStep;
import com.alibabacloud.intellij.qoder.search.enums.TrackEventTypeEnum;
import com.alibabacloud.intellij.qoder.service.TelemetryService;
import com.alibabacloud.intellij.qoder.ui.BaseComponent;
import com.alibabacloud.intellij.qoder.ui.chat.BaseChatPanel;
import com.alibabacloud.intellij.qoder.ui.search.QoderToolWindowPanel;
import com.alibabacloud.intellij.qoder.ui.search.component.TabLabel;
import com.alibabacloud.intellij.qoder.ui.search.enums.SessionTypeEnum;
import com.alibabacloud.intellij.qoder.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.qoder.ui.search.model.CodeWithExt;
import com.alibabacloud.intellij.qoder.ui.search.model.GenerateInput;
import com.alibabacloud.intellij.qoder.ui.search.model.SuggestPrompt;
import com.alibabacloud.intellij.qoder.ui.search.model.tag.ChatAskTag;
import com.alibabacloud.intellij.qoder.ui.search.model.tag.TaskChatAskTag;
import com.alibabacloud.intellij.qoder.ui.search.topic.AnyGenerateNotifier;
import com.alibabacloud.intellij.qoder.ui.search.topic.GenerateAskNotifier;
import com.alibabacloud.intellij.qoder.ui.search.topic.GenerateStateUpdateNotifier;
import com.alibabacloud.intellij.qoder.ui.search.topic.GenerateStepCallbackNotifier;
import com.alibabacloud.intellij.qoder.ui.search.topic.GenerateStreamPauseNotifier;
import com.alibabacloud.intellij.qoder.ui.search.topic.GenerateStreamPushNotifier;
import com.alibabacloud.intellij.qoder.ui.search.topic.GenerateStreamStopNotifier;
import com.alibabacloud.intellij.qoder.ui.search.topic.SecurityFilterTimeoutNotifier;
import com.alibabacloud.intellij.qoder.util.ChatSessionUtil;
import com.alibabacloud.intellij.qoder.util.ChatTaskUtil;
import com.alibabacloud.intellij.qoder.util.ColorUtil;
import com.alibabacloud.intellij.qoder.util.FileUtil;
import com.alibabacloud.intellij.qoder.util.RecentQueryUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Point;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class GenerateContentForm
extends BaseChatPanel
implements BaseComponent,
Disposable {
    private static final Logger log = Logger.getInstance(GenerateContentForm.class);
    private static final int EDITOR_MAX_HEIGHT = 320;
    private static final int COSY_GENERATE_TIMEOUT = 30;
    private static final int COSY_STEP_GENERATE_TIMEOUT = 60;
    private JPanel expandPanel;
    private JLabel expandLabel;

    public GenerateContentForm(Project project) {
        super(project);
        if (this.initInput != null) {
            if (this.initInput.getChatTask() != null) {
                this.triggerAsk(this.initInput, ChatSessionUtil.getRequestId(SessionTypeEnum.CHAT.getType()));
            } else if (!Boolean.FALSE.equals(CosyCacheKeys.NEED_INIT_WELCOME_WINDOW.get((UserDataHolder)project))) {
                SwingUtilities.invokeLater(() -> this.showWelcomeInfoPanel(true));
                CosyCacheKeys.NEED_INIT_WELCOME_WINDOW.set((UserDataHolder)project, (Object)Boolean.TRUE);
            }
        }
    }

    @Override
    protected String getChatMainVerticalScrollbarKey() {
        return "CHAT_MAIN_VERTICAL_SCROLLBAR_KEY";
    }

    @Override
    protected void registerMessageListener() {
        super.registerMessageListener();
        this.messageBusConnection.subscribe(GenerateStreamPushNotifier.GENERATE_STREAM_PUSH_NOTIFICATION, this::pushGenerate);
        this.messageBusConnection.subscribe(GenerateStreamStopNotifier.GENERATE_STREAM_STOP_NOTIFICATION, this::stopGenerate);
        this.messageBusConnection.subscribe(GenerateStreamPauseNotifier.GENERATE_STREAM_PAUSE_NOTIFICATION, this::pauseGenerate);
        this.messageBusConnection.subscribe(SecurityFilterTimeoutNotifier.SECURITY_FILTER_TIMEOUT_NOTIFICATION, this::processFilterTimeout);
        this.messageBusConnection.subscribe(GenerateStepCallbackNotifier.GENERATE_PROCESS_STEP_CALLBACK_NOTIFICATION, this::processStepCallback);
        this.messageBusConnection.subscribe(GenerateStateUpdateNotifier.GENERATE_STATE_UPDATE_NOTIFICATION, this::updateGenerateState);
        this.messageBusConnection.subscribe(GenerateAskNotifier.GENERATE_ASK_NOTIFIER, this::triggerAsk);
        if (CosyConfig.getFeature(BuildFeature.VPC_ENABLED.getKey(), false)) {
            this.messageBusConnection.subscribe(AnyGenerateNotifier.ANY_GENERATE_NOTIFICATION, this::anyGenerate);
        }
    }

    @Override
    public void switchPanel(QoderToolWindowPanel toolWindowPanel) {
        super.switchPanel(toolWindowPanel);
        ((TabLabel)toolWindowPanel.getChatTabBtn()).setExternBorder(JBUI.Borders.customLine((Color)ColorUtil.getTabbedUnderlineColor(), (int)0, (int)0, (int)2, (int)0));
        ((TabLabel)toolWindowPanel.getAiDeveloperTabBtn()).setExternBorder((Border)JBUI.Borders.emptyBottom((int)2));
    }

    @Override
    public SessionTypeEnum getSessionTypeEnum() {
        return SessionTypeEnum.CHAT;
    }

    @Override
    public String getSessionTab() {
        return "chat";
    }

    @Override
    public String getWelcomeMessage() {
        return CosyBundle.messageVpc("message.chat.quick.ask", new Object[0]);
    }

    @Override
    protected void processStepCallback(String requestId, String sessionId, ChatStep chatStep) {
        super.processStepCallback(requestId, sessionId, chatStep);
        this.scheduleChatTimeout(requestId, this.initInput, 60L);
    }

    private void processFilterTimeout(String requestId) {
        if (this.answerPanel == null) {
            return;
        }
        if (this.answerPanel.getRequestId() != null && !this.answerPanel.getRequestId().equals(requestId)) {
            return;
        }
        this.drawLineWithKey("line.filter.timeout");
        this.flowPanel.remove(this.answerPanel.getComponent());
        this.answerPanel.setRequestId("");
        this.enableSendButton();
    }

    public void dispose() {
        if (this.messageBusConnection != null) {
            this.messageBusConnection.disconnect();
            this.messageBusConnection = null;
        }
    }

    @Override
    protected void setupTextArea() {
        this.inputPanel.addEnterKeyListener(this::processEnterKey);
    }

    @Override
    protected void triggerAskWithActionId(String text, String actionId, List<ChatAskTag> tags, ChatAskInput chatAskInput) {
        this.isAnswering.set(true);
        if (StringUtils.isEmpty((CharSequence)actionId)) {
            List terminalTagList = tags.stream().filter(tag -> tag.getText().equals(AgentTagEnum.TERMINAL.getName())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(terminalTagList)) {
                this.triggerTerminalAsk(this.initInput, chatAskInput, text);
            } else {
                this.initInput.setChatAskInput(chatAskInput);
                this.triggerFreeInput(this.initInput, text);
            }
        } else {
            String finalActionId = actionId;
            RecentQueryUtil.addRecentComplexQuery(this.project, chatAskInput);
            SwingUtilities.invokeLater(() -> ActionTriggerHelper.triggerSelectionAction(this.project, finalActionId, TriggerPlaceEnum.ASK_INPUT_PANEL.getName(), chatAskInput));
        }
    }

    private void triggerFreeInput(GenerateInput input, String text) {
        boolean containsCode;
        List<ChatAskTag> chatAskTags;
        ChatAskInput chatAskInput = input.getChatAskInput();
        if (StringUtils.isBlank((CharSequence)input.getChatAskInput().getText())) {
            chatAskTags = chatAskInput.getTags();
            if (CollectionUtils.isEmpty(chatAskTags)) {
                return;
            }
            List tagsAllowTextNull = chatAskTags.stream().filter(chatAskTag -> "task".equals(chatAskTag.getType()) || AgentTagEnum.LINGMA.getId().equals(chatAskTag.getId())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(tagsAllowTextNull)) {
                return;
            }
        }
        chatAskTags = chatAskInput.getTags();
        List agentTask = chatAskTags.stream().filter(chatAskTag -> "agent".equals(chatAskTag.getType())).collect(Collectors.toList());
        List builtInTask = chatAskTags.stream().filter(chatAskTag -> "task".equals(chatAskTag.getType())).collect(Collectors.toList());
        List scopeTask = chatAskInput.getContextTags().stream().map(tag -> ChatAskTag.buildTagFromContext(tag)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(agentTask) && CollectionUtils.isEmpty(builtInTask)) {
            String actionId;
            SuggestPrompt suggestPrompt;
            String actionId2;
            if (StringUtils.isNotBlank((CharSequence)text) && InputConstants.WELCOMING_SUGGEST_PROMPT_MAP.containsKey(text.substring(1)) && InputConstants.WELCOMING_SUGGEST_PROMPT_MAP.get(text.substring(1)).getActionCommand().startsWith("action:") && ActionConstants.TRIGGER_SELECTION_CODE_ACTION_LIST.contains(actionId2 = (suggestPrompt = InputConstants.WELCOMING_SUGGEST_PROMPT_MAP.get(text.substring(1))).getActionCommand().substring("action:".length()))) {
                this.inputPanel.addTag(new TaskChatAskTag(suggestPrompt.getId(), suggestPrompt.getText()));
                return;
            }
            if (StringUtils.isNotBlank((CharSequence)text) && InputConstants.CONTEXT_SUGGEST_PROMPT_MAP.containsKey(text.substring(1)) && InputConstants.CONTEXT_SUGGEST_PROMPT_MAP.get(text.substring(1)).getActionCommand().startsWith("action:") && ActionConstants.TRIGGER_COSY_CLEAR_HISTORY_ACTION.equals(actionId = InputConstants.CONTEXT_SUGGEST_PROMPT_MAP.get(text.substring(1)).getActionCommand().substring("action:".length()))) {
                this.clearChat(this.initInput.getChatContext().getSessionId(), UUID.randomUUID().toString());
                return;
            }
            if (StringUtils.isNotBlank((CharSequence)text) && InputConstants.WELCOMING_HELP_MAP.containsKey(text.substring(1)) && InputConstants.WELCOMING_HELP_MAP.get(text.substring(1)).getActionCommand().startsWith("action:") && ActionConstants.TRIGGER_COSY_HELP_ACTION.equals(actionId = InputConstants.WELCOMING_HELP_MAP.get(text.substring(1)).getActionCommand().substring("action:".length()))) {
                this.showHelpAnswer();
                this.inputPanel.resetRecentQueryIndex();
                RecentQueryUtil.addRecentComplexQuery(this.project, input.getChatAskInput());
                return;
            }
        }
        input.setChatTask(ChatTaskEnum.FREE_INPUT.name());
        this.inputPanel.resetRecentQueryIndex();
        RecentQueryUtil.addRecentComplexQuery(this.project, input.getChatAskInput());
        String code = this.checkSelectionCodeInclusion(this.project);
        if (code != null) {
            input.getChatContext().setSourceCode(code);
            StringBuilder sb = new StringBuilder();
            String language = input.getChatContext().getFileLanguage();
            sb.append(text).append("\n```").append(language != null ? language : "").append("\n").append(input.getChatContext().getSourceCode()).append("\n```");
            text = sb.toString();
        }
        input.setQuestion(text);
        SimpleTextDto simpleTextDto = new SimpleTextDto();
        simpleTextDto.setText(text);
        input.setQuestionObject(simpleTextDto);
        boolean isFirstRoundChat = input.getChatHistory() != null && CollectionUtils.isEmpty(input.getChatHistory().getAskAnswerList());
        boolean bl = containsCode = input.getChatContext() != null && StringUtils.isNotBlank((CharSequence)input.getChatContext().getSourceCode()) && StringUtils.isNotBlank((CharSequence)input.getChatContext().getFilePath());
        if (isFirstRoundChat && containsCode) {
            this.questionCodeWithExt = CodeWithExt.builder().content(input.getChatContext().getSourceCode()).filePath(input.getChatContext().getFilePath()).ext(FileUtil.getPathExt(input.getChatContext().getFilePath())).build();
        }
        SessionTypeEnum sessionTypeEnum = SessionTypeEnum.getByType(this.sessionType);
        String requestId = ChatSessionUtil.getRequestId(sessionTypeEnum.getType());
        TelemetryService.getInstance().telemetryChatTask(this.project, TrackEventTypeEnum.CHAT_FREE_INPUT, requestId, input.getChatContext().getSessionId(), ChatTaskEnum.FREE_INPUT.getName(), input, sessionTypeEnum.getTelemetryType());
        this.prepareAndAsynchronousChat(input, text, text, requestId);
        ChatSessionUtil.updateRequestId(sessionTypeEnum.getType());
    }

    private void triggerTerminalAsk(GenerateInput input, ChatAskInput chatAskInput, String text) {
        if (StringUtils.isBlank((CharSequence)text)) {
            List<ChatAskTag> chatAskTags = chatAskInput.getTags();
            if (CollectionUtils.isEmpty(chatAskTags)) {
                return;
            }
            List tagsAllowTextNull = chatAskTags.stream().filter(chatAskTag -> "task".equals(chatAskTag.getType()) || AgentTagEnum.LINGMA.getId().equals(chatAskTag.getId())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(tagsAllowTextNull)) {
                return;
            }
        }
        input.setChatTask(ChatTaskEnum.TERMINAL_COMMAND_GENERATION.name());
        input.setChatAskInput(chatAskInput);
        this.inputPanel.resetRecentQueryIndex();
        RecentQueryUtil.addRecentComplexQuery(this.project, input.getChatAskInput());
        this.inputPanel.clearTags();
        input.setQuestion(text);
        SimpleTextDto simpleTextDto = new SimpleTextDto();
        simpleTextDto.setText(text);
        input.setQuestionObject(simpleTextDto);
        String requestId = UUID.randomUUID().toString();
        TelemetryService.getInstance().telemetryChatTask(this.project, TrackEventTypeEnum.CHAT_FREE_INPUT, requestId, input.getChatContext().getSessionId(), ChatTaskEnum.TERMINAL_COMMAND_GENERATION.getName(), input, SessionTypeEnum.getByType(this.sessionType).getTelemetryType());
        this.prepareAndAsynchronousChat(input, text, text, requestId);
    }

    private String checkSelectionCodeInclusion(Project project) {
        Map map = (Map)ApplicationManager.getApplication().getUserData(CosyKey.PROJECT_FREE_INPUT_SELECTION_CODE_MAP);
        String lastSelectionCode = "";
        if (map != null && map.get(project.getName()) != null) {
            lastSelectionCode = (String)map.get(project.getName());
        }
        String code = this.recordSelectionCode(project);
        if (lastSelectionCode != null && lastSelectionCode.equals(code)) {
            return null;
        }
        return code;
    }

    @Override
    protected String getChatTaskForAsynchronousChat(GenerateInput input) {
        return ChatTaskUtil.getQuickAskChatTask(input);
    }

    @Override
    public int getPreferredWidth() {
        return 0;
    }

    @Override
    public int getPreferredHeight() {
        return 0;
    }

    @Override
    public JComponent getComponent() {
        return this.basePanel;
    }

    private void updateGenerateState(String state) {
        if (this.answerPanel == null) {
            return;
        }
        this.answerPanel.updateGenerateState(state);
    }

    @Override
    public String getNewChatText() {
        return CosyBundle.message("main.toolbar.btn.new.chat", new Object[0]);
    }

    @Override
    public void createNewTask(QoderToolWindowPanel toolPanel, Point location) {
        toolPanel.switchChatPanel(this);
        this.initFlowPanel();
    }

    @Generated
    public void setExpandPanel(JPanel expandPanel) {
        this.expandPanel = expandPanel;
    }

    @Generated
    public void setExpandLabel(JLabel expandLabel) {
        this.expandLabel = expandLabel;
    }

    @Generated
    public JPanel getExpandPanel() {
        return this.expandPanel;
    }

    @Generated
    public JLabel getExpandLabel() {
        return this.expandLabel;
    }
}

