/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.ui.search.generate;

import com.alibabacloud.intellij.qoder.chat.model.ReportDiagnosisLogParam;
import com.alibabacloud.intellij.qoder.chat.model.result.ReportDiagnosisLogResult;
import com.alibabacloud.intellij.qoder.core.Cosy;
import com.alibabacloud.intellij.qoder.icons.CommonIcons;
import com.alibabacloud.intellij.qoder.icons.QoderIcons;
import com.alibabacloud.intellij.qoder.ui.notifications.NotificationFactory;
import com.alibabacloud.intellij.qoder.ui.search.component.RoundRectPanel;
import com.alibabacloud.intellij.qoder.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.qoder.util.ColorUtil;
import com.alibabacloud.intellij.qoder.util.FileUtil;
import com.alibabacloud.intellij.qoder.util.StringUtils;
import com.alibabacloud.intellij.qoder.util.SwingUtil;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTextArea;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.TransferHandler;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.compress.utils.FileNameUtils;
import org.jdesktop.swingx.VerticalLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IssueReportDialog
extends DialogWrapper {
    private static final Logger log = Logger.getInstance(IssueReportDialog.class);
    private static final long MAX_IMAGE_SIZE_BYTES = 0x500000L;
    private static final int MAX_IMAGE_COUNT = 5;
    private final Project project;
    private final JBTextArea issueText;
    private final JPanel mainPanel;
    private final JTextPane imageTipsPanel;
    private final RoundRectPanel imageTextPanel;
    private final Set<String> imagePathList;
    private final JPanel addedImagePanel;
    private final JLabel addImageLabel;

    public IssueReportDialog(@Nullable Project project) {
        super(project, true);
        this.project = project;
        this.imagePathList = new HashSet<String>();
        this.mainPanel = new JPanel((LayoutManager)new VerticalLayout(8));
        this.mainPanel.setBorder((Border)JBUI.Borders.emptyTop((int)8));
        JLabel imageLabel = new JLabel(CosyBundle.message("issue.report.dialog.issue.image", new Object[0]));
        imageLabel.setForeground(ColorUtil.getTextForegroundColor());
        this.addImageLabel = new JLabel(QoderIcons.AddImageGrey20Icon);
        this.imageTipsPanel = new JTextPane();
        this.imageTipsPanel.setEditable(false);
        StyledDocument doc = this.imageTipsPanel.getStyledDocument();
        SimpleAttributeSet attrs = new SimpleAttributeSet();
        StyleConstants.setAlignment(attrs, 1);
        doc.setParagraphAttributes(0, doc.getLength(), attrs, false);
        this.imageTipsPanel.setOpaque(false);
        this.imageTipsPanel.setBackground(ColorUtil.getEditorBackgroundColor());
        this.imageTipsPanel.setText(CosyBundle.message("issue.report.dialog.upload.image.description", new Object[0]));
        this.imageTipsPanel.setForeground(ColorUtil.getAuxiliaryForegroundColor());
        this.imageTextPanel = new RoundRectPanel((LayoutManager)new VerticalLayout(0), 8);
        this.imageTextPanel.setBorder(JBUI.Borders.empty((int)8));
        this.imageTextPanel.setBackground(ColorUtil.getEditorBackgroundColor());
        this.imageTextPanel.add(this.addImageLabel);
        this.imageTextPanel.add(Box.createVerticalStrut(12));
        this.imageTextPanel.add(this.imageTipsPanel);
        this.addedImagePanel = new JPanel((LayoutManager)new VerticalLayout(4));
        this.addedImagePanel.setVisible(false);
        JPanel imagePanel = new JPanel((LayoutManager)new VerticalLayout(8));
        imagePanel.add(imageLabel);
        imagePanel.add(this.imageTextPanel);
        imagePanel.add(this.addedImagePanel);
        JPanel descriptionPanel = new JPanel((LayoutManager)new VerticalLayout(8));
        descriptionPanel.setBorder((Border)JBUI.Borders.emptyTop((int)8));
        JLabel descriptionLabel = new JLabel(CosyBundle.message("issue.report.dialog.issue.description", new Object[0]));
        descriptionLabel.setForeground(ColorUtil.getTextForegroundColor());
        this.issueText = new JBTextArea();
        this.issueText.setAlignmentX(0.5f);
        this.issueText.getEmptyText().setText(CosyBundle.message("issue.report.dialog.issue.placeholder", new Object[0]));
        this.issueText.setBorder(JBUI.Borders.empty((int)8));
        this.issueText.setBackground(ColorUtil.getEditorBackgroundColor());
        this.issueText.setLineWrap(true);
        this.issueText.setWrapStyleWord(true);
        this.issueText.setEditable(true);
        this.issueText.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent documentEvent) {
                if (documentEvent == null) {
                    1.$$$reportNull$$$0(0);
                }
                IssueReportDialog.this.setOKActionEnabled(!IssueReportDialog.this.issueText.getText().isEmpty());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "documentEvent", "com/alibabacloud/intellij/qoder/ui/search/generate/IssueReportDialog$1", "textChanged"));
            }
        });
        RoundRectPanel issueTextPanel = new RoundRectPanel((LayoutManager)new BorderLayout(), 8);
        JBScrollPane adviceScrollPanel = new JBScrollPane((Component)this.issueText);
        adviceScrollPanel.setBorder((Border)JBUI.Borders.emptyBottom((int)8));
        adviceScrollPanel.setPreferredSize(new Dimension(600, 100));
        issueTextPanel.add((Component)adviceScrollPanel, "Center");
        this.issueText.setOpaque(false);
        adviceScrollPanel.setOpaque(false);
        adviceScrollPanel.getViewport().setOpaque(false);
        SwingUtil.foreachChildComponent(issueTextPanel, cp -> cp.setBackground(ColorUtil.getEditorBackgroundColor()));
        descriptionPanel.add((Component)descriptionLabel, "North");
        descriptionPanel.add((Component)issueTextPanel, "Center");
        this.mainPanel.add((Component)imagePanel, "North");
        this.mainPanel.add((Component)descriptionPanel, "Center");
        this.setImagePanel();
        this.init();
        this.setTitle(CosyBundle.message("issue.report.dialog.title", new Object[0]));
        this.setOKButtonText(CosyBundle.message("issue.report.dialog.submit", new Object[0]));
        this.setCancelButtonText(CosyBundle.message("issue.report.dialog.cancel", new Object[0]));
        this.setOKActionEnabled(false);
        this.setResizable(false);
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JPanel dialogPanel = new JPanel(new BorderLayout());
        dialogPanel.add((Component)this.mainPanel, "Center");
        return dialogPanel;
    }

    protected void doOKAction() {
        IssueReportDialog.reportIssue(this.project, this.issueText.getText(), this.imagePathList);
        super.doOKAction();
    }

    public static void reportIssue(Project project, String issueText) {
        IssueReportDialog.reportIssue(project, issueText, Collections.emptyList());
    }

    public static void reportIssue(Project project, String issueText, Collection<String> imagePaths) {
        String logPath = PathManager.getLogPath() + "/idea.log";
        ReportDiagnosisLogParam param = new ReportDiagnosisLogParam(issueText, logPath, imagePaths);
        ReportDiagnosisLogResult result = Cosy.INSTANCE.getLanguageService(project).reportIssue(param, 60000L);
        if (null != result && null != result.getResult()) {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            StringSelection selection = new StringSelection(result.getResult().getFeedbackId());
            clipboard.setContents(selection, selection);
            NotificationFactory.showInfoNotificationWithTitle(project, CosyBundle.message("issue.report.dialog.submit.succeed.description", new Object[0]));
        }
    }

    public final void setImagePanel() {
        SwingUtil.foreachChildComponent(this.imageTextPanel, cp -> cp.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (IssueReportDialog.this.allowToAddImage()) {
                    IssueReportDialog.this.imageTextPanel.setBorderColor(JBUI.CurrentTheme.Focus.focusColor());
                    IssueReportDialog.this.imageTextPanel.revalidate();
                    IssueReportDialog.this.imageTextPanel.repaint();
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (null != IssueReportDialog.this.imageTextPanel.getBorderColor()) {
                    IssueReportDialog.this.imageTextPanel.setBorderColor(null);
                    IssueReportDialog.this.imageTextPanel.revalidate();
                    IssueReportDialog.this.imageTextPanel.repaint();
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!IssueReportDialog.this.allowToAddImage()) {
                    NotificationFactory.showToast((JComponent)IssueReportDialog.this.imageTextPanel, MessageType.ERROR, CosyBundle.message("issue.report.dialog.image.count.limit", new Object[0]));
                    return;
                }
                FileChooserDescriptor descriptor = new FileChooserDescriptor(true, true, false, false, false, true).withFileFilter(virtualFile -> {
                    String extension = org.apache.commons.lang3.StringUtils.lowerCase((String)FileNameUtils.getExtension((String)virtualFile.getName()));
                    return FileUtil.VALIDATE_IMAGE_EXT.contains(extension);
                }).withShowHiddenFiles(false).withTitle(CosyBundle.message("suggest.choose.image.dialog.title", new Object[0]));
                FileChooser.chooseFiles((FileChooserDescriptor)descriptor, (Project)IssueReportDialog.this.project, null, files -> {
                    VirtualFile file;
                    if (CollectionUtils.isEmpty((Collection)files)) {
                        return;
                    }
                    Iterator iterator = files.iterator();
                    while (iterator.hasNext() && !IssueReportDialog.this.checkLimitAndProcessImageFile((file = (VirtualFile)iterator.next()).getPresentableUrl(), file.getName(), file.getLength())) {
                    }
                });
            }
        }));
        this.imageTipsPanel.setTransferHandler(new TransferHandler("files"){
            private static final long serialVersionUID = -4471099667771199318L;

            @Override
            public boolean canImport(TransferHandler.TransferSupport support) {
                return support.isDataFlavorSupported(DataFlavor.javaFileListFlavor);
            }

            @Override
            public boolean importData(TransferHandler.TransferSupport support) {
                if (!IssueReportDialog.this.allowToAddImage()) {
                    NotificationFactory.showToast((JComponent)IssueReportDialog.this.imageTextPanel, MessageType.ERROR, CosyBundle.message("suggest.prompt.popup.image.file.limit", new Object[0]));
                    return false;
                }
                if (!this.canImport(support)) {
                    return false;
                }
                try {
                    File file;
                    List files = (List)support.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                    Iterator iterator = files.iterator();
                    while (iterator.hasNext() && !IssueReportDialog.this.checkLimitAndProcessImageFile((file = (File)iterator.next()).getPath(), file.getName(), file.length())) {
                    }
                }
                catch (Exception e) {
                    log.warn("import image data error", (Throwable)e);
                }
                return false;
            }
        });
    }

    private boolean checkLimitAndProcessImageFile(String filePath, String fileName, long fileSize) {
        if (filePath.isEmpty()) {
            log.warn("filePath is empty, fileName is " + fileName);
        } else if (this.allowToAddImage()) {
            if (!this.imagePathList.contains(filePath)) {
                if (!FileUtil.VALIDATE_IMAGE_EXT.contains(org.apache.commons.lang3.StringUtils.lowerCase((String)FileNameUtils.getExtension((String)fileName)))) {
                    NotificationFactory.showToast((JComponent)this.imageTextPanel, MessageType.ERROR, CosyBundle.message("issue.report.dialog.image.type.invalid", new Object[0]));
                    return false;
                }
                if (fileSize > 0x500000L) {
                    NotificationFactory.showToast((JComponent)this.imageTextPanel, MessageType.ERROR, CosyBundle.message("issue.report.dialog.image.size.limit", new Object[0]));
                    return false;
                }
                this.imagePathList.add(filePath);
                this.addedImagePanel.add(this.createAddedImagePanel(filePath, fileName));
                this.addedImagePanel.setVisible(true);
                this.addedImagePanel.revalidate();
                this.addedImagePanel.repaint();
            }
        } else {
            this.addImageLabel.setIcon(QoderIcons.AddImageDisabledGrey20Icon);
            this.addImageLabel.revalidate();
            this.addImageLabel.repaint();
            NotificationFactory.showToast((JComponent)this.imageTextPanel, MessageType.ERROR, CosyBundle.message("issue.report.dialog.image.count.limit", new Object[0]));
            return true;
        }
        return false;
    }

    private JPanel createAddedImagePanel(final String filePath, String fileName) {
        final RoundRectPanel imagePanel = new RoundRectPanel((LayoutManager)new BorderLayout(), 8);
        imagePanel.setBorder((Border)JBUI.Borders.empty((int)0, (int)8));
        imagePanel.add((Component)new JLabel(StringUtils.truncateMiddle(fileName, 128), QoderIcons.ImageGreyIcon, 0), "West");
        JLabel removeLabel = new JLabel(CommonIcons.errorGreyIcon);
        imagePanel.add((Component)removeLabel, "East");
        removeLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                IssueReportDialog.this.imagePathList.remove(filePath);
                IssueReportDialog.this.addedImagePanel.remove(imagePanel);
                IssueReportDialog.this.addedImagePanel.setVisible(!IssueReportDialog.this.imagePathList.isEmpty());
                IssueReportDialog.this.addedImagePanel.revalidate();
                IssueReportDialog.this.addedImagePanel.repaint();
            }
        });
        SwingUtil.foreachChildComponent(imagePanel, cp -> cp.setBackground(ColorUtil.getEditorBackgroundColor()));
        return imagePanel;
    }

    private boolean allowToAddImage() {
        return this.imagePathList.size() < 5;
    }
}

