/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.ui.search.generate;

import com.alibabacloud.intellij.qoder.ui.chat.BaseChatAgentPanel;
import com.alibabacloud.intellij.qoder.ui.search.QoderToolWindowPanel;
import com.alibabacloud.intellij.qoder.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.qoder.util.ColorUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import org.jetbrains.annotations.Nullable;

public class NewTaskDialog
extends DialogWrapper {
    protected final BaseChatAgentPanel chatPanel;
    private final QoderToolWindowPanel toolPanel;

    public NewTaskDialog(@Nullable Project project, Point location, BaseChatAgentPanel chatPanel, QoderToolWindowPanel toolPanel) {
        super(project, true);
        this.init();
        this.setTitle(this.getTitleText());
        this.setOKButtonText(CosyBundle.message("new.task.dialog.confirm", new Object[0]));
        this.setCancelButtonText(CosyBundle.message("new.task.dialog.cancel", new Object[0]));
        this.setLocation(location);
        this.setResizable(false);
        this.setInitialLocationCallback(() -> location);
        this.chatPanel = chatPanel;
        this.toolPanel = toolPanel;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JPanel dialogPanel = new JPanel(new BorderLayout());
        dialogPanel.setForeground(ColorUtil.getLabelForegroundColor());
        JTextPane textPane = new JTextPane(){

            @Override
            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                if (dimension.width > 60) {
                    dimension.width = 60;
                }
                return dimension;
            }
        };
        textPane.setFont((Font)JBUI.Fonts.label().deriveFont(13.0f));
        textPane.setOpaque(false);
        textPane.setEditable(false);
        textPane.setText(this.getContentText());
        textPane.setForeground(ColorUtil.getLabelForegroundColor());
        dialogPanel.add((Component)textPane, "Center");
        return dialogPanel;
    }

    protected String getTitleText() {
        return CosyBundle.message("new.task.dialog.title", new Object[0]);
    }

    protected String getContentText() {
        return CosyBundle.message("new.task.dialog.content", new Object[0]);
    }

    protected void doOKAction() {
        super.doOKAction();
        this.toolPanel.switchChatPanel(this.chatPanel);
        this.chatPanel.initFlowPanel();
        this.chatPanel.stopSessionChat();
    }
}

