/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.ui.search.generate;

import com.alibabacloud.intellij.qoder.chat.model.ChatAskInput;
import com.alibabacloud.intellij.qoder.chat.model.task.DisplayTask;
import com.alibabacloud.intellij.qoder.search.enums.TrackEventTypeEnum;
import com.alibabacloud.intellij.qoder.service.TelemetryService;
import com.alibabacloud.intellij.qoder.ui.chat.BaseChatPanel;
import com.alibabacloud.intellij.qoder.ui.search.component.DisplayLabel;
import com.alibabacloud.intellij.qoder.ui.search.enums.SessionTypeEnum;
import com.alibabacloud.intellij.qoder.ui.search.model.ChatInputElement;
import com.alibabacloud.intellij.qoder.ui.search.model.GenerateInput;
import com.alibabacloud.intellij.qoder.util.ChatTaskUtil;
import com.alibabacloud.intellij.qoder.util.ColorUtil;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.WrapLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class QuickAskPanel
extends JPanel {
    private final JPanel questionTagPanel;
    private final Project project;
    private final BaseChatPanel parentComponent;

    public QuickAskPanel(Project project, BaseChatPanel parentComponent, GenerateInput input, List<DisplayTask> displayTasks) {
        super(new BorderLayout());
        this.project = project;
        this.parentComponent = parentComponent;
        this.questionTagPanel = new JPanel((LayoutManager)new WrapLayout(3, 8, 8));
        this.questionTagPanel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
        this.add((Component)this.questionTagPanel, "Center");
        this.setOpaque(false);
        this.questionTagPanel.setOpaque(false);
        for (DisplayTask displayTask : displayTasks) {
            String displayText = displayTask.getDisplayTextLocale();
            DisplayLabel label = new DisplayLabel(displayText, ColorUtil.getToolWindowBackgroundColor(), null);
            label.setExtraData(displayTask);
            label.setChatTask(displayTask.getChatTask());
            label.setCursor(Cursor.getPredefinedCursor(12));
            this.registerTagAction(label, input);
            this.questionTagPanel.add(label);
        }
    }

    public QuickAskPanel(Project project, BaseChatPanel parentComponent, GenerateInput input, List<DisplayTask> displayTasks, String message) {
        this(project, parentComponent, input, displayTasks);
        JLabel messageLabel = new JLabel(message, 2);
        messageLabel.setForeground(ColorUtil.getAuxiliaryForegroundColor());
        this.questionTagPanel.add(messageLabel);
    }

    public boolean containsToolOperate2QuickPanel() {
        DisplayLabel displayLabel;
        Component component;
        return SessionTypeEnum.ASSISTANT.getType().equals(this.parentComponent.getSessionType()) && this.questionTagPanel != null && (component = this.questionTagPanel.getComponent(0)) instanceof DisplayLabel && (displayLabel = (DisplayLabel)component).getChatTask() != null && displayLabel.getChatTask().startsWith("CODER_APPROVE");
    }

    private void registerTagAction(final DisplayLabel label, final GenerateInput input) {
        label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (QuickAskPanel.this.project != null && input != null) {
                    if (label.getChatTask() != null) {
                        input.setChatTask(label.getChatTask());
                    }
                    DisplayTask displayTask = (DisplayTask)label.getExtraData();
                    String requestId = UUID.randomUUID().toString();
                    TelemetryService.getInstance().telemetryChatTask(QuickAskPanel.this.project, TrackEventTypeEnum.CHAT_TRIGGER_QUICK_ASK, requestId, input.getChatContext().getSessionId(), ChatTaskUtil.getQuickAskChatTask(input), input, QuickAskPanel.this.parentComponent.getSessionTypeEnum().getTelemetryType());
                    ChatAskInput chatAskInput = new ChatAskInput();
                    ArrayList<ChatInputElement> elements = new ArrayList<ChatInputElement>();
                    ChatInputElement textElement = new ChatInputElement();
                    elements.add(textElement);
                    textElement.setType("text");
                    textElement.setText(displayTask.getDisplayTextLocale());
                    chatAskInput.setChatInputElements(elements);
                    input.setChatAskInput(chatAskInput);
                    QuickAskPanel.this.parentComponent.prepareAndAsynchronousChat(input, displayTask.getPrompt(), displayTask.getDisplayTextLocale(), requestId);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                label.setBackground(ColorUtil.getEditorBackgroundColor());
            }

            @Override
            public void mouseExited(MouseEvent e) {
                label.setBackground(ColorUtil.getToolWindowBackgroundColor());
            }
        });
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        Dimension qaSize = this.questionTagPanel.getPreferredSize();
        return new Dimension(size.width, qaSize.height);
    }
}

