/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.ui.search.generate;

import com.alibabacloud.intellij.qoder.ui.notifications.NotificationFactory;
import com.alibabacloud.intellij.qoder.ui.search.I18NConstant;
import com.alibabacloud.intellij.qoder.ui.search.component.DiffEditableWindow;
import com.alibabacloud.intellij.qoder.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.qoder.util.DocumentUtils;
import com.alibabacloud.intellij.qoder.util.FileUtil;
import com.alibabacloud.intellij.qoder.util.StringUtils;
import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffManager;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class ShowDiffAction
extends AnAction {
    private static final Logger log = Logger.getInstance(ShowDiffAction.class);
    Project project;
    String sourceContent;
    String content;
    String ext;
    String filePath;

    public ShowDiffAction(@NotNull Project project, String sourceContent, String content, String ext, String filePath) {
        if (project == null) {
            ShowDiffAction.$$$reportNull$$$0(0);
        }
        this.project = project;
        this.sourceContent = sourceContent;
        this.content = content;
        this.ext = ext;
        this.filePath = filePath;
    }

    public void actionPerformed(@NotNull AnActionEvent anActionEvent) {
        if (anActionEvent == null) {
            ShowDiffAction.$$$reportNull$$$0(1);
        }
        if (this.content == null || this.ext == null || this.filePath == null) {
            log.warn("There is no question code to compare.");
            NotificationFactory.showWarnNotification(this.project, I18NConstant.CHAT_NOTIFY_SELECT_CODE);
            return;
        }
        VirtualFile targetFile = LocalFileSystem.getInstance().findFileByPath(this.filePath);
        int index = this.filePath.lastIndexOf(FileUtil.getFileSeparator(this.filePath));
        String path = this.project.getBasePath();
        String fileNameExt = this.filePath.substring(index + 1);
        if (index > 0) {
            log.warn("bad fullPath when show diff:" + this.filePath);
            path = this.filePath.substring(0, index);
        }
        if (targetFile != null && targetFile.exists() && path != null) {
            this.showDiffView(targetFile, this.sourceContent, this.content, path, fileNameExt);
        } else {
            log.warn("target file not exists, use original diff view.");
            String questionTmpFileName = "question_" + System.currentTimeMillis() + ".temp";
            String answerTmpFileName = "answer_" + System.currentTimeMillis() + ".temp";
            FileType fileType = FileTypeRegistry.getInstance().getFileTypeByExtension(this.ext);
            if (fileType instanceof UnknownFileType) {
                fileType = FileTypes.PLAIN_TEXT;
            }
            VirtualFile beforeFile = FileUtil.buildVirtualFile(questionTmpFileName, fileType, this.content, false);
            VirtualFile afterFile = FileUtil.buildVirtualFile(answerTmpFileName, fileType, this.content, false);
            DiffContentFactory diffContentFactory = DiffContentFactory.getInstance();
            DiffContent beforeChangeContent = diffContentFactory.create(this.project, beforeFile);
            DiffContent afterChangeContent = diffContentFactory.create(this.project, afterFile);
            SimpleDiffRequest diffRequest = new SimpleDiffRequest("File Comparison", beforeChangeContent, afterChangeContent, "Before Change", "After Change");
            DiffManager.getInstance().showDiff(this.project, (DiffRequest)diffRequest);
        }
    }

    private void showDiffView(final VirtualFile targetFile, String sourceContent, String content, final String path, String fileNameExt) {
        String fileContent;
        ArrayList<DiffEditableWindow.DiffButtonAction> buttonActions = new ArrayList<DiffEditableWindow.DiffButtonAction>();
        final String finalFileNameWithExt = fileNameExt;
        content = StringUtils.makeIndentationConsistent(sourceContent, content);
        final String finalFileContent = fileContent = this.createNewFileDiffContent(targetFile, sourceContent, content);
        buttonActions.add(new DiffEditableWindow.DiffCancelAction(CosyBundle.message("chat.diffview.button.cancel", new Object[0])));
        buttonActions.add(new DiffEditableWindow.DiffButtonAction(CosyBundle.message("chat.diffview.button.newfile", new Object[0])){

            @Override
            public void doAction() {
                Path dirPath;
                VirtualFile directory = LocalFileSystem.getInstance().findFileByPath(path);
                if (directory == null && !Files.exists(dirPath = Paths.get(path, new String[0]), new LinkOption[0])) {
                    try {
                        Path newPath = Files.createDirectories(dirPath, new FileAttribute[0]);
                        directory = LocalFileSystem.getInstance().refreshAndFindFileByNioFile(newPath);
                    }
                    catch (IOException e) {
                        log.error(String.format("Cannot create path %s caused by %s", path, e.getMessage()));
                    }
                }
                String newFileName = finalFileNameWithExt;
                VirtualFile targetFile = LocalFileSystem.getInstance().findFileByPath(path + FileUtil.getFileSeparator(path) + finalFileNameWithExt);
                if (targetFile != null && targetFile.exists()) {
                    int idx = finalFileNameWithExt.lastIndexOf(".");
                    String fileName = finalFileNameWithExt;
                    if (idx > -1) {
                        fileName = finalFileNameWithExt.substring(0, idx);
                    }
                    newFileName = String.format("%s_%d.%s", fileName, System.currentTimeMillis(), ShowDiffAction.this.ext);
                }
                ShowDiffAction.this.createNewFile(directory, newFileName, finalFileContent);
            }
        });
        buttonActions.add(new DiffEditableWindow.DiffAcceptAction(CosyBundle.message("chat.diffview.button.accept", new Object[0])){

            @Override
            public void doAccept(String content) {
                WriteCommandAction.runWriteCommandAction((Project)ShowDiffAction.this.project, () -> {
                    Document document = FileDocumentManager.getInstance().getDocument(targetFile);
                    if (document != null) {
                        String textToInsert = DocumentUtils.filterDocumentSlashR(document, content);
                        document.setText((CharSequence)textToInsert);
                    }
                });
            }
        });
        DiffEditableWindow dialog = new DiffEditableWindow(this.project, targetFile, fileContent, buttonActions);
        dialog.setTitle(CosyBundle.message("chat.diffview.label.title", new Object[0]));
        dialog.show();
    }

    private String createNewFileDiffContent(VirtualFile targetFile, String sourceContent, String content) {
        if (targetFile == null || !targetFile.exists()) {
            log.warn("Target file not exists, use diff snippet instead.");
            return content;
        }
        Document document = FileDocumentManager.getInstance().getDocument(targetFile);
        if (document == null) {
            log.warn("Cannot get document from " + targetFile.getName());
            return content;
        }
        String originalFileContent = document.getText();
        if (originalFileContent.contains(sourceContent)) {
            log.info("Found original content snippet, replace with new diff content.");
            return StringUtils.replaceFirst(originalFileContent, sourceContent, content);
        }
        log.info("Cannot find original content snippet, append new diff content to the end of original file content.");
        return String.format("%s\n%s", originalFileContent, content);
    }

    private void createNewFile(VirtualFile directory, String newFileName, String fileContent) {
        WriteCommandAction.runWriteCommandAction((Project)this.project, () -> {
            try {
                VirtualFile file = directory.createChildData((Object)this, newFileName);
                Document document = FileDocumentManager.getInstance().getDocument(file);
                if (document != null) {
                    String textToInsert = DocumentUtils.filterDocumentSlashR(document, fileContent);
                    document.setText((CharSequence)textToInsert);
                }
                FileEditorManager.getInstance((Project)this.project).openFile(file, false, true);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anActionEvent";
                break;
            }
        }
        objectArray2[1] = "com/alibabacloud/intellij/qoder/ui/search/generate/ShowDiffAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

