/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.ui.search.generate.input;

import com.alibabacloud.intellij.qoder.core.lsp.model.model.AuthStateEnum;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.AuthStatus;
import com.alibabacloud.intellij.qoder.ui.search.QoderToolWindowPanel;
import com.alibabacloud.intellij.qoder.ui.search.generate.input.ChatContextTagsPanel;
import com.alibabacloud.intellij.qoder.ui.search.generate.input.ChatInputContext;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.util.List;
import javax.swing.TransferHandler;

public class ChatContextTagsDropTargetListener
extends TransferHandler
implements DropTargetListener {
    private static final Logger LOG = Logger.getInstance(ChatContextTagsDropTargetListener.class);
    ChatInputContext inputContext;
    ChatContextTagsPanel inputTagsPanel;

    public ChatContextTagsDropTargetListener(ChatInputContext inputContext) {
        this.inputContext = inputContext;
        this.inputTagsPanel = inputContext.getInputMainPanel().getInputTagsPanel();
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        if (dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            // empty if block
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        if (dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            // empty if block
        }
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        return support.isDataFlavorSupported(DataFlavor.javaFileListFlavor);
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        if (support.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            return this.handleFileDrag(support.getTransferable());
        }
        return false;
    }

    private boolean handleFileDrag(Transferable transferable) {
        try {
            AuthStatus authStatus = QoderToolWindowPanel.getAuthStatusFromCache();
            if (AuthStateEnum.LOGIN.getValue() != authStatus.getStatus().intValue()) {
                LOG.warn("handleFileDrag failed, not login");
                return false;
            }
            List files = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
            if (files != null && !files.isEmpty()) {
                return this.inputContext.getInputMainPanel().getInputTagsController().addTagByFiles(files, 2);
            }
        }
        catch (Exception e) {
            LOG.warn("drag file error:" + e.getMessage(), (Throwable)e);
        }
        return false;
    }
}

