/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.ui.search.generate.input;

import com.alibabacloud.intellij.qoder.ui.search.generate.input.ChatContextTagsPanel;
import com.alibabacloud.intellij.qoder.ui.search.generate.input.ChatInputContext;
import com.alibabacloud.intellij.qoder.ui.search.generate.input.ChatInputTextArea;
import com.alibabacloud.intellij.qoder.ui.search.topic.ChatInputFocusMoveNotifier;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.messages.MessageBusConnection;
import org.jetbrains.annotations.NotNull;

public class ChatInputFocusController {
    private static final Logger LOG = Logger.getInstance(ChatInputFocusController.class);
    ChatInputContext inputContext;
    ChatInputTextArea textArea;

    public ChatInputFocusController(@NotNull ChatInputContext inputContext, @NotNull ChatInputTextArea textArea) {
        if (inputContext == null) {
            ChatInputFocusController.$$$reportNull$$$0(0);
        }
        if (textArea == null) {
            ChatInputFocusController.$$$reportNull$$$0(1);
        }
        this.inputContext = inputContext;
        this.textArea = textArea;
        this.setupEvent(inputContext.getProject());
    }

    private void setupEvent(Project project) {
        MessageBusConnection messageBusConnection = project.getMessageBus().connect();
        messageBusConnection.subscribe(ChatInputFocusMoveNotifier.TOPIC, this::notifyMoveFocus);
    }

    private void notifyMoveFocus(int direction) {
        ChatContextTagsPanel tagsPanel = this.inputContext.getInputMainPanel().getInputTagsPanel();
        if (direction == 2) {
            if (this.textArea.isFocusOwner()) {
                tagsPanel.focusTag(0);
            }
        } else if (direction == 3) {
            if (this.textArea.isFocusOwner()) {
                return;
            }
            int curIndex = tagsPanel.getFocusIndex();
            if (curIndex >= 0 && !this.textArea.isFocusOwner()) {
                this.textArea.requestFocusInWindow();
            }
        } else if (direction == 0) {
            if (this.textArea.isFocusOwner()) {
                return;
            }
            int curIndex = tagsPanel.getFocusIndex();
            if (curIndex > 0) {
                tagsPanel.focusTag(curIndex - 1);
            }
        } else if (direction == 1) {
            if (this.textArea.isFocusOwner()) {
                return;
            }
            int curIndex = tagsPanel.getFocusIndex();
            if (curIndex >= 0 || curIndex < tagsPanel.getComponentCount() - 1) {
                tagsPanel.focusTag(curIndex + 1);
            }
        } else if (direction == 4) {
            tagsPanel.focusTag(tagsPanel.getTags().size());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "inputContext";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "textArea";
                break;
            }
        }
        objectArray[1] = "com/alibabacloud/intellij/qoder/ui/search/generate/input/ChatInputFocusController";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

