/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.ui.search.generate.input;

import com.alibabacloud.intellij.qoder.common.CosyCacheKeys;
import com.alibabacloud.intellij.qoder.common.CosyConfig;
import com.alibabacloud.intellij.qoder.core.Cosy;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.AuthStateEnum;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.AuthStatus;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.ChatModelClassResult;
import com.alibabacloud.intellij.qoder.icons.QoderIcons;
import com.alibabacloud.intellij.qoder.ui.search.component.BackgroundPanel;
import com.alibabacloud.intellij.qoder.ui.search.component.chat.ChatModelChooser;
import com.alibabacloud.intellij.qoder.ui.search.component.chat.chooser.ChatModeChooser;
import com.alibabacloud.intellij.qoder.ui.search.component.chat.chooser.ChatModelClassChooser;
import com.alibabacloud.intellij.qoder.ui.search.enums.SessionTypeEnum;
import com.alibabacloud.intellij.qoder.ui.search.generate.AskInputPanel;
import com.alibabacloud.intellij.qoder.ui.search.generate.input.ChatInputContext;
import com.alibabacloud.intellij.qoder.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.qoder.ui.search.topic.AuthLoginNotifier;
import com.alibabacloud.intellij.qoder.ui.search.topic.AuthLogoutNotifier;
import com.alibabacloud.intellij.qoder.ui.search.topic.AuthStateChangeNotifier;
import com.alibabacloud.intellij.qoder.ui.search.topic.LanguageChangedNotifier;
import com.alibabacloud.intellij.qoder.util.ColorUtil;
import com.alibabacloud.intellij.qoder.util.CosyKeymapUtil;
import com.alibabacloud.intellij.qoder.util.SwingUtil;
import com.alibabacloud.intellij.qoder.util.ThreadUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;

public class ChatInputOperationPanel
extends BackgroundPanel {
    private static final Logger logger = Logger.getInstance(ChatInputOperationPanel.class);
    JLabel sendLabel;
    JPanel rightPanel = new BackgroundPanel(ColorUtil.getEditorBackgroundColor(), new BorderLayout());
    JPanel leftPanel;
    ChatInputContext chatInputContext;
    ChatModelChooser modelChooser;
    ChatModeChooser modeChooser;
    AskInputPanel askInputPanel;
    MessageBusConnection messageBusConnection;
    ChatModelClassChooser modelClassChooser;

    public ChatInputOperationPanel(ChatInputContext chatInputContext, AskInputPanel askInputPanel) {
        super(ColorUtil.getEditorBackgroundColor(), new BorderLayout());
        this.chatInputContext = chatInputContext;
        this.askInputPanel = askInputPanel;
        this.leftPanel = new JPanel(){

            @Override
            public void setBackground(Color bg) {
                super.setBackground(ColorUtil.getEditorBackgroundColor());
            }
        };
        this.setupLeftPanel();
        this.setupRightPanel();
        SwingUtil.foreachChildComponent(this, component -> component.setBackground(ColorUtil.getEditorBackgroundColor()));
        this.setBorder((Border)JBUI.Borders.emptyTop((int)0));
        SwingUtil.preventRecursiveBackgroundUpdateOnToolwindow(this);
        this.modelChooser.getBaseComponent().setVisible(false);
        this.modelClassChooser = null;
        if (null != chatInputContext && null != chatInputContext.getProject()) {
            this.messageBusConnection = chatInputContext.getProject().getMessageBus().connect();
            this.messageBusConnection.subscribe(LanguageChangedNotifier.LANGUAGE_CHANGED_NOTIFIER, this::updateUiTexts);
            this.messageBusConnection.subscribe(AuthLoginNotifier.AUTH_LOGIN_NOTIFICATION, this::onLogin);
            this.messageBusConnection.subscribe(AuthLogoutNotifier.AUTH_LOGOUT_NOTIFICATION, this::onLogout);
            this.messageBusConnection.subscribe(AuthStateChangeNotifier.AUTH_CHANGE_NOTIFICATION, this::onAuthStatusChange);
        }
    }

    private void onAuthStatusChange(AuthStatus authStatus) {
        if (authStatus != null && authStatus.getStatus() != null && authStatus.getStatus().intValue() == AuthStateEnum.LOGIN.getValue()) {
            this.onLogin(authStatus);
        } else {
            this.onLogout(authStatus);
        }
    }

    private synchronized void onLogin(AuthStatus authStatus) {
        List<ChatModelClassResult> modelClasses;
        if (CosyConfig.isQoderEnabled() && this.modelClassChooser == null && CollectionUtils.isNotEmpty(modelClasses = Cosy.INSTANCE.getLanguageService(this.askInputPanel.getProject()).queryModelClasses(this.askInputPanel.getSessionType()))) {
            this.modelClassChooser = new ChatModelClassChooser(this.askInputPanel.getProject(), this.askInputPanel, modelClasses);
            this.leftPanel.add((Component)this.modelClassChooser.getBaseComponent(), "East");
        }
    }

    private void onLogout(AuthStatus status) {
        if (null != this.leftPanel && null != this.modelClassChooser) {
            this.leftPanel.remove(this.modelClassChooser.getBaseComponent());
            this.leftPanel.revalidate();
            this.leftPanel.repaint();
            this.modelClassChooser = null;
        }
    }

    private void updateUiTexts() {
        this.sendLabel.setToolTipText(this.getShortcutLabelText());
        this.revalidate();
        this.repaint();
    }

    private String getShortcutLabelText() {
        int modifiers = 64;
        KeyStroke keyStroke = KeyStroke.getKeyStroke(10, modifiers);
        String cmdReturnKey = CosyKeymapUtil.getKeyStrokeShortcutText(keyStroke);
        keyStroke = KeyStroke.getKeyStroke(10, 0);
        String returnKey = CosyKeymapUtil.getKeyStrokeShortcutText(keyStroke);
        return String.format("%s %s / %s %s", CosyBundle.message("chat.input.new.line.shortcut.tips", new Object[0]), cmdReturnKey, CosyBundle.message("chat.input.send.shortcut.tips", new Object[0]), returnKey);
    }

    public void setupRightPanel() {
        this.sendLabel = new JLabel(QoderIcons.SendActiveIcon);
        this.sendLabel.setDisabledIcon(QoderIcons.SendDisabledIcon);
        this.sendLabel.setBackground(ColorUtil.getEditorBackgroundColor());
        this.sendLabel.setToolTipText(this.getShortcutLabelText());
        this.rightPanel.add((Component)this.sendLabel, "Center");
        this.add((Component)this.rightPanel, "East");
    }

    public void setupLeftPanel() {
        this.leftPanel.setLayout(new BorderLayout(12, 0));
        if (SessionTypeEnum.ASSISTANT.getType().equals(this.chatInputContext.getSessionType())) {
            this.modeChooser = new ChatModeChooser(this.chatInputContext.getProject(), this.askInputPanel);
            this.leftPanel.add((Component)this.modeChooser.getBaseComponent(), "West");
            AuthStatus authStatus = (AuthStatus)CosyCacheKeys.KEY_AUTH_STATUS.get((UserDataHolder)ApplicationManager.getApplication());
            if (null != authStatus && authStatus.getStatus().intValue() == AuthStateEnum.LOGIN.getValue()) {
                if (null == Cosy.INSTANCE.getLanguageService(this.askInputPanel.getProject())) {
                    ThreadUtil.execute(() -> SwingUtilities.invokeLater(() -> {
                        if (Cosy.INSTANCE.checkAndWaitCosyState(null, this.askInputPanel.getProject())) {
                            this.onLogin(authStatus);
                        }
                    }));
                } else {
                    this.onLogin(authStatus);
                }
            }
        }
        this.modelChooser = new ChatModelChooser(this.chatInputContext.getProject(), this.chatInputContext.getSessionType());
        this.leftPanel.add((Component)this.modelChooser.getBaseComponent(), "Center");
        this.add((Component)this.leftPanel, "West");
    }

    public void addSendListener(final Consumer<MouseEvent> listener) {
        this.sendLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                listener.accept(e);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                ChatInputOperationPanel.this.sendLabel.setBackground(ColorUtil.getButtonHoverBackgroundColor());
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ChatInputOperationPanel.this.sendLabel.setBackground(ColorUtil.getEditorBackgroundColor());
            }
        });
    }

    public boolean isSendEnabled() {
        return this.sendLabel.isEnabled();
    }

    public void setSendEnabled(boolean sendEnabled) {
        this.sendLabel.setEnabled(sendEnabled);
        this.sendLabel.setCursor(sendEnabled ? Cursor.getPredefinedCursor(12) : Cursor.getPredefinedCursor(0));
    }

    @Generated
    public JLabel getSendLabel() {
        return this.sendLabel;
    }

    @Generated
    public ChatModelChooser getModelChooser() {
        return this.modelChooser;
    }

    @Generated
    public ChatModeChooser getModeChooser() {
        return this.modeChooser;
    }
}

