/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.ui.search.generate.input;

import com.alibabacloud.intellij.qoder.core.lsp.model.model.AuthStateEnum;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.AuthStatus;
import com.alibabacloud.intellij.qoder.ui.search.QoderToolWindowPanel;
import com.alibabacloud.intellij.qoder.ui.search.enums.SessionTypeEnum;
import com.alibabacloud.intellij.qoder.ui.search.generate.input.ChatContextTagsPanel;
import com.alibabacloud.intellij.qoder.ui.search.generate.input.ChatInputContext;
import com.alibabacloud.intellij.qoder.ui.search.generate.input.ChatInputTextArea;
import com.alibabacloud.intellij.qoder.ui.search.topic.EditorFilePasteNotifier;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.messages.MessageBusConnection;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class ChatInputPasteController {
    private static final Logger LOG = Logger.getInstance(ChatInputPasteController.class);
    ChatInputContext inputContext;
    ChatInputTextArea textArea;
    ChatContextTagsPanel inputTagsPanel;
    MessageBusConnection messageBusConnection;

    public ChatInputPasteController(@NotNull ChatInputContext inputContext, @NotNull ChatContextTagsPanel inputTagsPanel, @NotNull ChatInputTextArea textArea, @NotNull MessageBusConnection messageBusConnection) {
        if (inputContext == null) {
            ChatInputPasteController.$$$reportNull$$$0(0);
        }
        if (inputTagsPanel == null) {
            ChatInputPasteController.$$$reportNull$$$0(1);
        }
        if (textArea == null) {
            ChatInputPasteController.$$$reportNull$$$0(2);
        }
        if (messageBusConnection == null) {
            ChatInputPasteController.$$$reportNull$$$0(3);
        }
        this.inputContext = inputContext;
        this.inputTagsPanel = inputTagsPanel;
        this.textArea = textArea;
        this.messageBusConnection = messageBusConnection;
        this.setup();
    }

    public void setup() {
        this.messageBusConnection.subscribe(EditorFilePasteNotifier.EDITOR_PASTE_FILE_NOTIFICATION, this::notifyPasteFile);
        this.inputTagsPanel.getContextAddButton().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                Transferable transferable = clipboard.getContents(this);
                if (!e.isControlDown() && !e.isMetaDown() || e.getKeyCode() != 86) {
                    LOG.warn("check keyCode error");
                    return;
                }
                String sessionType = null;
                if (ChatInputPasteController.this.inputContext != null) {
                    sessionType = ChatInputPasteController.this.inputContext.getSessionType();
                }
                ChatInputPasteController.this.pasteFile(transferable, "contextPanel", sessionType);
            }
        });
    }

    private void notifyPasteFile(Transferable transferable, String sessionType) {
        if (sessionType != null && this.inputContext != null && !sessionType.equals(this.inputContext.getSessionType())) {
            return;
        }
        this.pasteFile(transferable, "inputPanel", sessionType);
    }

    private void pasteFile(Transferable transferable, String triggerComponent, String sessionType) {
        String filePath2;
        AuthStatus authStatus = QoderToolWindowPanel.getAuthStatusFromCache();
        if (AuthStateEnum.LOGIN.getValue() != authStatus.getStatus().intValue()) {
            LOG.warn("pasteFile failed, not login");
            return;
        }
        if (transferable == null) {
            return;
        }
        List<Object> filePathList = new ArrayList();
        if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            filePathList = this.getFileFromFileTransferable(transferable);
        } else if (transferable.isDataFlavorSupported(DataFlavor.imageFlavor) && (filePath2 = this.getFileFromImageTransferable(transferable)) != null) {
            filePathList.add(filePath2);
        }
        if (CollectionUtils.isEmpty(filePathList)) {
            return;
        }
        try {
            List<File> fileList = filePathList.stream().map(filePath -> new File((String)filePath)).collect(Collectors.toList());
            LOG.debug("file size is " + fileList.size());
            int addMode = 2;
            if (StringUtils.equals((CharSequence)sessionType, (CharSequence)SessionTypeEnum.INLINE.getType())) {
                addMode = 1;
            }
            this.inputContext.getInputMainPanel().getInputTagsController().addTagByFiles(fileList, addMode);
        }
        catch (Exception ex) {
            LOG.error("paste image error " + ex);
        }
    }

    private List<String> getFileFromFileTransferable(Transferable transferable) {
        List<String> filePathList = new ArrayList<String>();
        try {
            List files = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
            if (files != null && !files.isEmpty()) {
                filePathList = files.stream().map(File::getAbsolutePath).collect(Collectors.toList());
            }
        }
        catch (Exception e) {
            LOG.warn("paste file error:" + e.getMessage(), (Throwable)e);
        }
        return filePathList;
    }

    private String getFileFromImageTransferable(Transferable transferable) {
        try {
            Image image = (Image)transferable.getTransferData(DataFlavor.imageFlavor);
            if (image == null) {
                return null;
            }
            String fileName = UUID.randomUUID().toString().substring(0, 8);
            String tempDirPath = System.getProperty("java.io.tmpdir");
            String filePath = Paths.get(tempDirPath, fileName + ".png").toString();
            File file = new File(filePath);
            BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 1);
            bufferedImage.getGraphics().drawImage(image, 0, 0, null);
            ImageIO.write((RenderedImage)bufferedImage, "png", file);
            return filePath;
        }
        catch (UnsupportedFlavorException | IOException ex) {
            LOG.error("paste image error " + ex);
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "inputContext";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "inputTagsPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "textArea";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "messageBusConnection";
                break;
            }
        }
        objectArray[1] = "com/alibabacloud/intellij/qoder/ui/search/generate/input/ChatInputPasteController";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

