/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.ui.search.generate.input;

import com.alibabacloud.intellij.qoder.constants.InputConstants;
import com.alibabacloud.intellij.qoder.ui.notifications.NotificationFactory;
import com.alibabacloud.intellij.qoder.ui.search.enums.ChatContextTypeEnum;
import com.alibabacloud.intellij.qoder.ui.search.enums.ComponentTypeEnum;
import com.alibabacloud.intellij.qoder.ui.search.generate.SelectedSuggestResult;
import com.alibabacloud.intellij.qoder.ui.search.generate.input.ChatContextTagsPanel;
import com.alibabacloud.intellij.qoder.ui.search.generate.input.ChatInputContext;
import com.alibabacloud.intellij.qoder.ui.search.generate.input.ChatInputSuggester;
import com.alibabacloud.intellij.qoder.ui.search.generate.input.ChatInputTextArea;
import com.alibabacloud.intellij.qoder.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.qoder.ui.search.model.ChatInputElement;
import com.alibabacloud.intellij.qoder.ui.search.model.SuggestPrompt;
import com.alibabacloud.intellij.qoder.ui.search.model.tag.ChatAskTag;
import com.alibabacloud.intellij.qoder.util.FileUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class ChatInputTagsController {
    private static final Logger LOG = Logger.getInstance(ChatInputTagsController.class);
    public static final int BOTH_CONTEXT_AND_ASK_TAG = 1;
    public static final int ONLY_CONTEXT_TAG = 2;
    ChatInputContext inputContext;
    ChatInputTextArea textArea;
    ChatContextTagsPanel inputTagsPanel;

    public ChatInputTagsController(@NotNull ChatInputContext inputContext, @NotNull ChatContextTagsPanel inputTagsPanel, @NotNull ChatInputTextArea textArea) {
        if (inputContext == null) {
            ChatInputTagsController.$$$reportNull$$$0(0);
        }
        if (inputTagsPanel == null) {
            ChatInputTagsController.$$$reportNull$$$0(1);
        }
        if (textArea == null) {
            ChatInputTagsController.$$$reportNull$$$0(2);
        }
        this.inputContext = inputContext;
        this.inputTagsPanel = inputTagsPanel;
        this.textArea = textArea;
    }

    private boolean isValidFile(File file) {
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        VirtualFile virtualFile = localFileSystem.refreshAndFindFileByIoFile(file);
        if (virtualFile == null) {
            LOG.warn("file not found " + file.getAbsolutePath());
            NotificationFactory.showToast((JComponent)this.inputTagsPanel, MessageType.WARNING, CosyBundle.message("notifications.invalid.file", new Object[0]));
            return false;
        }
        if (FileUtil.isFileInArchive(virtualFile, false)) {
            LOG.warn("file is in archive " + file.getAbsolutePath());
            NotificationFactory.showToast((JComponent)this.inputTagsPanel, MessageType.WARNING, CosyBundle.message("notifications.invalid.file", new Object[0]));
            return false;
        }
        if (!virtualFile.isDirectory() && virtualFile.getFileType().isBinary() && !FileUtil.isValidImageFormat(file.getAbsolutePath())) {
            LOG.warn("file is not valid binary " + file.getAbsolutePath());
            NotificationFactory.showToast((JComponent)this.inputTagsPanel, MessageType.WARNING, CosyBundle.message("notifications.invalid.binary.file", new Object[0]));
            return false;
        }
        if (FileUtil.isValidImageFormat(file.getAbsolutePath()) && FileUtil.isLargeImageFile(virtualFile)) {
            LOG.warn("file is too large " + file.getAbsolutePath());
            NotificationFactory.showToast((JComponent)this.inputTagsPanel, MessageType.WARNING, CosyBundle.message("notifications.too.large.file", new Object[0]));
            return false;
        }
        return true;
    }

    public boolean addTagByFiles(List<File> files, int addMode) {
        if (this.hasNonContextAskTag()) {
            LOG.warn("ignore non-context ask tag");
            return false;
        }
        for (File file : files) {
            if (this.isValidFile(file)) continue;
            LOG.warn("ignore invalid tag for file:" + file.getAbsolutePath());
            return false;
        }
        for (File file : files) {
            this.addTagByFile(file, addMode);
        }
        return true;
    }

    public void addTagByFile(File file, int addMode) {
        ChatInputSuggester chatInputSuggester = this.inputContext.getInputMainPanel().getChatInputSuggester();
        SuggestPrompt suggestPrompt = new SuggestPrompt();
        suggestPrompt.setId(file.getAbsolutePath());
        suggestPrompt.setText(file.getName());
        suggestPrompt.setType("context");
        suggestPrompt.setDrillDownEnable(false);
        suggestPrompt.setComponentType(ComponentTypeEnum.COMBOBOX.getType());
        HashMap<String, Object> extra = new HashMap<String, Object>();
        if (file.isDirectory()) {
            suggestPrompt.setContextName(ChatContextTypeEnum.FOLDER.getType());
            extra.put("contextType", ChatContextTypeEnum.FOLDER.getType());
            suggestPrompt.setExtra(extra);
            suggestPrompt.setContextProvider(InputConstants.SCOPE_SUGGEST_PROMPT_MAP.get(ChatContextTypeEnum.FOLDER.getType()));
        } else {
            suggestPrompt.setContextName(ChatContextTypeEnum.FILE.getType());
            extra.put("contextType", ChatContextTypeEnum.FILE.getType());
            extra.put("fileType", "file");
            extra.put("filePath", file.getAbsolutePath());
            suggestPrompt.setExtra(extra);
            suggestPrompt.setContextProvider(InputConstants.SCOPE_SUGGEST_PROMPT_MAP.get(ChatContextTypeEnum.FILE.getType()));
        }
        SelectedSuggestResult selectedSuggestResult = new SelectedSuggestResult();
        selectedSuggestResult.setSuggestPrompt(suggestPrompt);
        if (addMode == 2) {
            chatInputSuggester.triggerAddContextTag(selectedSuggestResult, true);
        } else {
            chatInputSuggester.triggerChooserSuggestPromptSelection(selectedSuggestResult);
        }
    }

    public boolean hasNonContextAskTag() {
        ChatAskTag firstTag;
        ChatInputElement firstElement;
        ChatInputTextArea textArea = this.inputContext.getInputMainPanel().getTextArea();
        List<ChatInputElement> elements = textArea.getElements();
        return elements != null && !elements.isEmpty() && (firstElement = elements.get(0)).getType().equals("tag") && ChatAskTag.nonContext(List.of(firstTag = firstElement.getTag())) != false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "inputContext";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "inputTagsPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "textArea";
                break;
            }
        }
        objectArray[1] = "com/alibabacloud/intellij/qoder/ui/search/generate/input/ChatInputTagsController";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

