/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.ui.search.generate.input;

import com.alibabacloud.intellij.qoder.common.ChatRecentQuery;
import com.alibabacloud.intellij.qoder.constants.ShortcutConstants;
import com.alibabacloud.intellij.qoder.ui.config.CosyPersistentSetting;
import com.alibabacloud.intellij.qoder.ui.search.component.textpane.ContinuousText;
import com.alibabacloud.intellij.qoder.ui.search.enums.SuggestPromptPopupPanelSourceEnum;
import com.alibabacloud.intellij.qoder.ui.search.generate.QueryRange;
import com.alibabacloud.intellij.qoder.ui.search.generate.SuggestPromptPopupPanel;
import com.alibabacloud.intellij.qoder.ui.search.generate.input.ChatContextTagsPanel;
import com.alibabacloud.intellij.qoder.ui.search.generate.input.ChatInputContext;
import com.alibabacloud.intellij.qoder.ui.search.generate.input.ChatInputTextArea;
import com.alibabacloud.intellij.qoder.ui.search.model.ChatInputElement;
import com.alibabacloud.intellij.qoder.ui.search.model.tag.ChatAskTag;
import com.alibabacloud.intellij.qoder.util.RecentQueryUtil;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.List;
import javax.swing.text.StyledDocument;
import org.apache.commons.lang3.StringUtils;

public class ChatInputTextKeyListener
extends KeyAdapter {
    private static final Logger LOGGER = Logger.getInstance(ChatInputTextKeyListener.class);
    ChatInputTextArea textArea;
    ChatInputContext inputContext;
    ChatContextTagsPanel contextTagsPanel;

    public ChatInputTextKeyListener(ChatInputTextArea textArea) {
        this.textArea = textArea;
        this.inputContext = textArea.getChatInputContext();
        this.contextTagsPanel = this.inputContext.getInputMainPanel().getInputTagsPanel();
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.popupSuggestPrompt(e);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 38 || e.getKeyCode() == 40) {
            Integer n;
            ChatRecentQuery query;
            if (CosyPersistentSetting.getInstance().getState() == null || CosyPersistentSetting.getInstance().getState().getRecentQueries() == null) {
                LOGGER.info("Recent queries not exists.");
                return;
            }
            SuggestPromptPopupPanel suggestPromptPopupPanel = this.inputContext.getInputMainPanel().getChatInputSuggester().getSuggestPromptPopupPanel();
            if (suggestPromptPopupPanel.isShowPopup()) {
                return;
            }
            String recentQueryKey = RecentQueryUtil.constructRecentQueryKey(this.inputContext.getProject(), null);
            ChatRecentQuery startQuery = this.inputContext.getRecentQueryStartMap().get(recentQueryKey);
            if (startQuery == null) {
                query = new ChatRecentQuery(this.textArea.getElements(), this.contextTagsPanel.getTags());
                this.inputContext.getRecentQueryStartMap().put(recentQueryKey, query);
            } else {
                query = startQuery;
            }
            if (this.inputContext.isEditing() && !this.isAllowSelectRecentQuery(query.getChatInputElements())) {
                return;
            }
            List<ChatRecentQuery> recentQueries = RecentQueryUtil.queryRecentComplexQueries(this.inputContext.getProject(), query.getChatInputElements());
            if (recentQueries == null || recentQueries.isEmpty()) {
                return;
            }
            Integer recentQueryIndex = this.inputContext.getRecentQueryIndexMap().get(recentQueryKey);
            if (recentQueryIndex == null || recentQueryIndex < 0) {
                recentQueryIndex = -1;
            } else if (recentQueryIndex >= recentQueries.size()) {
                recentQueryIndex = recentQueries.size();
            }
            if (e.getKeyCode() == 38) {
                if (recentQueryIndex < 0 || recentQueryIndex >= recentQueries.size()) {
                    recentQueryIndex = recentQueries.size() - 1;
                } else {
                    n = recentQueryIndex;
                    Integer n2 = recentQueryIndex = Integer.valueOf(recentQueryIndex - 1);
                }
            } else if (e.getKeyCode() == 40) {
                if (recentQueryIndex < 0) {
                    recentQueryIndex = 0;
                } else {
                    n = recentQueryIndex;
                    Integer n3 = recentQueryIndex = Integer.valueOf(recentQueryIndex + 1);
                }
            }
            if (recentQueryIndex < 0) {
                recentQueryIndex = -1;
            } else if (recentQueryIndex >= recentQueries.size()) {
                recentQueryIndex = recentQueries.size();
            }
            this.inputContext.getRecentQueryIndexMap().put(recentQueryKey, recentQueryIndex);
            if (recentQueryIndex < 0 || recentQueryIndex >= recentQueries.size()) {
                this.textArea.recoverElements(query.getChatInputElements());
                this.contextTagsPanel.recoverContextTags(query.getContextTags());
                e.consume();
                return;
            }
            ChatRecentQuery recentQuery = recentQueries.get(recentQueryIndex);
            this.textArea.recoverElements(recentQuery.getChatInputElements());
            this.contextTagsPanel.recoverContextTags(recentQuery.getContextTags());
            e.consume();
            this.inputContext.setEditing(false);
        }
    }

    private boolean isAllowSelectRecentQuery(List<ChatInputElement> elements) {
        if (elements == null || elements.size() != 1) {
            return true;
        }
        ChatInputElement firstElement = elements.get(0);
        ChatAskTag firstTag = firstElement.getTag();
        return firstTag != null && ("task".equals(firstTag.getType()) || "agent".equals(firstTag.getType()));
    }

    private void popupSuggestPrompt(KeyEvent e) {
        int caretPos;
        int keyCode = e.getKeyCode();
        if (ShortcutConstants.UP_DOWN_RELATED_KEYCODES.contains(keyCode)) {
            return;
        }
        if (27 == e.getKeyCode()) {
            return;
        }
        if (e.getKeyCode() == 10) {
            return;
        }
        StyledDocument doc = this.textArea.getStyledDocument();
        int queryPos = caretPos = this.textArea.getCaretPosition();
        try {
            SuggestPromptPopupPanel suggestPromptPopupPanel = this.inputContext.getInputMainPanel().getChatInputSuggester().getSuggestPromptPopupPanel();
            ContinuousText continuousText = this.textArea.getContinuousTextUntilCaret(queryPos);
            if (continuousText != null && StringUtils.isNotBlank((CharSequence)continuousText.getText())) {
                int start = continuousText.getStartOffset();
                String text = continuousText.getText();
                String queryType = null;
                String query = null;
                int queryStart = start;
                if (text.startsWith("#") && start == 0) {
                    queryType = "agent";
                    query = text.substring(1);
                } else if (text.startsWith("/") && start == 0) {
                    queryType = null;
                    query = text.substring(1);
                } else {
                    int scopeFlagIdx = text.lastIndexOf(64);
                    if (scopeFlagIdx >= 0) {
                        queryType = "context";
                        query = text.substring(scopeFlagIdx + 1);
                        queryStart = start + scopeFlagIdx;
                    }
                }
                if (query != null) {
                    int displayY = (int)this.inputContext.getInputMainPanel().getInputPanel().getLocationOnScreen().getY();
                    int displayX = (int)this.inputContext.getInputMainPanel().getInputPanel().getLocationOnScreen().getX();
                    LOGGER.debug("keyListener textarea query is " + query);
                    suggestPromptPopupPanel.displaySuggestPrompts(query, queryType, new Point(displayX, displayY), "inputPanel", new QueryRange(queryStart, caretPos), SuggestPromptPopupPanelSourceEnum.INPUT);
                } else {
                    suggestPromptPopupPanel.cancelPromptSuggestPopup();
                }
            } else {
                suggestPromptPopupPanel.cancelPromptSuggestPopup();
            }
        }
        catch (Exception ex) {
            LOGGER.warn("build input elements error " + ex.getMessage(), (Throwable)ex);
        }
        if (!this.textArea.getText().isEmpty()) {
            this.inputContext.setEditing(true);
            this.inputContext.getRecentQueryStartMap().clear();
        } else {
            this.inputContext.setEditing(false);
        }
    }
}

