/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.ui.search.model;

import com.alibabacloud.intellij.qoder.util.EditorUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vfs.VirtualFile;
import lombok.Generated;

public class ActiveFileInfo {
    String fileName;
    String filePath;
    Integer statLine;
    Integer endLine;
    String selectedCode;
    String fileProtocol;
    Boolean isBinary;

    public ActiveFileInfo(String fileName, String filePath, String fileProtocol, Boolean isBinary) {
        this.fileName = fileName;
        this.filePath = filePath;
        this.isBinary = isBinary;
        this.fileProtocol = fileProtocol;
    }

    public ActiveFileInfo(String fileName, String filePath, String selectedCode, Integer statLine, Integer endLine, Boolean isBinary) {
        this.fileName = fileName;
        this.filePath = filePath;
        this.selectedCode = selectedCode;
        this.statLine = statLine;
        this.endLine = endLine;
        this.isBinary = isBinary;
    }

    public static ActiveFileInfo getFromEditor(Editor editor) {
        Document document = editor.getDocument();
        VirtualFile file = FileDocumentManager.getInstance().getFile(document);
        String filePath = "";
        String fileName = "";
        String fileProtocol = "";
        Boolean isBinary = null;
        if (file != null) {
            filePath = file.getPresentableUrl();
            fileName = file.getName();
            isBinary = file.getFileType().isBinary();
            fileProtocol = file.getFileSystem().getProtocol();
        }
        ActiveFileInfo activeFileInfo = new ActiveFileInfo(fileName, filePath, fileProtocol, isBinary);
        SelectionModel selectionModel = editor.getSelectionModel();
        EditorUtil.SelectionModelInfo info = EditorUtil.getSelectionModelInfo(selectionModel);
        String selectedText = info.getSelectedText();
        if (selectedText != null) {
            activeFileInfo.setStatLine(document.getLineNumber(info.getSelectionStart()) + 1);
            activeFileInfo.setEndLine(document.getLineNumber(info.getSelectionEnd()) + 1);
            activeFileInfo.setSelectedCode(selectedText);
        }
        return activeFileInfo;
    }

    @Generated
    public String getFileName() {
        return this.fileName;
    }

    @Generated
    public String getFilePath() {
        return this.filePath;
    }

    @Generated
    public Integer getStatLine() {
        return this.statLine;
    }

    @Generated
    public Integer getEndLine() {
        return this.endLine;
    }

    @Generated
    public String getSelectedCode() {
        return this.selectedCode;
    }

    @Generated
    public String getFileProtocol() {
        return this.fileProtocol;
    }

    @Generated
    public Boolean getIsBinary() {
        return this.isBinary;
    }

    @Generated
    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @Generated
    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    @Generated
    public void setStatLine(Integer statLine) {
        this.statLine = statLine;
    }

    @Generated
    public void setEndLine(Integer endLine) {
        this.endLine = endLine;
    }

    @Generated
    public void setSelectedCode(String selectedCode) {
        this.selectedCode = selectedCode;
    }

    @Generated
    public void setFileProtocol(String fileProtocol) {
        this.fileProtocol = fileProtocol;
    }

    @Generated
    public void setIsBinary(Boolean isBinary) {
        this.isBinary = isBinary;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ActiveFileInfo)) {
            return false;
        }
        ActiveFileInfo other = (ActiveFileInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$fileName = this.getFileName();
        String other$fileName = other.getFileName();
        if (this$fileName == null ? other$fileName != null : !this$fileName.equals(other$fileName)) {
            return false;
        }
        String this$filePath = this.getFilePath();
        String other$filePath = other.getFilePath();
        if (this$filePath == null ? other$filePath != null : !this$filePath.equals(other$filePath)) {
            return false;
        }
        Integer this$statLine = this.getStatLine();
        Integer other$statLine = other.getStatLine();
        if (this$statLine == null ? other$statLine != null : !((Object)this$statLine).equals(other$statLine)) {
            return false;
        }
        Integer this$endLine = this.getEndLine();
        Integer other$endLine = other.getEndLine();
        if (this$endLine == null ? other$endLine != null : !((Object)this$endLine).equals(other$endLine)) {
            return false;
        }
        String this$selectedCode = this.getSelectedCode();
        String other$selectedCode = other.getSelectedCode();
        if (this$selectedCode == null ? other$selectedCode != null : !this$selectedCode.equals(other$selectedCode)) {
            return false;
        }
        String this$fileProtocol = this.getFileProtocol();
        String other$fileProtocol = other.getFileProtocol();
        if (this$fileProtocol == null ? other$fileProtocol != null : !this$fileProtocol.equals(other$fileProtocol)) {
            return false;
        }
        Boolean this$isBinary = this.getIsBinary();
        Boolean other$isBinary = other.getIsBinary();
        return !(this$isBinary == null ? other$isBinary != null : !((Object)this$isBinary).equals(other$isBinary));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ActiveFileInfo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $fileName = this.getFileName();
        result = result * 59 + ($fileName == null ? 43 : $fileName.hashCode());
        String $filePath = this.getFilePath();
        result = result * 59 + ($filePath == null ? 43 : $filePath.hashCode());
        Integer $statLine = this.getStatLine();
        result = result * 59 + ($statLine == null ? 43 : ((Object)$statLine).hashCode());
        Integer $endLine = this.getEndLine();
        result = result * 59 + ($endLine == null ? 43 : ((Object)$endLine).hashCode());
        String $selectedCode = this.getSelectedCode();
        result = result * 59 + ($selectedCode == null ? 43 : $selectedCode.hashCode());
        String $fileProtocol = this.getFileProtocol();
        result = result * 59 + ($fileProtocol == null ? 43 : $fileProtocol.hashCode());
        Boolean $isBinary = this.getIsBinary();
        result = result * 59 + ($isBinary == null ? 43 : ((Object)$isBinary).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ActiveFileInfo(fileName=" + this.getFileName() + ", filePath=" + this.getFilePath() + ", statLine=" + this.getStatLine() + ", endLine=" + this.getEndLine() + ", selectedCode=" + this.getSelectedCode() + ", fileProtocol=" + this.getFileProtocol() + ", isBinary=" + this.getIsBinary() + ")";
    }
}

