/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.ui.search.model;

import com.alibaba.fastjson.JSONObject;
import com.alibabacloud.intellij.qoder.constants.InputConstants;
import com.alibabacloud.intellij.qoder.ui.search.enums.ChatContextTypeEnum;
import com.alibabacloud.intellij.qoder.ui.search.enums.ComponentTypeEnum;
import com.alibabacloud.intellij.qoder.ui.search.model.ActiveFileInfo;
import com.alibabacloud.intellij.qoder.ui.search.model.SuggestPrompt;
import com.alibabacloud.intellij.qoder.ui.search.model.tag.ChatAskTag;
import com.alibabacloud.intellij.qoder.util.FileUtil;
import com.alibabacloud.intellij.qoder.util.MapUtil;
import com.alibabacloud.intellij.qoder.util.TagUtil;
import com.alibabacloud.intellij.qoder.util.transfer.ObjectEncoder;
import java.io.Serializable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class ChatContextTag
implements Serializable {
    private static final long serialVersionUID = 4806962938810901365L;
    String id;
    String name;
    String text;
    String type;
    Integer statLine;
    Integer endLine;
    Object payload;
    private SuggestPrompt contextProvider;
    private String componentType;
    private Map<String, Object> extra;
    private Boolean valid;
    private String sourceType;
    private Boolean recommended;
    private AtomicReference<Boolean> loading;
    private boolean sticky;

    public static String getContextType(Map<String, Object> extra) {
        if (extra == null || !extra.containsKey("contextType")) {
            return null;
        }
        Object contextType = extra.get("contextType");
        if (contextType instanceof String) {
            return (String)contextType;
        }
        return null;
    }

    public String toMarkdownLabelString(String text) {
        Object filePath = this.getLocalFilePath();
        String fileUrl = this.getRemoteFileUrl();
        if (StringUtils.isNotBlank((CharSequence)filePath) || StringUtils.isNotBlank((CharSequence)fileUrl)) {
            if (StringUtils.isNotBlank((CharSequence)filePath)) {
                if (this.statLine != null && this.endLine != null) {
                    filePath = (String)filePath + "#L" + (this.statLine - 1) + "-L" + (this.endLine - 1);
                }
                filePath = ObjectEncoder.encodeToStringByUrl((String)filePath);
                filePath = "file://" + (String)filePath;
            }
            if (StringUtils.isNotBlank((CharSequence)fileUrl)) {
                filePath = fileUrl + (String)filePath;
            }
            return String.format("[`%s`](%s)", text, filePath);
        }
        if (ChatContextTypeEnum.TEAM_DOCS.getType().equals(this.type)) {
            return String.format("`%s`", text);
        }
        String chatContextTagStr = JSONObject.toJSONString((Object)this);
        if (text != null && text.contains("```")) {
            text = text.replaceAll("```", "");
        }
        filePath = "context://" + URLEncoder.encode(chatContextTagStr, StandardCharsets.UTF_8);
        return String.format("[`%s`](%s)", text, filePath);
    }

    public String getFilePath() {
        String filePath = this.getLocalFilePath();
        if (StringUtils.isBlank((CharSequence)filePath)) {
            filePath = this.getRemoteFileUrl();
        }
        return filePath;
    }

    public String getRemoteFileUrl() {
        Object fileUrl = null;
        if (this.extra != null && ChatContextTypeEnum.IMAGE.getType().equals(this.type) && StringUtils.isNotBlank((CharSequence)(fileUrl = MapUtil.getStringOrDefault(this.extra, "imgUrl", "")))) {
            fileUrl = "image://" + (String)fileUrl;
        }
        return fileUrl;
    }

    public String getLocalFilePath() {
        if (ChatContextTypeEnum.TEAM_DOCS.getType().equals(this.type)) {
            return null;
        }
        String filePath = MapUtil.getStringOrDefault(this.extra, "filePath", "");
        if (StringUtils.isBlank((CharSequence)filePath) && ChatContextTypeEnum.FILE.getType().equals(this.type) && this.payload instanceof String) {
            filePath = (String)this.payload;
        }
        return filePath;
    }

    public Boolean equalsToAskTag(ChatAskTag askTag) {
        if (StringUtils.isBlank((CharSequence)askTag.getId())) {
            return false;
        }
        Boolean equals = Objects.equals(askTag.getId(), this.id);
        if (!equals.booleanValue() && ChatContextTypeEnum.IMAGE.getType().equals(this.type)) {
            String tmpFilePath = FileUtil.getTempPath(this.getRemoteFileUrl(), this.getLocalFilePath());
            equals = Objects.equals(askTag.getId(), tmpFilePath);
        }
        return equals;
    }

    public Boolean getActualValid() {
        Boolean ret = this.valid == null || this.valid != false;
        if (ret.booleanValue() && ChatContextTypeEnum.IMAGE.getType().equals(this.type)) {
            return StringUtils.isNotBlank((CharSequence)this.getRemoteFileUrl());
        }
        return ret;
    }

    public static ChatContextTag buildFromActiveFileInfo(ActiveFileInfo activeFileInfo) {
        if (activeFileInfo.getIsBinary().booleanValue()) {
            return null;
        }
        Integer startLine = activeFileInfo.getStatLine();
        Integer endLine = activeFileInfo.getEndLine();
        String id = activeFileInfo.getFilePath();
        SuggestPrompt contextProvider = InputConstants.SCOPE_SUGGEST_PROMPT_MAP.get(ChatContextTypeEnum.FILE.getType());
        if (startLine != null && endLine != null) {
            id = TagUtil.getSelectCodeTagId(id, startLine, endLine);
            contextProvider = InputConstants.SCOPE_SUGGEST_PROMPT_MAP.get(ChatContextTypeEnum.SELECTED_CODE.getType());
        }
        return ChatContextTag.builder().id(id).text(activeFileInfo.getFileName()).type(ChatContextTypeEnum.CURRENT_FILE.getType()).statLine(startLine).endLine(endLine).payload(activeFileInfo.getFilePath()).componentType(ComponentTypeEnum.COMBOBOX.getType()).contextProvider(contextProvider).extra(ChatContextTag.buildExtraOfChatContextTag(startLine, endLine, activeFileInfo.getFilePath(), activeFileInfo.getFileName(), activeFileInfo.getSelectedCode())).sourceType("system").build();
    }

    public static ChatContextTag buildFromActiveFileInfoForInline(ActiveFileInfo activeFileInfo) {
        if (activeFileInfo.getIsBinary().booleanValue() && !activeFileInfo.getFileProtocol().equals("jar") && !activeFileInfo.getFilePath().endsWith(".class") && !activeFileInfo.getFilePath().endsWith(".java")) {
            return null;
        }
        Integer startLine = activeFileInfo.getStatLine();
        Integer endLine = activeFileInfo.getEndLine();
        String id = activeFileInfo.getFilePath();
        SuggestPrompt contextProvider = InputConstants.SCOPE_SUGGEST_PROMPT_MAP.get(ChatContextTypeEnum.FILE.getType());
        if (startLine != null && endLine != null) {
            id = TagUtil.getSelectCodeTagId(id, startLine, endLine);
            contextProvider = InputConstants.SCOPE_SUGGEST_PROMPT_MAP.get(ChatContextTypeEnum.SELECTED_CODE.getType());
        }
        Map<String, Object> extra = ChatContextTag.buildExtraOfChatContextTag(startLine, endLine, activeFileInfo.getFilePath(), activeFileInfo.getFileName(), activeFileInfo.getSelectedCode());
        extra.put("contextType", ChatContextTypeEnum.SELECTED_CODE.getType());
        return ChatContextTag.builder().id(id).text(activeFileInfo.getFileName()).type(ChatContextTypeEnum.CURRENT_FILE.getType()).statLine(startLine).endLine(endLine).payload(activeFileInfo.getFilePath()).componentType(ComponentTypeEnum.COMBOBOX.getType()).contextProvider(contextProvider).extra(extra).sourceType("system").build();
    }

    public static Map<String, Object> buildExtraOfChatContextTag(Integer startLine, Integer endLine, String filePath, String fileName, String selectedText) {
        HashMap<String, Object> extra = new HashMap<String, Object>();
        extra.put("startLine", startLine);
        extra.put("endLine", endLine);
        extra.put("filePath", filePath);
        extra.put("fileName", fileName);
        extra.put("selectedItemContent", selectedText);
        extra.put("contextType", StringUtils.isEmpty((CharSequence)selectedText) ? ChatContextTypeEnum.FILE.getType() : ChatContextTypeEnum.SELECTED_CODE.getType());
        return extra;
    }

    public String getText() {
        String filePath;
        if (this.text == null && StringUtils.isNotBlank((CharSequence)(filePath = this.getLocalFilePath()))) {
            this.text = FileUtil.getFileName(filePath);
        }
        return this.text;
    }

    public String getName() {
        if (this.name == null) {
            this.name = ChatContextTypeEnum.FILE.getType().equals(this.type) || ChatContextTypeEnum.SELECTED_CODE.getType().equals(this.type) || ChatContextTypeEnum.CURRENT_FILE.getType().equals(this.type) ? this.id : this.getText();
        }
        return this.name;
    }

    @Generated
    private static AtomicReference<Boolean> $default$loading() {
        return new AtomicReference<Object>(null);
    }

    @Generated
    public static ChatContextTagBuilder builder() {
        return new ChatContextTagBuilder();
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public Integer getStatLine() {
        return this.statLine;
    }

    @Generated
    public Integer getEndLine() {
        return this.endLine;
    }

    @Generated
    public Object getPayload() {
        return this.payload;
    }

    @Generated
    public SuggestPrompt getContextProvider() {
        return this.contextProvider;
    }

    @Generated
    public String getComponentType() {
        return this.componentType;
    }

    @Generated
    public Map<String, Object> getExtra() {
        return this.extra;
    }

    @Generated
    public Boolean getValid() {
        return this.valid;
    }

    @Generated
    public String getSourceType() {
        return this.sourceType;
    }

    @Generated
    public Boolean getRecommended() {
        return this.recommended;
    }

    @Generated
    public AtomicReference<Boolean> getLoading() {
        return this.loading;
    }

    @Generated
    public boolean isSticky() {
        return this.sticky;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setText(String text) {
        this.text = text;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setStatLine(Integer statLine) {
        this.statLine = statLine;
    }

    @Generated
    public void setEndLine(Integer endLine) {
        this.endLine = endLine;
    }

    @Generated
    public void setPayload(Object payload) {
        this.payload = payload;
    }

    @Generated
    public void setContextProvider(SuggestPrompt contextProvider) {
        this.contextProvider = contextProvider;
    }

    @Generated
    public void setComponentType(String componentType) {
        this.componentType = componentType;
    }

    @Generated
    public void setExtra(Map<String, Object> extra) {
        this.extra = extra;
    }

    @Generated
    public void setValid(Boolean valid) {
        this.valid = valid;
    }

    @Generated
    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    @Generated
    public void setRecommended(Boolean recommended) {
        this.recommended = recommended;
    }

    @Generated
    public void setLoading(AtomicReference<Boolean> loading) {
        this.loading = loading;
    }

    @Generated
    public void setSticky(boolean sticky) {
        this.sticky = sticky;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChatContextTag)) {
            return false;
        }
        ChatContextTag other = (ChatContextTag)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Integer this$statLine = this.getStatLine();
        Integer other$statLine = other.getStatLine();
        if (this$statLine == null ? other$statLine != null : !((Object)this$statLine).equals(other$statLine)) {
            return false;
        }
        Integer this$endLine = this.getEndLine();
        Integer other$endLine = other.getEndLine();
        if (this$endLine == null ? other$endLine != null : !((Object)this$endLine).equals(other$endLine)) {
            return false;
        }
        Object this$payload = this.getPayload();
        Object other$payload = other.getPayload();
        if (this$payload == null ? other$payload != null : !this$payload.equals(other$payload)) {
            return false;
        }
        SuggestPrompt this$contextProvider = this.getContextProvider();
        SuggestPrompt other$contextProvider = other.getContextProvider();
        if (this$contextProvider == null ? other$contextProvider != null : !((Object)this$contextProvider).equals(other$contextProvider)) {
            return false;
        }
        String this$componentType = this.getComponentType();
        String other$componentType = other.getComponentType();
        if (this$componentType == null ? other$componentType != null : !this$componentType.equals(other$componentType)) {
            return false;
        }
        Map<String, Object> this$extra = this.getExtra();
        Map<String, Object> other$extra = other.getExtra();
        if (this$extra == null ? other$extra != null : !((Object)this$extra).equals(other$extra)) {
            return false;
        }
        Boolean this$valid = this.getValid();
        Boolean other$valid = other.getValid();
        if (this$valid == null ? other$valid != null : !((Object)this$valid).equals(other$valid)) {
            return false;
        }
        String this$sourceType = this.getSourceType();
        String other$sourceType = other.getSourceType();
        if (this$sourceType == null ? other$sourceType != null : !this$sourceType.equals(other$sourceType)) {
            return false;
        }
        Boolean this$recommended = this.getRecommended();
        Boolean other$recommended = other.getRecommended();
        if (this$recommended == null ? other$recommended != null : !((Object)this$recommended).equals(other$recommended)) {
            return false;
        }
        AtomicReference<Boolean> this$loading = this.getLoading();
        AtomicReference<Boolean> other$loading = other.getLoading();
        if (this$loading == null ? other$loading != null : !this$loading.equals(other$loading)) {
            return false;
        }
        return this.isSticky() == other.isSticky();
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ChatContextTag;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        Integer $statLine = this.getStatLine();
        result = result * 59 + ($statLine == null ? 43 : ((Object)$statLine).hashCode());
        Integer $endLine = this.getEndLine();
        result = result * 59 + ($endLine == null ? 43 : ((Object)$endLine).hashCode());
        Object $payload = this.getPayload();
        result = result * 59 + ($payload == null ? 43 : $payload.hashCode());
        SuggestPrompt $contextProvider = this.getContextProvider();
        result = result * 59 + ($contextProvider == null ? 43 : ((Object)$contextProvider).hashCode());
        String $componentType = this.getComponentType();
        result = result * 59 + ($componentType == null ? 43 : $componentType.hashCode());
        Map<String, Object> $extra = this.getExtra();
        result = result * 59 + ($extra == null ? 43 : ((Object)$extra).hashCode());
        Boolean $valid = this.getValid();
        result = result * 59 + ($valid == null ? 43 : ((Object)$valid).hashCode());
        String $sourceType = this.getSourceType();
        result = result * 59 + ($sourceType == null ? 43 : $sourceType.hashCode());
        Boolean $recommended = this.getRecommended();
        result = result * 59 + ($recommended == null ? 43 : ((Object)$recommended).hashCode());
        AtomicReference<Boolean> $loading = this.getLoading();
        result = result * 59 + ($loading == null ? 43 : $loading.hashCode());
        result = result * 59 + (this.isSticky() ? 79 : 97);
        return result;
    }

    @Generated
    public String toString() {
        return "ChatContextTag(id=" + this.getId() + ", name=" + this.getName() + ", text=" + this.getText() + ", type=" + this.getType() + ", statLine=" + this.getStatLine() + ", endLine=" + this.getEndLine() + ", payload=" + this.getPayload() + ", contextProvider=" + this.getContextProvider() + ", componentType=" + this.getComponentType() + ", extra=" + this.getExtra() + ", valid=" + this.getValid() + ", sourceType=" + this.getSourceType() + ", recommended=" + this.getRecommended() + ", loading=" + this.getLoading() + ", sticky=" + this.isSticky() + ")";
    }

    @Generated
    public ChatContextTag() {
        this.loading = ChatContextTag.$default$loading();
    }

    @Generated
    public ChatContextTag(String id, String name, String text, String type, Integer statLine, Integer endLine, Object payload, SuggestPrompt contextProvider, String componentType, Map<String, Object> extra, Boolean valid, String sourceType, Boolean recommended, AtomicReference<Boolean> loading, boolean sticky) {
        this.id = id;
        this.name = name;
        this.text = text;
        this.type = type;
        this.statLine = statLine;
        this.endLine = endLine;
        this.payload = payload;
        this.contextProvider = contextProvider;
        this.componentType = componentType;
        this.extra = extra;
        this.valid = valid;
        this.sourceType = sourceType;
        this.recommended = recommended;
        this.loading = loading;
        this.sticky = sticky;
    }

    @Generated
    public static class ChatContextTagBuilder {
        @Generated
        private String id;
        @Generated
        private String name;
        @Generated
        private String text;
        @Generated
        private String type;
        @Generated
        private Integer statLine;
        @Generated
        private Integer endLine;
        @Generated
        private Object payload;
        @Generated
        private SuggestPrompt contextProvider;
        @Generated
        private String componentType;
        @Generated
        private Map<String, Object> extra;
        @Generated
        private Boolean valid;
        @Generated
        private String sourceType;
        @Generated
        private Boolean recommended;
        @Generated
        private boolean loading$set;
        @Generated
        private AtomicReference<Boolean> loading;
        @Generated
        private boolean sticky;

        @Generated
        ChatContextTagBuilder() {
        }

        @Generated
        public ChatContextTagBuilder id(String id) {
            this.id = id;
            return this;
        }

        @Generated
        public ChatContextTagBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public ChatContextTagBuilder text(String text) {
            this.text = text;
            return this;
        }

        @Generated
        public ChatContextTagBuilder type(String type) {
            this.type = type;
            return this;
        }

        @Generated
        public ChatContextTagBuilder statLine(Integer statLine) {
            this.statLine = statLine;
            return this;
        }

        @Generated
        public ChatContextTagBuilder endLine(Integer endLine) {
            this.endLine = endLine;
            return this;
        }

        @Generated
        public ChatContextTagBuilder payload(Object payload) {
            this.payload = payload;
            return this;
        }

        @Generated
        public ChatContextTagBuilder contextProvider(SuggestPrompt contextProvider) {
            this.contextProvider = contextProvider;
            return this;
        }

        @Generated
        public ChatContextTagBuilder componentType(String componentType) {
            this.componentType = componentType;
            return this;
        }

        @Generated
        public ChatContextTagBuilder extra(Map<String, Object> extra) {
            this.extra = extra;
            return this;
        }

        @Generated
        public ChatContextTagBuilder valid(Boolean valid) {
            this.valid = valid;
            return this;
        }

        @Generated
        public ChatContextTagBuilder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        @Generated
        public ChatContextTagBuilder recommended(Boolean recommended) {
            this.recommended = recommended;
            return this;
        }

        @Generated
        public ChatContextTagBuilder loading(AtomicReference<Boolean> loading) {
            this.loading = loading;
            this.loading$set = true;
            return this;
        }

        @Generated
        public ChatContextTagBuilder sticky(boolean sticky) {
            this.sticky = sticky;
            return this;
        }

        @Generated
        public ChatContextTag build() {
            AtomicReference<Boolean> loading = this.loading;
            if (!this.loading$set) {
                loading = ChatContextTag.$default$loading();
            }
            return new ChatContextTag(this.id, this.name, this.text, this.type, this.statLine, this.endLine, this.payload, this.contextProvider, this.componentType, this.extra, this.valid, this.sourceType, this.recommended, loading, this.sticky);
        }

        @Generated
        public String toString() {
            return "ChatContextTag.ChatContextTagBuilder(id=" + this.id + ", name=" + this.name + ", text=" + this.text + ", type=" + this.type + ", statLine=" + this.statLine + ", endLine=" + this.endLine + ", payload=" + this.payload + ", contextProvider=" + this.contextProvider + ", componentType=" + this.componentType + ", extra=" + this.extra + ", valid=" + this.valid + ", sourceType=" + this.sourceType + ", recommended=" + this.recommended + ", loading=" + this.loading + ", sticky=" + this.sticky + ")";
        }
    }
}

