/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.ui.search.renderer;

import com.alibabacloud.intellij.qoder.chat.enums.ChatTaskEnum;
import com.alibabacloud.intellij.qoder.chat.model.ChatContext;
import com.alibabacloud.intellij.qoder.common.BuildFeature;
import com.alibabacloud.intellij.qoder.common.CosyCacheKeys;
import com.alibabacloud.intellij.qoder.common.CosyConfig;
import com.alibabacloud.intellij.qoder.common.CosySetting;
import com.alibabacloud.intellij.qoder.icons.CommonIcons;
import com.alibabacloud.intellij.qoder.icons.QoderIcons;
import com.alibabacloud.intellij.qoder.search.enums.SearchActionTypeEnum;
import com.alibabacloud.intellij.qoder.search.enums.TrackEventTypeEnum;
import com.alibabacloud.intellij.qoder.search.result.SearchContext;
import com.alibabacloud.intellij.qoder.service.TelemetryService;
import com.alibabacloud.intellij.qoder.ui.config.CosyPersistentSetting;
import com.alibabacloud.intellij.qoder.ui.search.Constants;
import com.alibabacloud.intellij.qoder.ui.search.I18NConstant;
import com.alibabacloud.intellij.qoder.ui.search.SearchToolWindowFactory;
import com.alibabacloud.intellij.qoder.ui.search.enums.OperationEnum;
import com.alibabacloud.intellij.qoder.ui.search.enums.SessionTypeEnum;
import com.alibabacloud.intellij.qoder.ui.search.model.GenerateInput;
import com.alibabacloud.intellij.qoder.ui.search.topic.AnyGenerateNotifier;
import com.alibabacloud.intellij.qoder.util.PsiUtils;
import com.intellij.codeInsight.hints.presentation.InputHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.wm.RegisterToolWindowTask;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.util.Consumer;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Locale;
import java.util.UUID;
import javax.swing.Icon;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class CosyPresentation
implements EditorCustomElementRenderer,
InputHandler {
    private final Editor editor;
    private final Project myProject;
    private final int startOffset;

    public CosyPresentation(Editor editor, Project project, int starOffset) {
        this.editor = editor;
        this.myProject = project;
        this.startOffset = starOffset;
    }

    private String getErrorStacktrace(Document document, int startOffset, int line) {
        String lineContent;
        String errorHeader = document.getText(new TextRange(startOffset, document.getLineEndOffset(line)));
        StringBuilder sb = new StringBuilder(errorHeader);
        ++line;
        while (line < document.getLineCount() && ((lineContent = document.getText(new TextRange(document.getLineStartOffset(line), document.getLineEndOffset(line)))).trim().startsWith("at ") || lineContent.trim().startsWith("Caused by") || lineContent.trim().startsWith("..."))) {
            sb.append("\n");
            sb.append(lineContent);
            ++line;
        }
        return sb.toString();
    }

    public void mouseClicked(@NotNull MouseEvent mouseEvent, @NotNull Point point) {
        if (mouseEvent == null) {
            CosyPresentation.$$$reportNull$$$0(0);
        }
        if (point == null) {
            CosyPresentation.$$$reportNull$$$0(1);
        }
        CosySetting setting = CosyPersistentSetting.getInstance().getState();
        int line = this.editor.getDocument().getLineNumber(this.startOffset);
        String errorInformation = this.getErrorStacktrace(this.editor.getDocument(), this.startOffset, line);
        String codeContext = PsiUtils.findErrorLineContent(this.myProject, this.editor, line);
        SearchToolWindowFactory.showToolWindow(this.myProject);
        Object chatContext = ((ChatContext.ChatContextBuilder)((ChatContext.ChatContextBuilder)ChatContext.builder().sessionId(null)).localeLanguage(Locale.getDefault().getLanguage())).build();
        String errorPrompt = String.format("\u4fee\u590d\u62a5\u9519:\n%s\n\n", errorInformation);
        if (StringUtils.isNotBlank((CharSequence)codeContext)) {
            errorPrompt = String.format("\u4fee\u590d\u62a5\u9519:\n%s\n\u4ee3\u7801\u4e0a\u4e0b\u6587:\n%s\n", errorInformation, codeContext);
        }
        GenerateInput genInput = new GenerateInput(errorPrompt, ChatTaskEnum.ERROR_INFO_ASK.name(), (ChatContext)chatContext);
        SearchContext context = new SearchContext(OperationEnum.CLEAR_AND_ADD.text, SearchActionTypeEnum.RIGHT_CLICK_TRIGGER.getType());
        String requestId = UUID.randomUUID().toString();
        TelemetryService.getInstance().telemetryChatTask(this.myProject, TrackEventTypeEnum.CHAT_ERROR_INFO_ASK, requestId, ((ChatContext)chatContext).getSessionId(), ChatTaskEnum.ERROR_INFO_ASK.getName(), genInput, SessionTypeEnum.CHAT.getTelemetryType());
        CosyCacheKeys.NEED_INIT_WELCOME_WINDOW.set((UserDataHolder)this.myProject, (Object)false);
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(Constants.PLUGIN_NAME);
        if (toolWindow == null) {
            ToolWindowManager.getInstance((Project)this.myProject).registerToolWindow(RegisterToolWindowTask.closable((String)Constants.PLUGIN_NAME, (Icon)CommonIcons.AI, (ToolWindowAnchor)ToolWindowAnchor.RIGHT));
            toolWindow = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(Constants.PLUGIN_NAME);
        }
        ToolWindow finalToolWindow = toolWindow;
        boolean isVpc = CosyConfig.getFeature(BuildFeature.VPC_ENABLED.getKey(), false);
        ApplicationManager.getApplication().invokeLater(() -> {
            if (finalToolWindow != null) {
                if (finalToolWindow.getContentManager().findContent(I18NConstant.MAIN_CONTENT_NAME) == null) {
                    SearchToolWindowFactory.createSearchMainPanelAndGenerateContentForm(this.myProject, finalToolWindow, (Consumer<Project>)((Consumer)project1 -> ((AnyGenerateNotifier)project1.getMessageBus().syncPublisher(AnyGenerateNotifier.ANY_GENERATE_NOTIFICATION)).anyGenerate(context, genInput, requestId, isVpc)));
                } else {
                    SearchToolWindowFactory.showToolWindow(this.myProject);
                    ((AnyGenerateNotifier)this.myProject.getMessageBus().syncPublisher(AnyGenerateNotifier.ANY_GENERATE_NOTIFICATION)).anyGenerate(context, genInput, requestId, isVpc);
                }
            }
        });
    }

    public void mouseExited() {
        ((EditorImpl)this.editor).setCustomCursor((Object)this, Cursor.getPredefinedCursor(2));
    }

    public void mouseMoved(@NotNull MouseEvent mouseEvent, @NotNull Point point) {
        if (mouseEvent == null) {
            CosyPresentation.$$$reportNull$$$0(2);
        }
        if (point == null) {
            CosyPresentation.$$$reportNull$$$0(3);
        }
        ((EditorImpl)this.editor).setCustomCursor((Object)this, Cursor.getPredefinedCursor(12));
    }

    public int calcWidthInPixels(@NotNull Inlay inlay) {
        if (inlay == null) {
            CosyPresentation.$$$reportNull$$$0(4);
        }
        return CommonIcons.consoleIcon.getIconWidth();
    }

    public int calcHeightInPixels(@NotNull Inlay inlay) {
        if (inlay == null) {
            CosyPresentation.$$$reportNull$$$0(5);
        }
        return CommonIcons.consoleIcon.getIconHeight();
    }

    public void paint(@NotNull Inlay inlay, @NotNull Graphics g, @NotNull Rectangle r, @NotNull TextAttributes textAttributes) {
        if (inlay == null) {
            CosyPresentation.$$$reportNull$$$0(6);
        }
        if (g == null) {
            CosyPresentation.$$$reportNull$$$0(7);
        }
        if (r == null) {
            CosyPresentation.$$$reportNull$$$0(8);
        }
        if (textAttributes == null) {
            CosyPresentation.$$$reportNull$$$0(9);
        }
        Color color = EditorColorsManager.getInstance().getGlobalScheme().getColor(EditorColors.READONLY_FRAGMENT_BACKGROUND_COLOR);
        Icon consoleIcon = QoderIcons.ConsoleAskIcon;
        int curX = r.x + r.width / 2 - consoleIcon.getIconWidth() / 2;
        int curY = r.y + r.height / 2 - consoleIcon.getIconHeight() / 2;
        if (curX < 0 || curY < 0) {
            return;
        }
        consoleIcon.paintIcon(inlay.getEditor().getComponent(), g, curX, curY);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mouseEvent";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inlay";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textAttributes";
                break;
            }
        }
        objectArray2[1] = "com/alibabacloud/intellij/qoder/ui/search/renderer/CosyPresentation";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "mouseClicked";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "mouseMoved";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "calcWidthInPixels";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "calcHeightInPixels";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "paint";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

