/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.ui.search.renderer;

import com.alibabacloud.intellij.qoder.ui.search.generate.FilePathTreeNode;
import com.alibabacloud.intellij.qoder.util.IconUtil;
import com.alibabacloud.intellij.qoder.util.StringUtils;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.impl.file.SourceRootIconProvider;
import com.intellij.ui.ColoredTreeCellRenderer;
import java.util.Optional;
import javax.swing.Icon;
import javax.swing.JTree;
import org.apache.commons.lang3.BooleanUtils;
import org.jetbrains.annotations.NotNull;

public class FilePathTreeCellRender
extends ColoredTreeCellRenderer {
    private static Logger LOG = Logger.getInstance(FilePathTreeCellRender.class);
    private Project project;
    private static final int MAX_NAME_LENGTH = 48;

    public FilePathTreeCellRender(Project project) {
        this.project = project;
    }

    public void customizeCellRenderer(@NotNull JTree jTree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        FilePathTreeNode treeNode;
        if (jTree == null) {
            FilePathTreeCellRender.$$$reportNull$$$0(0);
        }
        if ((treeNode = (FilePathTreeNode)value) == null || treeNode.getFile() == null) {
            return;
        }
        VirtualFile file = treeNode.getFile();
        if (file.isDirectory()) {
            ApplicationManager.getApplication().runReadAction(() -> this.setIcon(SourceRootIconProvider.getDirectoryIcon((VirtualFile)file, (Project)this.project)));
        } else {
            Icon icon = IconUtil.getFileTypeIcon(this.project, file.getPresentableUrl());
            this.setIcon(icon);
        }
        this.setEnabled(leaf || row == 0);
        if (BooleanUtils.isTrue((Boolean)treeNode.isPlaceHolder())) {
            this.append("...");
        } else {
            this.append(Optional.ofNullable(StringUtils.truncateFirst(file.getName(), 48)).orElse(file.getName()));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jTree", "com/alibabacloud/intellij/qoder/ui/search/renderer/FilePathTreeCellRender", "customizeCellRenderer"));
    }
}

