/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.ui.search.renderer;

import com.alibabacloud.intellij.qoder.ui.search.enums.SnapshotStatusEnum;
import com.alibabacloud.intellij.qoder.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.qoder.ui.search.model.Snapshot;
import com.alibabacloud.intellij.qoder.util.ColorUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.panels.OpaquePanel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.text.Matcher;
import com.intellij.util.text.MatcherHolder;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class SnapshotListCellRender
extends DefaultListCellRenderer {
    private static Logger log = Logger.getInstance(SnapshotListCellRender.class);
    Project project;
    AtomicReference<Snapshot> currentSnapshot;
    JComponent hostComponent;

    public SnapshotListCellRender(Project project, AtomicReference<Snapshot> currentSnapshot, JComponent hostComponent) {
        this.project = project;
        this.hostComponent = hostComponent;
        this.currentSnapshot = currentSnapshot;
    }

    @Override
    public Component getListCellRendererComponent(JList<?> paramJList, Object paramObject, int paramInt, boolean isSelected, boolean cellHasFocus) {
        if (!(paramObject instanceof Snapshot)) {
            return super.getListCellRendererComponent(paramJList, paramObject, paramInt, isSelected, cellHasFocus);
        }
        OpaquePanel opaquePanel = new OpaquePanel((LayoutManager)new BorderLayout());
        opaquePanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        Snapshot current = this.currentSnapshot.get();
        Snapshot snapshot = (Snapshot)paramObject;
        if (current != null && current.getId().equals(snapshot.getId())) {
            JPanel hintPanel = new JPanel(new BorderLayout());
            hintPanel.setOpaque(false);
            JLabel hintLabel = new JLabel(CosyBundle.message("working.space.snapshot.current", new Object[0]));
            hintLabel.setFont(hintLabel.getFont().deriveFont(12.0f));
            hintLabel.setForeground(ColorUtil.getLinkForegroundColor());
            hintPanel.add((Component)hintLabel, "Center");
            opaquePanel.add((Component)hintPanel, (Object)"East");
        }
        Component component = new StatusAndNameRenderer(this.hostComponent).getListCellRendererComponent(paramJList, paramObject, paramInt, isSelected, cellHasFocus);
        component.setBackground(component.getBackground());
        opaquePanel.add(component, (Object)"West");
        opaquePanel.setBackground(isSelected ? ColorUtil.getItemSelectionBackground() : component.getBackground());
        return opaquePanel;
    }

    class StatusAndNameRenderer
    extends ColoredListCellRenderer {
        private static final String NLP_ITEM_ELLIPSIS = "...";
        private static final int NLP_ITEM_SUB_PADDING = 60;
        JComponent jComponent;

        private StatusAndNameRenderer(JComponent jComponent) {
            this.jComponent = jComponent;
        }

        protected void customizeCellRenderer(@NotNull JList param1JList, Object paramObject, int paramInt, boolean isSelected, boolean cellHasFocus) {
            if (param1JList == null) {
                StatusAndNameRenderer.$$$reportNull$$$0(0);
            }
            Matcher matcher = MatcherHolder.getAssociatedMatcher((JComponent)param1JList);
            Color color2 = UIUtil.getListBackground();
            Color color1 = param1JList.getForeground();
            this.setPaintFocusBorder(cellHasFocus && UIUtil.isToUseDottedCellBorder());
            if (paramObject instanceof Snapshot) {
                SnapshotStatusEnum statusEnum;
                Snapshot snapshot = (Snapshot)paramObject;
                String name = snapshot.getName();
                String status = snapshot.getStatus();
                SimpleTextAttributes simpleTextAttributes = new SimpleTextAttributes(0, color1);
                if (!snapshot.isInvalid()) {
                    simpleTextAttributes = new SimpleTextAttributes(0, ColorUtil.getAuxiliaryForegroundColor());
                }
                this.setIconTextGap(JBUIScale.scale((int)4));
                SpeedSearchUtil.appendColoredFragmentForMatcher((String)name, (SimpleColoredComponent)this, (SimpleTextAttributes)simpleTextAttributes, (Matcher)matcher, (Color)color2, (boolean)isSelected);
                if (param1JList.isShowing() && (statusEnum = SnapshotStatusEnum.getById(status)) != null) {
                    this.setIcon(snapshot.buildStatusIcon());
                }
            }
            this.setBackground(isSelected ? ColorUtil.getItemSelectionBackground() : color2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "param1JList", "com/alibabacloud/intellij/qoder/ui/search/renderer/SnapshotListCellRender$StatusAndNameRenderer", "customizeCellRenderer"));
        }
    }
}

