/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.ui.search.renderer;

import com.alibabacloud.intellij.qoder.icons.QoderIcons;
import com.alibabacloud.intellij.qoder.ui.search.enums.RuleTypeEnum;
import com.alibabacloud.intellij.qoder.ui.search.enums.SymbolTypeEnum;
import com.alibabacloud.intellij.qoder.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.qoder.ui.search.model.tool.CodeItem;
import com.alibabacloud.intellij.qoder.ui.search.model.tool.DirItem;
import com.alibabacloud.intellij.qoder.ui.search.model.tool.FileItem;
import com.alibabacloud.intellij.qoder.ui.search.model.tool.ProblemItem;
import com.alibabacloud.intellij.qoder.ui.search.model.tool.RuleItem;
import com.alibabacloud.intellij.qoder.ui.search.model.tool.SymbolItem;
import com.alibabacloud.intellij.qoder.ui.search.model.tool.WebItem;
import com.alibabacloud.intellij.qoder.ui.search.renderer.SnapshotListCellRender;
import com.alibabacloud.intellij.qoder.util.ColorUtil;
import com.alibabacloud.intellij.qoder.util.FontUtil;
import com.alibabacloud.intellij.qoder.util.IconUtil;
import com.alibabacloud.intellij.qoder.util.StringUtils;
import com.alibabacloud.intellij.qoder.util.SwingUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.impl.file.SourceRootIconProvider;
import com.intellij.ui.components.panels.OpaquePanel;
import com.intellij.ui.scale.JBUIScale;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.LayoutManager;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import org.apache.commons.collections4.map.LRUMap;

public class ToolResultListCellRender
extends DefaultListCellRenderer {
    private static Logger log = Logger.getInstance(SnapshotListCellRender.class);
    private static int TOOL_BOARD_LEFT_MARGIN = 8;
    private static int TOOL_SEARCH_WEB_BETWEEN_TITLE = 20;
    private static final int MAX_FILE_NAME_LENGTH = 25;
    private static final int MAX_PROBLEM_MESSAGE_LENGTH = 40;
    private final Map<String, Pair<String, String>> webCache = new LRUMap(100);
    Project project;
    JComponent hostComponent;
    private final AtomicInteger hoveredIndex;

    public ToolResultListCellRender(Project project, JComponent hostComponent, AtomicInteger hoveredIndex) {
        this.project = project;
        this.hostComponent = hostComponent;
        this.hoveredIndex = hoveredIndex;
    }

    @Override
    public Component getListCellRendererComponent(JList<?> paramJList, Object paramObject, int paramInt, boolean isSelected, boolean cellHasFocus) {
        OpaquePanel opaquePanel = new OpaquePanel((LayoutManager)new BorderLayout());
        opaquePanel.setBorder(BorderFactory.createEmptyBorder(4, 0, 4, 0));
        if (paramObject instanceof CodeItem) {
            CodeItem codeItem = (CodeItem)paramObject;
            Box box = Box.createHorizontalBox();
            JLabel fileLabel = new JLabel();
            fileLabel.setText(StringUtils.truncateFirst(codeItem.getFileName(), 25));
            fileLabel.setFont(fileLabel.getFont().deriveFont(0, 12.0f));
            fileLabel.setForeground(ColorUtil.getAuxiliaryForegroundColor());
            fileLabel.setIconTextGap(JBUIScale.scale((int)4));
            if (org.apache.commons.lang.StringUtils.isNotBlank((String)codeItem.getPath())) {
                ReadAction.run(() -> {
                    Icon icon = IconUtil.getFileTypeIcon(this.project, codeItem.getPath());
                    if (icon != null) {
                        fileLabel.setIcon(icon);
                    }
                });
            }
            box.add(fileLabel);
            if (codeItem.getStartLine() != null && codeItem.getEndLine() != null) {
                box.add(Box.createHorizontalStrut(JBUIScale.scale((int)4)));
                JLabel lineLabel = new JLabel();
                lineLabel.setText(codeItem.getStartLine() + "-" + codeItem.getEndLine());
                lineLabel.setFont(lineLabel.getFont().deriveFont(0, 12.0f));
                lineLabel.setForeground(ColorUtil.getAuxiliaryForegroundColor());
                box.add(lineLabel);
            }
            opaquePanel.add((Component)box, (Object)"West");
            JLabel pathLabel = new JLabel();
            pathLabel.setText(codeItem.getPath());
            String displayName = this.truncatePath(box, pathLabel, codeItem.getPath());
            pathLabel.setText(displayName);
            pathLabel.setFont(pathLabel.getFont().deriveFont(0, 12.0f));
            pathLabel.setForeground(ColorUtil.getAuxiliaryForegroundColor());
            opaquePanel.add((Component)pathLabel, (Object)"East");
        } else if (paramObject instanceof FileItem) {
            FileItem fileItem = (FileItem)paramObject;
            JLabel fileLabel = new JLabel();
            fileLabel.setText(StringUtils.truncateFirst(fileItem.getFileName(), 25));
            fileLabel.setFont(fileLabel.getFont().deriveFont(0, 12.0f));
            fileLabel.setForeground(ColorUtil.getAuxiliaryForegroundColor());
            fileLabel.setIconTextGap(JBUIScale.scale((int)4));
            if (org.apache.commons.lang.StringUtils.isNotBlank((String)fileItem.getPath())) {
                ReadAction.run(() -> {
                    Icon icon = IconUtil.getFileTypeIcon(this.project, fileItem.getPath());
                    if (icon != null) {
                        fileLabel.setIcon(icon);
                    }
                });
            }
            opaquePanel.add((Component)fileLabel, (Object)"West");
            JLabel pathLabel = new JLabel();
            String displayName = this.truncatePath(fileLabel, pathLabel, fileItem.getPath());
            pathLabel.setText(displayName);
            pathLabel.setFont(pathLabel.getFont().deriveFont(0, 12.0f));
            pathLabel.setForeground(ColorUtil.getAuxiliaryForegroundColor());
            opaquePanel.add((Component)pathLabel, (Object)"East");
        } else if (paramObject instanceof DirItem) {
            JLabel fileSizeLabel;
            JComponent rightComponent;
            DirItem dirItem = (DirItem)paramObject;
            if (org.apache.commons.lang.StringUtils.isNotBlank((String)dirItem.getFileCount()) && org.apache.commons.lang.StringUtils.isNotBlank((String)dirItem.getFileSize())) {
                Box box = Box.createHorizontalBox();
                JLabel fileCountLabel = new JLabel();
                Integer fountCount = (int)Double.parseDouble(dirItem.getFileCount());
                fileCountLabel.setText(fountCount + " " + CosyBundle.message("tool.list.dir.text.files", new Object[0]));
                fileCountLabel.setFont(fileCountLabel.getFont().deriveFont(0, 12.0f));
                fileCountLabel.setForeground(ColorUtil.getAuxiliaryForegroundColor());
                box.add(fileCountLabel);
                box.add(Box.createHorizontalStrut(JBUIScale.scale((int)16)));
                JLabel fileSizeLabel2 = new JLabel();
                fileSizeLabel2.setText(ToolResultListCellRender.convertBytesToMB(dirItem.getFileSize()));
                fileSizeLabel2.setFont(fileSizeLabel2.getFont().deriveFont(0, 12.0f));
                fileSizeLabel2.setForeground(ColorUtil.getAuxiliaryForegroundColor());
                box.add(fileSizeLabel2);
                opaquePanel.add((Component)box, (Object)"East");
                rightComponent = box;
            } else if (org.apache.commons.lang.StringUtils.isNotBlank((String)dirItem.getFileCount())) {
                JLabel fileCountLabel = new JLabel();
                Integer fountCount = (int)Double.parseDouble(dirItem.getFileCount());
                fileCountLabel.setText(fountCount + " " + CosyBundle.message("tool.list.dir.text.files", new Object[0]));
                fileCountLabel.setFont(fileCountLabel.getFont().deriveFont(0, 12.0f));
                fileCountLabel.setForeground(ColorUtil.getAuxiliaryForegroundColor());
                opaquePanel.add((Component)fileCountLabel, (Object)"East");
                rightComponent = fileCountLabel;
            } else if (org.apache.commons.lang.StringUtils.isNotBlank((String)dirItem.getFileSize())) {
                fileSizeLabel = new JLabel();
                String fileSize = ToolResultListCellRender.convertBytesToMB(dirItem.getFileSize());
                fileSizeLabel.setText(fileSize);
                fileSizeLabel.setFont(fileSizeLabel.getFont().deriveFont(0, 12.0f));
                fileSizeLabel.setForeground(ColorUtil.getAuxiliaryForegroundColor());
                opaquePanel.add((Component)fileSizeLabel, (Object)"East");
                rightComponent = fileSizeLabel;
            } else {
                fileSizeLabel = new JLabel();
                fileSizeLabel.setText("-");
                fileSizeLabel.setFont(fileSizeLabel.getFont().deriveFont(0, 12.0f));
                fileSizeLabel.setForeground(ColorUtil.getAuxiliaryForegroundColor());
                opaquePanel.add((Component)fileSizeLabel, (Object)"East");
                rightComponent = fileSizeLabel;
            }
            JLabel fileLabel = new JLabel();
            fileLabel.setText(this.truncateDirFileName(rightComponent, fileLabel, dirItem.getFileName()));
            fileLabel.setFont(fileLabel.getFont().deriveFont(0, 12.0f));
            fileLabel.setForeground(ColorUtil.getAuxiliaryForegroundColor());
            fileLabel.setIconTextGap(JBUIScale.scale((int)4));
            if (org.apache.commons.lang.StringUtils.isNotBlank((String)dirItem.getPath())) {
                VirtualFile file = LocalFileSystem.getInstance().findFileByPath(dirItem.getPath());
                if (file != null && file.isDirectory()) {
                    ReadAction.run(() -> fileLabel.setIcon(SourceRootIconProvider.getDirectoryIcon((VirtualFile)file, (Project)this.project)));
                } else {
                    ReadAction.run(() -> {
                        Icon icon = IconUtil.getFileTypeIcon(this.project, dirItem.getPath());
                        if (icon != null) {
                            fileLabel.setIcon(icon);
                        }
                    });
                }
            }
            opaquePanel.add((Component)fileLabel, (Object)"West");
        } else if (paramObject instanceof ProblemItem) {
            ProblemItem problemItem = (ProblemItem)paramObject;
            JLabel messageLabel = new JLabel();
            messageLabel.setText(StringUtils.truncateLast(problemItem.getMessage(), 40));
            messageLabel.setFont(messageLabel.getFont().deriveFont(0, 12.0f));
            messageLabel.setForeground(ColorUtil.getAuxiliaryForegroundColor());
            messageLabel.setIconTextGap(JBUIScale.scale((int)4));
            messageLabel.setIcon(QoderIcons.ErrorRed16Icon);
            opaquePanel.add((Component)messageLabel, (Object)"West");
            JLabel pathLabel = new JLabel();
            String displayName = this.truncatePath(messageLabel, pathLabel, problemItem.getPath());
            pathLabel.setText(displayName);
            pathLabel.setFont(pathLabel.getFont().deriveFont(0, 12.0f));
            pathLabel.setForeground(ColorUtil.getAuxiliaryForegroundColor());
            opaquePanel.add((Component)pathLabel, (Object)"East");
        } else if (paramObject instanceof SymbolItem) {
            SymbolItem symbolItem = (SymbolItem)paramObject;
            JLabel symbolLabel = new JLabel();
            symbolLabel.setText(StringUtils.truncateLast(symbolItem.getItemName(), 25));
            symbolLabel.setFont(symbolLabel.getFont().deriveFont(0, 12.0f));
            symbolLabel.setForeground(ColorUtil.getAuxiliaryForegroundColor());
            symbolLabel.setIconTextGap(JBUIScale.scale((int)4));
            Icon icon = SymbolTypeEnum.getSymbolIcon(symbolItem.getType());
            if (icon != null) {
                symbolLabel.setIcon(icon);
            } else if (org.apache.commons.lang.StringUtils.isNotBlank((String)symbolItem.getPath())) {
                log.warn("symbolItem. symbol icon is null,type=" + symbolItem.getType());
                ReadAction.run(() -> {
                    Icon fileTypeIcon = IconUtil.getFileTypeIcon(this.project, symbolItem.getPath());
                    if (fileTypeIcon != null) {
                        symbolLabel.setIcon(fileTypeIcon);
                    }
                });
            }
            opaquePanel.add((Component)symbolLabel, (Object)"West");
            JLabel pathLabel = new JLabel();
            String displayName = this.truncatePath(symbolLabel, pathLabel, symbolItem.getPath());
            pathLabel.setText(displayName);
            pathLabel.setFont(pathLabel.getFont().deriveFont(0, 12.0f));
            pathLabel.setForeground(ColorUtil.getAuxiliaryForegroundColor());
            opaquePanel.add((Component)pathLabel, (Object)"East");
        } else if (paramObject instanceof RuleItem) {
            RuleItem ruleItem = (RuleItem)paramObject;
            JLabel ruleLabel = new JLabel();
            ruleLabel.setText(StringUtils.truncateLast(ruleItem.getRuleName(), 25));
            ruleLabel.setFont(ruleLabel.getFont().deriveFont(0, 12.0f));
            ruleLabel.setForeground(ColorUtil.getAuxiliaryForegroundColor());
            ruleLabel.setIconTextGap(JBUIScale.scale((int)4));
            ruleLabel.setIcon(QoderIcons.RulesGrey16Icon);
            opaquePanel.add((Component)ruleLabel, (Object)"West");
            JLabel typeLabel = new JLabel();
            String displayName = Optional.ofNullable(ruleItem.getMetadata()).map(e -> RuleTypeEnum.getRuleTypeEnum(e.getTrigger()).getName()).orElse("");
            typeLabel.setText(displayName);
            typeLabel.setFont(typeLabel.getFont().deriveFont(0, 12.0f));
            typeLabel.setForeground(ColorUtil.getAuxiliaryForegroundColor());
            opaquePanel.add((Component)typeLabel, (Object)"East");
        } else if (paramObject instanceof WebItem) {
            WebItem webItem = (WebItem)paramObject;
            JLabel webItemLabel = new JLabel();
            webItemLabel.setFont(webItemLabel.getFont().deriveFont(0, 12.0f));
            webItemLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, TOOL_BOARD_LEFT_MARGIN));
            webItemLabel.setForeground(ColorUtil.getAuxiliaryForegroundColor());
            webItemLabel.setIconTextGap(JBUIScale.scale((int)4));
            webItemLabel.setIcon(QoderIcons.LinkGreyIcon);
            opaquePanel.add((Component)webItemLabel, (Object)"West");
            JLabel websiteLabel = new JLabel();
            websiteLabel.setFont(websiteLabel.getFont().deriveFont(0, 12.0f));
            websiteLabel.setForeground(ColorUtil.getAuxiliaryForegroundColor());
            opaquePanel.add((Component)websiteLabel, (Object)"East");
            Pair<String, String> pair = this.truncateWebUrlAndHost(webItemLabel, webItem.getTitle(), websiteLabel, webItem.getHostname());
            webItemLabel.setText((String)pair.getFirst());
            websiteLabel.setText((String)pair.getSecond());
        }
        if (this.hoveredIndex.get() == paramInt) {
            SwingUtil.foreachChildComponent((JComponent)opaquePanel, cp -> cp.setForeground(ColorUtil.getTextForegroundColor()));
        } else {
            SwingUtil.foreachChildComponent((JComponent)opaquePanel, cp -> cp.setForeground(ColorUtil.getAuxiliaryForegroundColor()));
            opaquePanel.setBackground(paramJList.getBackground());
        }
        return opaquePanel;
    }

    public static String convertBytesToMB(String fileSizeStr) {
        long bytes = (long)Double.parseDouble(fileSizeStr);
        double kb = (double)bytes / 1024.0;
        if (kb > 1024.0) {
            double mb = kb / 1024.0;
            return String.format("%.1f", mb) + " MB";
        }
        return String.format("%.1f", kb) + " KB";
    }

    private String truncatePath(JComponent leftComponent, JLabel pathLabel, String path) {
        if (path == null) {
            return "";
        }
        Dimension panelSize = this.hostComponent.getSize();
        if (panelSize.width > 0) {
            int maxWidth = panelSize.width - TOOL_BOARD_LEFT_MARGIN * 2;
            maxWidth = maxWidth - leftComponent.getPreferredSize().width - TOOL_BOARD_LEFT_MARGIN;
            return FontUtil.getStringAdaptiveWidth(pathLabel, path, maxWidth, true);
        }
        return path;
    }

    private String truncateDirFileName(JComponent rightComponent, JLabel pathLabel, String path) {
        Dimension panelSize = this.hostComponent.getSize();
        if (panelSize.width > 0) {
            int maxWidth = panelSize.width - TOOL_BOARD_LEFT_MARGIN * 2;
            if (rightComponent != null) {
                maxWidth = maxWidth - rightComponent.getPreferredSize().width - TOOL_BOARD_LEFT_MARGIN;
            }
            return FontUtil.getStringAdaptiveWidth(pathLabel, path, maxWidth, true);
        }
        return path;
    }

    private Pair<String, String> truncateWebUrlAndHost(JLabel webUrlLabel, String url, JLabel hostLabel, String host) {
        FontMetrics hostMetrics;
        int hostLength;
        Dimension panelSize = this.hostComponent.getSize();
        if (panelSize.width <= 0) {
            return new Pair((Object)url, (Object)host);
        }
        String cacheKey = url + "|" + host + "|" + panelSize.width;
        Pair<String, String> cached = this.webCache.get(cacheKey);
        if (cached != null) {
            return cached;
        }
        int maxWidth = panelSize.width - TOOL_BOARD_LEFT_MARGIN * 4 - TOOL_SEARCH_WEB_BETWEEN_TITLE;
        FontMetrics webUrlMetrics = FontUtil.fontMetrics(webUrlLabel, webUrlLabel.getFont());
        int webUrlLength = webUrlMetrics.stringWidth(url);
        if (webUrlLength + (hostLength = (hostMetrics = FontUtil.fontMetrics(hostLabel, hostLabel.getFont())).stringWidth(host)) <= maxWidth) {
            Pair pair = new Pair((Object)url, (Object)host);
            this.webCache.put(cacheKey, (Pair<String, String>)pair);
            return pair;
        }
        int maxHostWidth = Math.min(hostLength, maxWidth / 3);
        String hostString = FontUtil.getStringAdaptiveWidth(hostLabel, host, maxHostWidth, true);
        int actualHostLength = hostMetrics.stringWidth(hostString);
        String urlString = FontUtil.getStringAdaptiveWidth(webUrlLabel, url, maxWidth - actualHostLength, false);
        Pair pair = new Pair((Object)urlString, (Object)hostString);
        this.webCache.put(cacheKey, (Pair<String, String>)pair);
        return pair;
    }
}

