/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.update;

import com.alibabacloud.intellij.qoder.icons.CommonIcons;
import com.alibabacloud.intellij.qoder.ui.config.CosyConfigurable;
import com.alibabacloud.intellij.qoder.ui.notifications.NotificationFactory;
import com.alibabacloud.intellij.qoder.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.qoder.util.ReflectUtil;
import com.intellij.ide.plugins.PluginInstallCallbackData;
import com.intellij.ide.plugins.PluginInstaller;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import java.awt.Component;
import java.io.File;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.function.Consumer;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginDiskInstaller {
    private static final Logger LOGGER = Logger.getInstance(PluginDiskInstaller.class);

    public static void installFromDisk(Project project, File file) {
        try {
            LOGGER.info("install plugin from disk, file:" + file.getAbsolutePath());
            boolean ret = PluginDiskInstaller.installFromDisk(project, file, pluginInstallCallbackData -> PluginDiskInstaller.notifyUpdateFinished(project));
            if (!ret) {
                LOGGER.warn("install plugin from disk failed, file:" + file.getAbsolutePath());
            }
        }
        catch (Exception e) {
            LOGGER.warn("install plugin from disk error, file:" + file.getAbsolutePath(), (Throwable)e);
        }
    }

    private static boolean installFromDisk(@Nullable Project project, @NotNull File file, @NotNull Consumer<? super PluginInstallCallbackData> callback) {
        if (file == null) {
            PluginDiskInstaller.$$$reportNull$$$0(0);
        }
        if (callback == null) {
            PluginDiskInstaller.$$$reportNull$$$0(1);
        }
        if (ApplicationInfo.getInstance().getBuild().getBaselineVersion() <= 211) {
            return PluginDiskInstaller.installFromDiskOldVersion(project, file.toPath(), callback);
        }
        return PluginDiskInstaller.installFromDiskNewVersion(project, file, callback);
    }

    private static boolean installFromDiskOldVersion(@Nullable Project project, @NotNull Path file, @NotNull Consumer<? super PluginInstallCallbackData> callback) {
        if (file == null) {
            PluginDiskInstaller.$$$reportNull$$$0(2);
        }
        if (callback == null) {
            PluginDiskInstaller.$$$reportNull$$$0(3);
        }
        try {
            Class<?> installedPluginsTableModel = PluginDiskInstaller.getInstalledPluginsTableModel();
            if (installedPluginsTableModel == null) {
                return false;
            }
            Method installFromDiskMethod = ReflectUtil.getMethod(PluginInstaller.class, "installFromDisk", installedPluginsTableModel, Path.class, Consumer.class, Component.class);
            if (installFromDiskMethod == null) {
                return false;
            }
            installFromDiskMethod.setAccessible(true);
            Object tableModel = ReflectUtil.instanceClass(installedPluginsTableModel, new Class[]{Project.class}, project);
            Object ret = installFromDiskMethod.invoke(null, tableModel, file, callback, null);
            return Boolean.TRUE.equals(ret);
        }
        catch (Exception e) {
            LOGGER.warn("install plugin from disk error(old api)", (Throwable)e);
            return false;
        }
    }

    @Nullable
    private static Class<?> getInstalledPluginsTableModel() {
        Class<?> installedPluginsTableModel = ReflectUtil.classForNameQuietly("com.intellij.ide.plugins.InstalledPluginsTableModel");
        if (null == installedPluginsTableModel) {
            LOGGER.warn("get installedPluginsTableModel class by reflect failed");
            return null;
        }
        return installedPluginsTableModel;
    }

    private static boolean installFromDiskNewVersion(@Nullable Project project, @NotNull File file, @NotNull Consumer<? super PluginInstallCallbackData> callback) {
        if (file == null) {
            PluginDiskInstaller.$$$reportNull$$$0(4);
        }
        if (callback == null) {
            PluginDiskInstaller.$$$reportNull$$$0(5);
        }
        try {
            Class<?> pluginEnablerClass = ReflectUtil.classForName("com.intellij.ide.plugins.PluginEnabler");
            if (pluginEnablerClass == null) {
                return false;
            }
            Object pluginEnabler = ReflectUtil.getStaticField(pluginEnablerClass, "HEADLESS");
            if (pluginEnabler == null) {
                return false;
            }
            Class<?> installedPluginsTableModel = PluginDiskInstaller.getInstalledPluginsTableModel();
            if (installedPluginsTableModel == null) {
                return false;
            }
            Method installFromDiskMethod = ReflectUtil.getMethod(PluginInstaller.class, "installFromDisk", installedPluginsTableModel, pluginEnablerClass, File.class, JComponent.class, Consumer.class);
            if (installFromDiskMethod != null) {
                installFromDiskMethod.setAccessible(true);
                Object tableModel = ReflectUtil.instanceClass(installedPluginsTableModel, new Class[]{Project.class}, project);
                Object ret = installFromDiskMethod.invoke(null, tableModel, pluginEnabler, file, null, callback);
                return Boolean.TRUE.equals(ret);
            }
            installFromDiskMethod = ReflectUtil.getMethod(PluginInstaller.class, "installFromDisk", installedPluginsTableModel, pluginEnablerClass, File.class, Project.class, JComponent.class, Consumer.class);
            if (installFromDiskMethod != null) {
                installFromDiskMethod.setAccessible(true);
                Object tableModel = ReflectUtil.instanceClass(installedPluginsTableModel, new Class[]{Project.class}, project);
                Object ret = installFromDiskMethod.invoke(null, tableModel, pluginEnabler, file, project, null, callback);
                return Boolean.TRUE.equals(ret);
            }
        }
        catch (Exception e) {
            LOGGER.warn("install plugin from disk error(new api)", (Throwable)e);
        }
        return false;
    }

    public static void notifyUpdateFinished(@NotNull Project project) {
        if (project == null) {
            PluginDiskInstaller.$$$reportNull$$$0(6);
        }
        Notification notification = NotificationFactory.STICKY_NOTIFICATION_GROUP.createNotification(CosyBundle.message("cosy.plugin.name", new Object[0]), CosyBundle.message("notifications.update.installed.content", new Object[0]), NotificationType.INFORMATION, (paramNotification, paramHyperlinkEvent) -> {});
        notification.addAction((AnAction)NotificationAction.createSimpleExpiring((String)CosyBundle.message("notifications.update.installed.btn.restart", new Object[0]), PluginDiskInstaller::restartLater));
        notification.addAction((AnAction)NotificationAction.createSimpleExpiring((String)CosyBundle.message("notifications.update.installed.btn.change.settings", new Object[0]), () -> ShowSettingsUtil.getInstance().showSettingsDialog(project, CosyConfigurable.class)));
        notification.setIcon(CommonIcons.AI);
        notification.notify(project);
    }

    public static void restartLater() {
        ApplicationEx application = (ApplicationEx)ApplicationManager.getApplication();
        application.invokeLater(() -> application.restart(true, false));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/alibabacloud/intellij/qoder/update/PluginDiskInstaller";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "installFromDisk";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "installFromDiskOldVersion";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "installFromDiskNewVersion";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "notifyUpdateFinished";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

