/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.util;

import com.alibabacloud.intellij.qoder.common.BuildFeature;
import com.alibabacloud.intellij.qoder.common.CosyCacheKeys;
import com.alibabacloud.intellij.qoder.common.CosyConfig;
import com.alibabacloud.intellij.qoder.common.CosySetting;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.AuthStateEnum;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.AuthStatus;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.AuthWhitelistStatusEnum;
import com.alibabacloud.intellij.qoder.search.enums.LoginModeEnum;
import com.alibabacloud.intellij.qoder.ui.config.CosyPersistentSetting;
import com.alibabacloud.intellij.qoder.ui.search.I18NConstant;
import com.alibabacloud.intellij.qoder.ui.search.location.CosyBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.UserDataHolder;
import org.apache.commons.lang3.StringUtils;

public class AuthStatusUtil {
    public static boolean isNotLogin(AuthStatus status) {
        return status != null && (status.getStatus() == null || status.getStatus().intValue() == AuthStateEnum.NOT_LOGIN.getValue() || status.getStatus().intValue() == AuthStateEnum.LOGIN_EXPIRED.getValue() || StringUtils.isEmpty((CharSequence)status.getName()));
    }

    public static String generateAuthMessage(AuthStatus status) {
        String message = "";
        if (status == null) {
            return I18NConstant.LOGIN_MSG_GET_FAILED;
        }
        if (status.getStatus() == null) {
            return I18NConstant.LOGIN_MSG_REQUIRE_LOGIN;
        }
        CosyCacheKeys.KEY_AUTH_STATUS.set((UserDataHolder)ApplicationManager.getApplication(), (Object)status);
        if (status.getStatus().intValue() == AuthStateEnum.NETWORK_ERROR.getValue()) {
            return CosyBundle.message("message.chat.answer.quick.network.error", new Object[0]);
        }
        if (status.getStatus().intValue() == AuthStateEnum.IP_BANNED_ERROR.getValue()) {
            return CosyBundle.messageVpc("message.chat.answer.login.ip.whitelist.error", new Object[0]);
        }
        if (status.getStatus().intValue() == AuthStateEnum.APP_DISABLED_ERROR.getValue()) {
            return CosyBundle.messageVpc("message.chat.answer.login.app.disabled.error", new Object[0]);
        }
        if (status.getStatus().intValue() != AuthStateEnum.LOGIN.getValue()) {
            return I18NConstant.LOGIN_MSG_REQUIRE_LOGIN;
        }
        message = AuthStatusUtil.getNoAccessRightText(status);
        if (StringUtils.isBlank((CharSequence)message)) {
            return CosyBundle.message("notifications.auth.whitelist.unknown", new Object[0]);
        }
        return message;
    }

    private static String getNoAccessRightText(AuthStatus status) {
        String message = CosyBundle.message("notifications.auth.whitelist.unknown", new Object[0]);
        if (status == null || status.getWhitelist() == null) {
            return message;
        }
        if (status.getWhitelist().intValue() == AuthWhitelistStatusEnum.NO_LICENCE.getValue()) {
            message = CosyBundle.message("message.chat.answer.login.require.licence.access", new Object[0]);
        } else if (status.getWhitelist().intValue() == AuthWhitelistStatusEnum.ORG_ORDER_EXPIRED.getValue()) {
            message = String.format(CosyBundle.message("message.chat.answer.org.order.expired", new Object[0]), status.getName(), status.getOrgName());
        } else if (status.getWhitelist().intValue() != AuthWhitelistStatusEnum.PASS.getValue()) {
            message = StringUtils.isNotBlank((CharSequence)status.getOrgId()) ? String.format(AuthStatusUtil.getNoAccessMessageForOrgMember("message.chat.answer.login.require.org.access"), status.getName(), status.getOrgName()) : String.format(CosyBundle.message("message.chat.answer.login.require.access", new Object[0]), status.getName());
        }
        return message;
    }

    public static String getNoAccessMessageForOrgMember(String key) {
        String originKey = key;
        if (CosyConfig.getFeature(BuildFeature.VPC_ENABLED.getKey(), false)) {
            key = (String)key + ".vpc";
        } else {
            CosySetting settings = CosyPersistentSetting.getInstance().getState();
            if (settings != null && LoginModeEnum.DEDICATED.getLabel().equalsIgnoreCase(settings.getLoginMode())) {
                key = (String)key + ".vpc";
            }
        }
        String value = CosyBundle.message((String)key, new Object[0]);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            return value;
        }
        return CosyBundle.message(originKey, new Object[0]);
    }
}

