/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.util;

import com.alibabacloud.intellij.qoder.chat.enums.AgentTagEnum;
import com.alibabacloud.intellij.qoder.ui.search.enums.ChatContextTypeEnum;
import com.alibabacloud.intellij.qoder.ui.search.generate.input.ChatInputTextArea;
import com.alibabacloud.intellij.qoder.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.qoder.ui.search.model.ChatInputElement;
import com.alibabacloud.intellij.qoder.ui.search.model.tag.ChatAskTag;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

public class ChatAskTagUtil {
    private static final Map<String, String> PLACEHOLDER_MAP = Map.of("/explain", CosyBundle.message("chat.input.placeholder.with.explain", new Object[0]), "/unittest", CosyBundle.message("chat.input.placeholder.with.unittest", new Object[0]), "/comment", CosyBundle.message("chat.input.placeholder.with.comment", new Object[0]), "/optimize", CosyBundle.message("chat.input.placeholder.with.optimize", new Object[0]), AgentTagEnum.WORKSPACE.getName(), CosyBundle.message("chat.input.placeholder.with.workspace", new Object[0]), AgentTagEnum.TERMINAL.getName(), CosyBundle.message("chat.input.placeholder.with.terminal", new Object[0]));

    public static String getPlaceholderByTag(List<ChatAskTag> tags) {
        if (CollectionUtils.isEmpty(tags)) {
            return null;
        }
        List workspaceTagList = tags.stream().filter(chatAskTag -> AgentTagEnum.WORKSPACE.getId().equals(chatAskTag.getId())).collect(Collectors.toList());
        List terminalTagList = tags.stream().filter(chatAskTag -> AgentTagEnum.TERMINAL.getId().equals(chatAskTag.getId())).collect(Collectors.toList());
        List teamDocsTagList = tags.stream().filter(chatAskTag -> chatAskTag.getText() != null && ChatContextTypeEnum.TEAM_DOCS.getType().equals(chatAskTag.getText().substring(1))).collect(Collectors.toList());
        List otherTagList = tags.stream().filter(chatAskTag -> chatAskTag.getText().startsWith("/") || chatAskTag.getText().startsWith("@")).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(workspaceTagList)) {
            return CosyBundle.message("chat.input.placeholder.with.workspace", new Object[0]);
        }
        if (CollectionUtils.isNotEmpty(terminalTagList)) {
            return CosyBundle.message("chat.input.placeholder.with.terminal", new Object[0]);
        }
        if (CollectionUtils.isNotEmpty(teamDocsTagList)) {
            return CosyBundle.message("chat.input.placeholder.with.team.docs", new Object[0]);
        }
        if (!otherTagList.isEmpty()) {
            return CosyBundle.message("chat.input.placeholder.with.tag", new Object[0]);
        }
        return null;
    }

    public static String getPlaceholderByTextArea(ChatInputTextArea textArea) {
        return ChatAskTagUtil.getPlaceholderByElement(textArea);
    }

    public static String getPlaceholderByElement(ChatInputTextArea textArea) {
        List<ChatInputElement> elements = textArea.getElements();
        if (CollectionUtils.isEmpty(elements)) {
            return textArea.getPlaceholder();
        }
        boolean existTextElement = elements.stream().anyMatch(element -> element.getType().equals("text"));
        if (existTextElement) {
            return null;
        }
        ChatInputElement lastElement = elements.get(elements.size() - 1);
        String tagName = lastElement.getTag().getText();
        if (PLACEHOLDER_MAP.containsKey(tagName)) {
            return PLACEHOLDER_MAP.get(tagName);
        }
        return null;
    }
}

