/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.util;

import com.alibabacloud.intellij.qoder.util.DaemonCodeAnalyzerUtil;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.diff.util.TextDiffType;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.util.List;
import javax.swing.UIManager;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public class ColorUtil {
    private static final Color GRAPHITE_COLOR = new JBColor(new Color(-2137417827, true), new Color(6776937));

    public static Color getEditorBackgroundColor() {
        return new JBColor(() -> {
            EditorColorsManager colorsManager = EditorColorsManager.getInstance();
            EditorColorsScheme colorsScheme = colorsManager.getGlobalScheme();
            return colorsScheme.getDefaultBackground();
        });
    }

    public static Color getChatCardBackgroundColor() {
        Color newNotificationColor = UIManager.getColor("NotificationsToolwindow.newNotification.background");
        if (newNotificationColor != null) {
            return JBColor.namedColor((String)"NotificationsToolwindow.newNotification.background", (Color)newNotificationColor);
        }
        return new JBColor(() -> {
            Color color = ColorUtil.getToolWindowBackgroundColor();
            float[] hsl = new float[3];
            Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), hsl);
            Color schemaColor = EditorColorsManager.getInstance().getGlobalScheme().getColor(EditorColors.READONLY_FRAGMENT_BACKGROUND_COLOR);
            if (schemaColor == null) {
                float newLight = (float)((int)(hsl[2] * 100.0f) - 3) / 100.0f;
                if (newLight < 0.0f) {
                    newLight = (float)((int)(hsl[2] * 100.0f) + 3) / 100.0f;
                }
                hsl[2] = newLight;
            } else {
                float newLight = (float)((int)(hsl[2] * 100.0f) + 3) / 100.0f;
                if (newLight > 1.0f) {
                    newLight = (float)((int)(hsl[2] * 100.0f) - 3) / 100.0f;
                }
                hsl[2] = newLight;
            }
            return Color.getHSBColor(hsl[0], hsl[1], hsl[2]);
        });
    }

    public static Color getTabbedUnderlineColor() {
        return JBColor.namedColor((String)"TabbedPane.underlineColor", (Color)new JBColor(new Color(255, 0, 0), new Color(238, 0, 0)));
    }

    public static Color getTabbedHoverBgColor() {
        return JBColor.namedColor((String)"TabbedPane.hoverColor", (Color)new JBColor(new Color(255, 0, 0), new Color(238, 0, 0)));
    }

    public static Color getTabbedBgColor() {
        return JBColor.namedColor((String)"TabbedPane.background", (Color)new JBColor(new Color(255, 0, 0), new Color(238, 0, 0)));
    }

    public static Color getTabbedSelectForegroundColor() {
        return JBColor.namedColor((String)"TabbedPane.selectedTabTitleNormalColor", (Color)new JBColor(new Color(255, 0, 0), new Color(238, 0, 0)));
    }

    public static Color getChatCardChildBackgroundColor() {
        return ColorUtil.getChatCardBackgroundColor();
    }

    public static Color getSelectedListItemColor() {
        return UIUtil.getListSelectionForeground((boolean)true);
    }

    public static Color getToolWindowBackgroundColor() {
        return JBColor.namedColor((String)"ToolWindow.background", (Color)UIUtil.getPanelBackground());
    }

    public static Color getButtonHoverBackgroundColor() {
        return JBColor.namedColor((String)"ActionButton.hoverBackground", (Color)new JBColor(new Color(255, 0, 0), new Color(238, 0, 0)));
    }

    public static Color getDisabledTextFieldBackgroundColor() {
        return JBColor.namedColor((String)"TextField.disabledBackground", (Color)new JBColor((Color)Gray._242, (Color)Gray._242));
    }

    public static Color getEnabledTextFieldBackgroundColor() {
        return JBColor.namedColor((String)"TextField.background", (Color)new JBColor(new Color(69, 73, 74), new Color(69, 73, 74)));
    }

    public static Color getTextForegroundColor() {
        return new JBColor(UIUtil::getTextAreaForeground);
    }

    public static Color getTextPaneForegroundColor() {
        return JBColor.namedColor((String)"TextPane.foreground", (Color)ColorUtil.getTextForegroundColor());
    }

    public static Color getLabelForegroundColor() {
        return JBColor.namedColor((String)"Label.foreground", (Color)ColorUtil.getTextPaneForegroundColor());
    }

    public static Color getAuxiliaryForegroundColor() {
        return JBColor.namedColor((String)"Label.infoForeground", (Color)JBColor.namedColor((String)"ToolTip.infoForeground", (Color)new JBColor(new Color(255, 0, 0), new Color(238, 0, 0))));
    }

    public static Color getInactiveForegroundColor() {
        return JBColor.namedColor((String)"TextArea.inactiveForeground", (Color)new JBColor(new Color(255, 0, 0), new Color(238, 0, 0)));
    }

    public static Color getLinkForegroundColor() {
        return JBColor.namedColor((String)"Hyperlink.linkColor", (Color)new JBColor(new Color(255, 0, 0), new Color(238, 0, 0)));
    }

    public static Color getItemSelectionBackground() {
        return new JBColor(() -> UIUtil.getListSelectionBackground((boolean)true));
    }

    public static Color getItemSelectionForeground() {
        return new JBColor(() -> UIUtil.getListSelectionForeground((boolean)true));
    }

    public static Color getListBackground() {
        return new JBColor(UIUtil::getListBackground);
    }

    public static Color getListForeground() {
        return new JBColor(UIUtil::getListForeground);
    }

    public static Color getPopupMenuSelectionBackground() {
        return JBColor.namedColor((String)"PopupMenu.selectionBackground", (Color)ColorUtil.getItemSelectionBackground());
    }

    public static Color getPopupMenuSelectionForeground() {
        return JBColor.namedColor((String)"PopupMenu.selectionForeground", (Color)ColorUtil.getItemSelectionForeground());
    }

    @NotNull
    public static Color getListHoverBackground() {
        JBColor jBColor = JBColor.namedColor((String)"List.hoverBackground", (Color)new JBColor(15595004, 4606541));
        if (jBColor == null) {
            ColorUtil.$$$reportNull$$$0(0);
        }
        return jBColor;
    }

    public static Color getInactiveBackgroundColor() {
        return JBColor.namedColor((String)"ToolWindow.Header.inactiveBackground", (Color)new JBColor(new Color(236, 236, 236), new Color(236, 236, 236)));
    }

    public static Color getWarningNotificationBackgroundColor() {
        return JBColor.namedColor((String)"Banner.warningBackground", (int)16775915, (int)0x3D3223);
    }

    public static Color getDiffTypeBorderColor(Editor editor, TextDiffType diffType) {
        return new JBColor(() -> {
            Color themeColor = EditorColorsManager.getInstance().getGlobalScheme().getColor(EditorColors.READONLY_FRAGMENT_BACKGROUND_COLOR);
            if (themeColor == null) {
                return diffType.getColor(editor).brighter();
            }
            return diffType.getColor(editor).darker();
        });
    }

    public static HighlightResult getHighlightColor(Editor editor, int offset) {
        Project project = editor.getProject();
        if (project == null) {
            return null;
        }
        Document document = editor.getDocument();
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        if (file == null) {
            return null;
        }
        DaemonCodeAnalyzerUtil.setUpdateByTimerEnabled(DaemonCodeAnalyzer.getInstance((Project)project), true);
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        List<HighlightInfo> highlights = DaemonCodeAnalyzerUtil.getHighlights(document, null, project);
        PsiElement element = file.findElementAt(offset);
        EditorColorsScheme colorsScheme = editor.getColorsScheme();
        for (HighlightInfo info : highlights) {
            TextAttributes attributes;
            if (info.getStartOffset() > offset || offset > info.getEndOffset() || (attributes = info.getTextAttributes(element, colorsScheme)) == null) continue;
            return new HighlightResult(attributes.getForegroundColor(), attributes.getBackgroundColor(), attributes.getEffectColor(), info.getDescription());
        }
        return null;
    }

    public static Color getKeywordHighlightColor(Editor editor, int offset) {
        if (!(editor instanceof EditorEx)) {
            return null;
        }
        Project project = editor.getProject();
        if (project == null) {
            return null;
        }
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        if (psiFile == null) {
            return null;
        }
        SyntaxHighlighter highlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)psiFile.getLanguage(), (Project)project, (VirtualFile)psiFile.getVirtualFile());
        HighlighterIterator iterator = ((EditorEx)editor).getHighlighter().createIterator(offset);
        if (!iterator.atEnd()) {
            IElementType tokenType = iterator.getTokenType();
            TextAttributesKey[] keys = highlighter.getTokenHighlights(tokenType);
            EditorColorsScheme scheme = editor.getColorsScheme();
            for (TextAttributesKey key : keys) {
                TextAttributes attributes = scheme.getAttributes(key);
                if (attributes == null || attributes.getForegroundColor() == null) continue;
                return attributes.getForegroundColor();
            }
        }
        return null;
    }

    public static Color getButtonBackgroundColor() {
        return JBColor.namedColor((String)"Button.background", (Color)ColorUtil.getEditorBackgroundColor());
    }

    public static Color getButtonBorderColor() {
        return JBColor.namedColor((String)"Button.border", (Color)UIUtil.getBoundsColor());
    }

    @NotNull
    public static Color getFocusColor() {
        Color color = UIUtil.isGraphite() ? GRAPHITE_COLOR : JBColor.namedColor((String)"Component.focusColor", (Color)JBColor.namedColor((String)"Focus.borderColor", (int)9089771));
        if (color == null) {
            ColorUtil.$$$reportNull$$$0(1);
        }
        return color;
    }

    @NotNull
    public static Color getDefaultButtonColor() {
        return StartupUiUtil.isUnderDarcula() ? JBColor.namedColor((String)"Button.default.focusColor", (Color)JBColor.namedColor((String)"Focus.defaultButtonBorderColor", (int)9946099)) : ColorUtil.getFocusColor();
    }

    @NotNull
    public static Color getDefaultButtonStartBackgroundColor() {
        JBColor jBColor = JBColor.namedColor((String)"Button.default.startBackground", (Color)ColorUtil.getDefaultButtonColor());
        if (jBColor == null) {
            ColorUtil.$$$reportNull$$$0(2);
        }
        return jBColor;
    }

    @NotNull
    public static Color getButtonSeparatorColor() {
        Color focusColor = ColorUtil.getDefaultButtonColor();
        Color dark = new Color(focusColor.getRed(), focusColor.getGreen(), focusColor.getBlue(), 102);
        Color light = new Color(255, 255, 255, 102);
        return new JBColor(light, dark);
    }

    public static Color getScrollbarThumbBgColor() {
        ColorKey colorKey;
        EditorColorsManager colorsManager = EditorColorsManager.getInstance();
        EditorColorsScheme colorsScheme = colorsManager.getGlobalScheme();
        Color color = colorsScheme.getColor(colorKey = ColorKey.createColorKey((String)"ScrollBar.background"));
        return null == color ? ColorUtil.getToolWindowBackgroundColor() : color;
    }

    public static Color getPopupBorderColor() {
        return JBColor.namedColor((String)"Popup.borderColor", (Color)new JBColor((Color)Gray._173, (Color)Gray._97));
    }

    public static Color getPopupBackgroudColor() {
        return JBColor.namedColor((String)"Popup.background", (Color)new JBColor(new Color(43, 45, 48), new Color(43, 45, 48)));
    }

    public static Color getPopupTranslucentbackgroudColor() {
        return JBColor.namedColor((String)"PopupMenu.translucentBackground", (Color)new JBColor((Color)Gray._242, new Color(60, 63, 65)));
    }

    public static Color getInlineChatSelectionBackground(Editor editor) {
        return editor.getColorsScheme().getColor(EditorColors.CARET_ROW_COLOR);
    }

    public static Color getTooltipBackgroudColor() {
        return JBColor.namedColor((String)"ToolTip.background", (Color)new JBColor(new Color(57, 59, 64), new Color(57, 59, 64)));
    }

    public static Color getTooltipBorderColor() {
        return JBColor.namedColor((String)"ToolTip.borderColor", (Color)new JBColor(new Color(67, 69, 74), new Color(67, 69, 74)));
    }

    public static Color getTooltipFontColor() {
        return JBColor.namedColor((String)"ToolTip.foreground", (Color)new JBColor((Color)Gray._0, (Color)Gray._255));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/alibabacloud/intellij/qoder/util/ColorUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getListHoverBackground";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFocusColor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultButtonStartBackgroundColor";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    public static class HighlightResult {
        private Color foregroundColor;
        private Color backgroundColor;
        private Color effectColor;
        private String textAttributesDescription;

        @Generated
        public Color getForegroundColor() {
            return this.foregroundColor;
        }

        @Generated
        public Color getBackgroundColor() {
            return this.backgroundColor;
        }

        @Generated
        public Color getEffectColor() {
            return this.effectColor;
        }

        @Generated
        public String getTextAttributesDescription() {
            return this.textAttributesDescription;
        }

        @Generated
        public void setForegroundColor(Color foregroundColor) {
            this.foregroundColor = foregroundColor;
        }

        @Generated
        public void setBackgroundColor(Color backgroundColor) {
            this.backgroundColor = backgroundColor;
        }

        @Generated
        public void setEffectColor(Color effectColor) {
            this.effectColor = effectColor;
        }

        @Generated
        public void setTextAttributesDescription(String textAttributesDescription) {
            this.textAttributesDescription = textAttributesDescription;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof HighlightResult)) {
                return false;
            }
            HighlightResult other = (HighlightResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Color this$foregroundColor = this.getForegroundColor();
            Color other$foregroundColor = other.getForegroundColor();
            if (this$foregroundColor == null ? other$foregroundColor != null : !((Object)this$foregroundColor).equals(other$foregroundColor)) {
                return false;
            }
            Color this$backgroundColor = this.getBackgroundColor();
            Color other$backgroundColor = other.getBackgroundColor();
            if (this$backgroundColor == null ? other$backgroundColor != null : !((Object)this$backgroundColor).equals(other$backgroundColor)) {
                return false;
            }
            Color this$effectColor = this.getEffectColor();
            Color other$effectColor = other.getEffectColor();
            if (this$effectColor == null ? other$effectColor != null : !((Object)this$effectColor).equals(other$effectColor)) {
                return false;
            }
            String this$textAttributesDescription = this.getTextAttributesDescription();
            String other$textAttributesDescription = other.getTextAttributesDescription();
            return !(this$textAttributesDescription == null ? other$textAttributesDescription != null : !this$textAttributesDescription.equals(other$textAttributesDescription));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof HighlightResult;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Color $foregroundColor = this.getForegroundColor();
            result = result * 59 + ($foregroundColor == null ? 43 : ((Object)$foregroundColor).hashCode());
            Color $backgroundColor = this.getBackgroundColor();
            result = result * 59 + ($backgroundColor == null ? 43 : ((Object)$backgroundColor).hashCode());
            Color $effectColor = this.getEffectColor();
            result = result * 59 + ($effectColor == null ? 43 : ((Object)$effectColor).hashCode());
            String $textAttributesDescription = this.getTextAttributesDescription();
            result = result * 59 + ($textAttributesDescription == null ? 43 : $textAttributesDescription.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ColorUtil.HighlightResult(foregroundColor=" + this.getForegroundColor() + ", backgroundColor=" + this.getBackgroundColor() + ", effectColor=" + this.getEffectColor() + ", textAttributesDescription=" + this.getTextAttributesDescription() + ")";
        }

        @Generated
        public HighlightResult() {
        }

        @Generated
        public HighlightResult(Color foregroundColor, Color backgroundColor, Color effectColor, String textAttributesDescription) {
            this.foregroundColor = foregroundColor;
            this.backgroundColor = backgroundColor;
            this.effectColor = effectColor;
            this.textAttributesDescription = textAttributesDescription;
        }
    }
}

