/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.util;

import com.alibabacloud.intellij.qoder.common.CosyCacheKeys;
import com.alibabacloud.intellij.qoder.common.CosySetting;
import com.alibabacloud.intellij.qoder.completion.CosyCompletionService;
import com.alibabacloud.intellij.qoder.completion.model.CosyCompletionItem;
import com.alibabacloud.intellij.qoder.core.Cosy;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.AuthStatus;
import com.alibabacloud.intellij.qoder.core.lsp.model.params.CompletionParams;
import com.alibabacloud.intellij.qoder.core.lsp.model.params.PreCompletionParams;
import com.alibabacloud.intellij.qoder.editor.model.CosyEditorInlayItem;
import com.alibabacloud.intellij.qoder.editor.model.InlayCompletionRequest;
import com.alibabacloud.intellij.qoder.search.enums.CompletionTriggerModeEnum;
import com.alibabacloud.intellij.qoder.search.enums.PreCompletionTriggerMode;
import com.alibabacloud.intellij.qoder.service.model.Features;
import com.alibabacloud.intellij.qoder.ui.config.CosyPersistentSetting;
import com.alibabacloud.intellij.qoder.util.CollectionUtil;
import com.alibabacloud.intellij.qoder.util.FontUtil;
import com.alibabacloud.intellij.qoder.util.LanguageUtil;
import com.alibabacloud.intellij.qoder.util.LoginUtil;
import com.alibabacloud.intellij.qoder.util.PsiUtils;
import com.alibabacloud.intellij.qoder.util.StringUtils;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.text.TextRanges;
import java.awt.FontMetrics;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextEdit;
import org.jetbrains.annotations.NotNull;

public final class CompletionUtil {
    private static final Logger LOGGER = Logger.getInstance(CompletionUtil.class);
    public static final String COMPLETION_TOKEN_SPLITTER_PATTERN = "[\\s.(\\[{]+";
    private static final long REQUEST_TIMEOUT = 10000L;
    private static final Pattern END_OF_LINE_VALID_PATTERN = Pattern.compile("^\\s*[)}\\]\"'`]*\\s*[:{;,]?\\s*$");
    private static final Pattern FRONT_END_OF_LINE_VALID_PATTERN = Pattern.compile("^\\s*[)}\\]\"'`]*\\s*[:{;,]?\\s*$");
    private static final Set<String> FORBIDDEN_CONTINUE_CHARS = Set.of("(", ")", "[", "]", "{", "}", "\"", "'", "`", ":", ";", ",", ".", " ", "\t");
    private static final Set<String> FORBIDDEN_TRIGGER_CHARS = Set.of("\t", ";", "`");
    private static final Set<String> FORBIDDEN_NOT_EMPTY_LINE_SUFFIX = Set.of("=", ">", "<", "|", "\"", "&", "!", "*", "+", "-", "/", "%", "$");
    private static final Pattern VALID_MIDDLE_LINE_SUFFIX = Pattern.compile("^[)>{};:\\s\\t]+$");
    private static final Pattern METHOD_CALL_REGEX = Pattern.compile(".*\\.[\\w_]+\\(\\S+$");
    public static final Set<Integer> PAIR_CHARS_SET = Set.of(Integer.valueOf(40), Integer.valueOf(41), Integer.valueOf(123), Integer.valueOf(125), Integer.valueOf(91), Integer.valueOf(93), Integer.valueOf(60), Integer.valueOf(62));
    public static final Map<Integer, Integer> PAIR_CHAR_MAP = Map.of(40, 41, 123, 125, 91, 93, 60, 62);
    public static final int CHAR_OFFSET = Integer.MAX_VALUE - PAIR_CHARS_SET.size();
    public static final Map<Integer, Integer> PAI_CHAR_INDEX_MAP = Map.of(40, CHAR_OFFSET + 1, 41, CHAR_OFFSET + 2, 91, CHAR_OFFSET + 3, 93, CHAR_OFFSET + 4, 60, CHAR_OFFSET + 5, 62, CHAR_OFFSET + 6, 123, CHAR_OFFSET + 7, 125, CHAR_OFFSET + 8);

    public static String getCursorPrefix(CompletionParameters params) {
        Document document = params.getEditor().getDocument();
        int cursorPosition = params.getOffset();
        int lineNumber = document.getLineNumber(cursorPosition);
        int lineStart = document.getLineStartOffset(lineNumber);
        return document.getText(TextRange.create((int)lineStart, (int)cursorPosition)).trim();
    }

    public static String getCursorPrefix(Editor editor, int cursorPosition) {
        Document document = editor.getDocument();
        int lineNumber = document.getLineNumber(cursorPosition);
        int lineStart = document.getLineStartOffset(lineNumber);
        return document.getText(TextRange.create((int)lineStart, (int)cursorPosition)).trim();
    }

    public static String getCursorSuffix(CompletionParameters params) {
        Document document = params.getEditor().getDocument();
        int cursorPosition = params.getOffset();
        int lineNumber = document.getLineNumber(cursorPosition);
        int lineEnd = document.getLineEndOffset(lineNumber);
        return document.getText(TextRange.create((int)cursorPosition, (int)lineEnd)).trim();
    }

    public static String getCursorSuffix(Editor editor, int cursorPosition) {
        Document document = editor.getDocument();
        int lineNumber = document.getLineNumber(cursorPosition);
        int lineEnd = document.getLineEndOffset(lineNumber);
        return document.getText(TextRange.create((int)cursorPosition, (int)lineEnd)).trim();
    }

    public static String getCompletionText(CompletionItem item) {
        String result = "";
        if (item != null && item.getTextEdit() != null && item.getTextEdit().getLeft() != null) {
            TextEdit textEdit = (TextEdit)item.getTextEdit().getLeft();
            result = textEdit.getNewText();
        }
        if (item != null && result.isEmpty()) {
            result = item.getInsertText();
        }
        return result;
    }

    public static void setCompletionText(CompletionItem item, String text) {
        if (item != null && item.getTextEdit() != null && item.getTextEdit().getLeft() != null) {
            ((TextEdit)item.getTextEdit().getLeft()).setNewText(text);
        }
        if (item != null) {
            item.setInsertText(text);
        }
    }

    public static boolean isCompletionTextSingleToken(String completionText) {
        return completionText.replace("()", "").replace("[]", "").replace("{}", "").split(COMPLETION_TOKEN_SPLITTER_PATTERN, 2).length == 1;
    }

    public static boolean isValidDocumentChange(@NotNull Document document, int newOffset, int previousOffset) {
        if (document == null) {
            CompletionUtil.$$$reportNull$$$0(0);
        }
        return CompletionUtil.isValidDocumentChange(document, newOffset, previousOffset, null);
    }

    public static boolean isValidDocumentChange(@NotNull Document document, int newOffset, int previousOffset, PsiElement element) {
        long lastChangeTime;
        if (document == null) {
            CompletionUtil.$$$reportNull$$$0(1);
        }
        if (newOffset < 0 || previousOffset > newOffset) {
            return false;
        }
        Pair lastChangePair = (Pair)document.getUserData(CosyCacheKeys.KEY_LAST_CHANGE_TEXT);
        String addedText = document.getText(new TextRange(previousOffset, newOffset));
        LOGGER.debug("Check content change get text:" + addedText + " last:" + lastChangePair);
        String lastChangeText = lastChangePair != null ? (String)lastChangePair.getFirst() : null;
        long l = lastChangeTime = lastChangePair != null ? (Long)lastChangePair.getSecond() : 0L;
        if (lastChangeText != null && lastChangeText.equals(addedText) && FORBIDDEN_CONTINUE_CHARS.contains(addedText) && System.currentTimeMillis() - lastChangeTime < 3000L) {
            LOGGER.debug("Check content change return forbidden continue chars:" + addedText);
            return false;
        }
        if (FORBIDDEN_TRIGGER_CHARS.contains(addedText) || addedText.trim().isEmpty() && addedText.length() > 1 && !addedText.contains("\n")) {
            LOGGER.debug("Check content change return forbidden chars:" + addedText);
            return false;
        }
        if (addedText.trim().length() == 1) {
            if (CompletionUtil.isInvalidAllowChars(addedText.trim())) {
                LOGGER.debug("Check content change invalid chars for one char:" + addedText);
                return false;
            }
            if (!CompletionUtil.isAllowMustEmptyLineSuffix(document, addedText, newOffset)) {
                LOGGER.debug("Check content change invalid must empty line suffix for:" + addedText);
                return false;
            }
            return true;
        }
        if (addedText.trim().isEmpty() && previousOffset > 0) {
            if (!CompletionUtil.isValidReturnType(document, addedText, newOffset)) {
                LOGGER.debug("Check content change invalid return-char for:" + addedText);
                return false;
            }
            String externText = document.getText(new TextRange(previousOffset - 1, newOffset)).trim();
            LOGGER.debug("Check content change previous text:" + externText + " length:" + externText.length());
            return externText.length() <= 1;
        }
        LOGGER.debug("Check content change not match all rules");
        return false;
    }

    private static boolean isValidReturnType(@NotNull Document document, String addedText, int newOffset) {
        if (document == null) {
            CompletionUtil.$$$reportNull$$$0(2);
        }
        if ((addedText = addedText.replace("*", "")).trim().isEmpty() && addedText.contains("\n")) {
            int line = document.getLineNumber(newOffset);
            int startLineHead = document.getLineStartOffset(line);
            int startLineEnd = document.getLineEndOffset(line);
            String lineText = document.getText(new TextRange(startLineHead, startLineEnd));
            return lineText.trim().isEmpty();
        }
        return true;
    }

    public static boolean isInvalidAllowChars(String addedText) {
        char c = addedText.charAt(0);
        return c == ')' || c == ']' || c == '}' || c == ';';
    }

    public static boolean isAllowMustEmptyLineSuffix(@NotNull Document document, String addedText, int caretOffset) {
        if (document == null) {
            CompletionUtil.$$$reportNull$$$0(3);
        }
        if (!FORBIDDEN_NOT_EMPTY_LINE_SUFFIX.contains(addedText)) {
            return true;
        }
        int lineIndex = document.getLineNumber(caretOffset);
        TextRange lineSuffixRange = TextRange.create((int)caretOffset, (int)document.getLineEndOffset(lineIndex));
        String lineSuffix = document.getText(lineSuffixRange).trim();
        Matcher mat = VALID_MIDDLE_LINE_SUFFIX.matcher(lineSuffix);
        if (mat.matches()) {
            return true;
        }
        return lineSuffix.isEmpty();
    }

    public static boolean matchSuffixMethodCall(String linePrefix) {
        Matcher regex = METHOD_CALL_REGEX.matcher(linePrefix);
        return regex.matches();
    }

    public static boolean isValidMiddleLinePosition(@NotNull Document document, int offset) {
        if (document == null) {
            CompletionUtil.$$$reportNull$$$0(4);
        }
        int lineIndex = document.getLineNumber(offset);
        TextRange lineRange = TextRange.create((int)document.getLineStartOffset(lineIndex), (int)document.getLineEndOffset(lineIndex));
        String line = document.getText(lineRange);
        int i = offset - lineRange.getStartOffset();
        String lineSuffix = line.substring(i);
        return END_OF_LINE_VALID_PATTERN.matcher(lineSuffix).matches();
    }

    public static boolean isValidFrontMiddleLinePosition(@NotNull Document document, int offset) {
        if (document == null) {
            CompletionUtil.$$$reportNull$$$0(5);
        }
        int lineIndex = document.getLineNumber(offset);
        TextRange lineSuffixRange = TextRange.create((int)offset, (int)document.getLineEndOffset(lineIndex));
        String lineSuffix = document.getText(lineSuffixRange);
        return FRONT_END_OF_LINE_VALID_PATTERN.matcher(lineSuffix).find();
    }

    public static boolean isFrontFile(@NotNull Document document) {
        FileDocumentManager fileDocumentManager;
        VirtualFile virtualFile;
        if (document == null) {
            CompletionUtil.$$$reportNull$$$0(6);
        }
        if ((virtualFile = (fileDocumentManager = FileDocumentManager.getInstance()).getFile(document)) == null) {
            return false;
        }
        String filePath = virtualFile.getPresentableUrl();
        String language = LanguageUtil.getLanguageByFilePath(filePath);
        return "JavaScript".equalsIgnoreCase(language) || "TypeScript".equals(language) || "Vue".equalsIgnoreCase(language);
    }

    public static int getInlayChunkMaxLength(@NotNull Editor editor, @NotNull InlayCompletionRequest request, CosyEditorInlayItem item) {
        if (editor == null) {
            CompletionUtil.$$$reportNull$$$0(7);
        }
        if (request == null) {
            CompletionUtil.$$$reportNull$$$0(8);
        }
        int maxLength = 0;
        for (int i = 0; i < item.getChunks().size(); ++i) {
            CosyEditorInlayItem.EditorInlayItemChunk chunk = item.getChunks().get(i);
            for (int j = 0; j < chunk.getCompletionLines().size(); ++j) {
                Object line = chunk.getCompletionLines().get(j);
                if (i == 0 && j == 0) {
                    String prefix = PsiUtils.getLineTextAtCaret(editor, request.getCursorOffset());
                    line = prefix + (String)line;
                }
                maxLength = Math.max(maxLength, ((String)line).length());
            }
        }
        return maxLength;
    }

    public static int getInlayChunkMaxPixelLength(@NotNull Editor editor, @NotNull InlayCompletionRequest request, CosyEditorInlayItem item) {
        if (editor == null) {
            CompletionUtil.$$$reportNull$$$0(9);
        }
        if (request == null) {
            CompletionUtil.$$$reportNull$$$0(10);
        }
        FontMetrics metrics = FontUtil.fontMetrics(editor, FontUtil.getFont(editor, item.getContent()));
        int maxLength = 0;
        for (int i = 0; i < item.getChunks().size(); ++i) {
            CosyEditorInlayItem.EditorInlayItemChunk chunk = item.getChunks().get(i);
            for (int j = 0; j < chunk.getCompletionLines().size(); ++j) {
                Object line = chunk.getCompletionLines().get(j);
                if (i == 0 && j == 0 && !item.isAccepted()) {
                    String prefix = PsiUtils.getLineTextAtCaret(editor, item.getEditorOffset());
                    line = prefix + (String)line;
                }
                line = StringUtils.replaceHeadTabs((String)line, false, request.getTabWidth());
                int pixelLength = metrics.stringWidth((String)line);
                maxLength = Math.max(maxLength, pixelLength);
            }
        }
        return maxLength;
    }

    public static boolean isTriggerWhenLookup(@NotNull Editor editor) {
        List items;
        CosySetting settings;
        if (editor == null) {
            CompletionUtil.$$$reportNull$$$0(11);
        }
        boolean needTrggier = true;
        LookupEx activeLookup = LookupManager.getActiveLookup((Editor)editor);
        if (!(activeLookup == null || (settings = CosyPersistentSetting.getInstance().getState()) != null && settings.getParameter() != null && settings.getParameter().getCloud().isShowInlineWhenIDECompletion() || (items = activeLookup.getItems()).isEmpty())) {
            AtomicInteger validCount = new AtomicInteger(0);
            ReadAction.run(() -> {
                for (LookupElement item : items) {
                    if (item.getObject() instanceof CosyCompletionItem || item.getClass().getName().contains("LookupElementDecorator$InsertingDecorator")) continue;
                    validCount.incrementAndGet();
                }
            });
            if (validCount.get() > 0) {
                needTrggier = false;
            }
        }
        return needTrggier;
    }

    public static boolean isLineLevelSuffix(String lineSuffixCode) {
        Character nonBlankChar = null;
        for (int i = 0; i < lineSuffixCode.length(); ++i) {
            if (Character.isWhitespace(lineSuffixCode.charAt(i))) continue;
            nonBlankChar = Character.valueOf(lineSuffixCode.charAt(i));
            break;
        }
        return nonBlankChar == null || nonBlankChar.charValue() != ')' && nonBlankChar.charValue() != '>' && nonBlankChar.charValue() != '<' && nonBlankChar.charValue() != ',' && nonBlankChar.charValue() != '{' && nonBlankChar.charValue() != '}' && nonBlankChar.charValue() != ';';
    }

    public static boolean removeOverlapTrailingLines(List<String> lines, String content, int offset) {
        if (offset < content.length() && content.charAt(offset) == '\n') {
            ++offset;
        }
        if (offset >= content.length()) {
            return false;
        }
        List<String> editorLines = CompletionUtil.getBelowLinesByOffset(content, offset, lines.size());
        int overlap = CompletionUtil.findOverlapLineIndex(lines, editorLines);
        for (int i = 0; i < overlap; ++i) {
            lines.remove(lines.size() - 1);
        }
        return overlap >= 1;
    }

    public static List<String> getBelowLinesByOffset(@NotNull String text, int offset, int maxLineCount) {
        if (text == null) {
            CompletionUtil.$$$reportNull$$$0(12);
        }
        LinkedList<String> lines = new LinkedList<String>();
        int lastOffset = offset;
        for (int index = 0; index < maxLineCount; ++index) {
            int nextOffset = text.indexOf(10, lastOffset);
            if (nextOffset == -1) {
                if (text.length() <= lastOffset) break;
                lines.add(text.substring(lastOffset));
                break;
            }
            lines.add(text.substring(lastOffset, nextOffset));
            lastOffset = nextOffset + 1;
        }
        return lines;
    }

    public static int findOverlapLineIndex(@NotNull List<String> completionLines, @NotNull List<String> afterCursorLines) {
        if (completionLines == null) {
            CompletionUtil.$$$reportNull$$$0(13);
        }
        if (afterCursorLines == null) {
            CompletionUtil.$$$reportNull$$$0(14);
        }
        if (CollectionUtils.isEmpty(completionLines) || CollectionUtils.isEmpty(afterCursorLines)) {
            return 0;
        }
        int trailingSize = completionLines.size();
        int leadingSize = afterCursorLines.size();
        int maxLines = Math.min(trailingSize, leadingSize);
        int overlapIndex = 0;
        for (int i = 1; i <= maxLines; ++i) {
            List<String> lines = completionLines.subList(trailingSize - i, trailingSize);
            if (CollectionUtil.matchAllLines(afterCursorLines.subList(0, i), lines, true)) {
                overlapIndex = i;
                continue;
            }
            if (overlapIndex > 0) break;
        }
        return overlapIndex;
    }

    public static int[] normalizeCharPairs(int[] chars) {
        TextRanges stringRanges = CompletionUtil.findStringRanges(chars);
        for (int i = 0; i < chars.length; ++i) {
            int closeChar;
            int closeIndex;
            int c = chars[i];
            if (PAIR_CHARS_SET.contains(chars[i]) && CompletionUtil.rangeContains(stringRanges, i)) {
                chars[i] = PAI_CHAR_INDEX_MAP.get(c);
                continue;
            }
            if (!PAIR_CHAR_MAP.containsKey(c) || (closeIndex = CompletionUtil.firstMatchingPair(chars, i + 1, stringRanges, c, closeChar = PAIR_CHAR_MAP.get(c).intValue())) == -1) continue;
            chars[i] = PAI_CHAR_INDEX_MAP.get(c);
            chars[closeIndex] = PAI_CHAR_INDEX_MAP.get(closeChar);
        }
        return chars;
    }

    private static int firstMatchingPair(int[] chars, int startIndex, TextRanges excludedRanges, int startChar, int closeChar) {
        int openCount = 0;
        for (int i = startIndex; i < chars.length; ++i) {
            if (CompletionUtil.rangeContains(excludedRanges, i)) continue;
            int c = chars[i];
            if (c == startChar) {
                ++openCount;
                continue;
            }
            if (c != closeChar) continue;
            if (openCount == 0) {
                return i;
            }
            --openCount;
        }
        return -1;
    }

    private static boolean rangeContains(TextRanges ranges, int i) {
        for (TextRange range : ranges) {
            if (range.contains(i)) {
                return true;
            }
            if (i <= range.getEndOffset()) continue;
            break;
        }
        return false;
    }

    private static TextRanges findStringRanges(int[] chars) {
        TextRanges ranges = new TextRanges();
        int singleQuotedStart = -1;
        int doubleQuotedStart = -1;
        for (int i = 0; i < chars.length; ++i) {
            int c = chars[i];
            if (c == 34 && singleQuotedStart == -1) {
                if (doubleQuotedStart == -1) {
                    doubleQuotedStart = i;
                    continue;
                }
                ranges.union((TextRange)new ProperTextRange(doubleQuotedStart, i));
                doubleQuotedStart = -1;
                continue;
            }
            if (c != 39 || doubleQuotedStart != -1) continue;
            if (singleQuotedStart == -1) {
                singleQuotedStart = i;
                continue;
            }
            ranges.union((TextRange)new ProperTextRange(singleQuotedStart, i));
            singleQuotedStart = -1;
        }
        return ranges;
    }

    public static String getCommonPrefix(@NotNull String source, @NotNull String target) {
        if (source == null) {
            CompletionUtil.$$$reportNull$$$0(15);
        }
        if (target == null) {
            CompletionUtil.$$$reportNull$$$0(16);
        }
        int maxSize = Math.min(source.length(), target.length());
        int first = 0;
        for (int i = 0; i < maxSize && source.charAt(i) == target.charAt(i); ++i) {
            ++first;
        }
        return source.substring(0, first);
    }

    public static void triggerCursorPreCompletion(Editor editor) {
        if (!BooleanUtils.isTrue((Boolean)CompletionUtil.isAllowPreCompletion(editor.getProject()))) {
            return;
        }
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        VirtualFile virtualFile = fileDocumentManager.getFile(editor.getDocument());
        if (virtualFile == null) {
            LOGGER.warn("invalid virtual file for:" + editor.getDocument());
            return;
        }
        LogicalPosition position = editor.getCaretModel().getLogicalPosition();
        int line = position.line;
        int column = (Integer)ReadAction.compute(() -> editor.getCaretModel().getOffset() - editor.getDocument().getLineStartOffset(line));
        column = column > 0 ? column : position.column;
        PreCompletionParams params = new PreCompletionParams();
        params.setRequestId(UUID.randomUUID().toString());
        params.setFileContent(editor.getDocument().getText());
        params.setPosition(new Position(line, column));
        params.setTextDocument(new TextDocumentIdentifier(virtualFile.getPresentableUrl()));
        params.setTriggerMode(PreCompletionTriggerMode.CURSOR.getName());
        CosyCompletionService.getInstance().preCompletion(editor.getProject(), params, Features.PRE_COMPLETION_DELAY_WHEN_CURSOR_CHANGE.longValue(), 10000L);
    }

    private static boolean isAllowPreCompletion(Project project) {
        if (!Cosy.INSTANCE.checkCosy(project, false)) {
            return false;
        }
        CosySetting settings = CosyPersistentSetting.getInstance().getState();
        if (!CosyPersistentSetting.getInstance().isEnableCloudCompletion(settings, CompletionTriggerModeEnum.AUTO)) {
            return false;
        }
        AuthStatus authStatus = LoginUtil.getAuthStatusCacheFirst(project);
        return authStatus != null && authStatus.isAllow();
    }

    public static void triggerPreCompletion(InlayCompletionRequest request, long delay, CompletionTriggerModeEnum triggerMode) {
        Editor editor = request.getEditor();
        Project project = editor.getProject();
        if (Cosy.INSTANCE.getLanguageService(project) == null) {
            return;
        }
        CompletionParams completionParams = request.getParams();
        PreCompletionParams preParams = new PreCompletionParams(completionParams, (String)Optional.ofNullable(PreCompletionTriggerMode.getTriggerModeEnum(triggerMode.getName())).map(PreCompletionTriggerMode::getName).orElse(null));
        long preCompletionDelay = CompletionUtil.calculatePreCompletionDelay(delay);
        CosyCompletionService.getInstance().preCompletion(request.getEditor().getProject(), preParams, preCompletionDelay, 10000L);
    }

    public static void triggerPreCompletion(Editor editor, long delay) {
        Project project = editor.getProject();
        if (Cosy.INSTANCE.getLanguageService(project) == null) {
            return;
        }
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        VirtualFile virtualFile = fileDocumentManager.getFile(editor.getDocument());
        if (virtualFile == null) {
            LOGGER.warn("invalid virtual file for:" + editor.getDocument());
            return;
        }
        LogicalPosition position = editor.getCaretModel().getLogicalPosition();
        int line = position.line;
        int column = (Integer)ReadAction.compute(() -> editor.getCaretModel().getOffset() - editor.getDocument().getLineStartOffset(line));
        column = column > 0 ? column : position.column;
        PreCompletionParams params = new PreCompletionParams();
        params.setRequestId(UUID.randomUUID().toString());
        params.setFileContent(editor.getDocument().getText());
        params.setPosition(new Position(line, column));
        params.setTextDocument(new TextDocumentIdentifier(virtualFile.getPresentableUrl()));
        params.setTriggerMode(PreCompletionTriggerMode.CURSOR.getName());
        long preCompletionDelay = CompletionUtil.calculatePreCompletionDelay(delay);
        CosyCompletionService.getInstance().preCompletion(project, params, preCompletionDelay, 10000L);
    }

    private static long calculatePreCompletionDelay(long completionDelay) {
        long minDelayTime = Features.PRE_COMPLETION_DELAY_MIN_TIME.longValue();
        double ratio = Features.PRE_COMPLETION_DELAY_RATIO.doubleValue();
        if ((double)completionDelay * ratio < (double)minDelayTime) {
            return minDelayTime;
        }
        return (long)((double)completionDelay * ratio);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "completionLines";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterCursorLines";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        objectArray2[1] = "com/alibabacloud/intellij/qoder/util/CompletionUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isValidDocumentChange";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isValidReturnType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isAllowMustEmptyLineSuffix";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isValidMiddleLinePosition";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isValidFrontMiddleLinePosition";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isFrontFile";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getInlayChunkMaxLength";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "getInlayChunkMaxPixelLength";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "isTriggerWhenLookup";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "getBelowLinesByOffset";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "findOverlapLineIndex";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "getCommonPrefix";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

