/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.util;

import com.alibabacloud.intellij.qoder.ui.search.component.RoundRectLabel;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.border.Border;

public class ComponentUtil {
    public static JButton createStyledButton(String text, boolean focusable, boolean borderPainted, boolean opaque, boolean bold, boolean contentAreaFilled, Cursor cursor, Border border, Icon icon, String tooltip, ActionListener actionListener) {
        JButton button = new JButton(text);
        button.setFocusable(focusable);
        button.setBorderPainted(borderPainted);
        button.setOpaque(opaque);
        Font font = button.getFont();
        if (bold) {
            font = font.deriveFont(1);
        }
        button.setFont(font);
        button.setCursor(Objects.requireNonNullElseGet(cursor, () -> Cursor.getPredefinedCursor(12)));
        button.setBorder(border != null ? border : JBUI.Borders.empty());
        button.setContentAreaFilled(contentAreaFilled);
        if (icon != null) {
            button.setIcon(icon);
        }
        if (tooltip != null && !tooltip.isEmpty()) {
            button.setToolTipText(tooltip);
        }
        if (actionListener != null) {
            button.addActionListener(actionListener);
        }
        return button;
    }

    public static RoundRectLabel createRoundRectLabel(String text, Color itemSelectionBackground, Cursor cursor, Color itemSelectionForeground, int alignment, MouseListener mouseListener, int leftRightPadding, int topBottomPadding, int cornerRadius, int leftRightMargin) {
        RoundRectLabel label = new RoundRectLabel(text, itemSelectionBackground, leftRightPadding, topBottomPadding, cornerRadius, leftRightMargin);
        label.setBackground(itemSelectionBackground);
        label.setCursor(cursor);
        label.setForeground(itemSelectionForeground);
        label.setHorizontalAlignment(alignment);
        label.addMouseListener(mouseListener);
        label.setOpaque(false);
        return label;
    }
}

