/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.util;

import com.intellij.diff.fragments.DiffFragment;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.LineRange;
import com.intellij.diff.util.TextDiffType;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CosyDiffDrawUtil {
    @NotNull
    public static List<RangeHighlighter> createUnifiedChunkHighlighters(@NotNull Editor editor, @Nullable LineRange deleted, @Nullable LineRange inserted, @Nullable List<? extends DiffFragment> innerFragments) {
        if (editor == null) {
            CosyDiffDrawUtil.$$$reportNull$$$0(0);
        }
        return CosyDiffDrawUtil.createUnifiedChunkHighlighters(editor, deleted, inserted, false, false, innerFragments);
    }

    @NotNull
    public static List<RangeHighlighter> createUnifiedChunkHighlighters(@NotNull Editor editor, @Nullable LineRange deleted, @Nullable LineRange inserted, boolean excluded, boolean skipped, @Nullable List<? extends DiffFragment> innerFragments) {
        if (editor == null) {
            CosyDiffDrawUtil.$$$reportNull$$$0(1);
        }
        boolean ignored = innerFragments != null;
        ArrayList<RangeHighlighter> list = new ArrayList<RangeHighlighter>();
        if (inserted != null && deleted != null && !inserted.isEmpty() && !deleted.isEmpty()) {
            list.addAll(CosyDiffDrawUtil.createHighlighter(editor, deleted.start, deleted.end, TextDiffType.DELETED, ignored, skipped, excluded));
            list.addAll(CosyDiffDrawUtil.createHighlighter(editor, inserted.start, inserted.end, TextDiffType.INSERTED, ignored, skipped, excluded));
        } else if (inserted != null && !inserted.isEmpty()) {
            list.addAll(CosyDiffDrawUtil.createHighlighter(editor, inserted.start, inserted.end, TextDiffType.INSERTED, ignored, skipped, excluded));
        } else if (deleted != null && !deleted.isEmpty()) {
            list.addAll(CosyDiffDrawUtil.createHighlighter(editor, deleted.start, deleted.end, TextDiffType.DELETED, ignored, skipped, excluded));
        }
        if (innerFragments != null && !skipped) {
            int deletedStartOffset = -1;
            if (deleted != null) {
                deletedStartOffset = editor.getDocument().getLineStartOffset(deleted.start);
            }
            int insertedStartOffset = -1;
            if (inserted != null) {
                insertedStartOffset = editor.getDocument().getLineStartOffset(inserted.start);
            }
            for (DiffFragment diffFragment : innerFragments) {
                if (deletedStartOffset >= 0) {
                    int deletedWordStart = deletedStartOffset + diffFragment.getStartOffset1();
                    int deletedWordEnd = deletedStartOffset + diffFragment.getEndOffset1();
                    list.addAll(DiffDrawUtil.createInlineHighlighter((Editor)editor, (int)deletedWordStart, (int)deletedWordEnd, (TextDiffType)TextDiffType.DELETED));
                }
                if (insertedStartOffset < 0) continue;
                int insertedWordStart = insertedStartOffset + diffFragment.getStartOffset2();
                int insertedWordEnd = insertedStartOffset + diffFragment.getEndOffset2();
                list.addAll(DiffDrawUtil.createInlineHighlighter((Editor)editor, (int)insertedWordStart, (int)insertedWordEnd, (TextDiffType)TextDiffType.INSERTED));
            }
        }
        ArrayList<RangeHighlighter> arrayList = list;
        if (arrayList == null) {
            CosyDiffDrawUtil.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @NotNull
    private static List<RangeHighlighter> createHighlighter(@NotNull Editor editor, int startLine, int endLine, @NotNull TextDiffType type, boolean ignored, boolean excludedInEditor, boolean excludedInGutter) {
        if (editor == null) {
            CosyDiffDrawUtil.$$$reportNull$$$0(3);
        }
        if (type == null) {
            CosyDiffDrawUtil.$$$reportNull$$$0(4);
        }
        List list = new DiffDrawUtil.LineHighlighterBuilder(editor, startLine, endLine, type).withIgnored(ignored).withExcludedInEditor(excludedInEditor).withExcludedInGutter(excludedInGutter).done();
        if (list == null) {
            CosyDiffDrawUtil.$$$reportNull$$$0(5);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/alibabacloud/intellij/qoder/util/CosyDiffDrawUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/alibabacloud/intellij/qoder/util/CosyDiffDrawUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createUnifiedChunkHighlighters";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createHighlighter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createUnifiedChunkHighlighters";
                break;
            }
            case 2: 
            case 5: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createHighlighter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

