/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.util;

import com.alibabacloud.intellij.qoder.util.KeyboardUtil;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.InputEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;

public class CosyKeymapUtil {
    private static final Logger LOGGER = Logger.getInstance(CosyKeymapUtil.class);

    public String[] getShortcutTexts(String actionId) {
        String shortcutText = KeyboardUtil.getShortcutText(actionId);
        if (shortcutText == null) {
            return null;
        }
        if (shortcutText.contains("+")) {
            return shortcutText.split("\\+");
        }
        String[] texts = new String[shortcutText.length()];
        for (int i = 0; i < shortcutText.length(); ++i) {
            texts[i] = shortcutText.substring(i, i + 1);
        }
        return texts;
    }

    public static List<String> getShortcutTextList(String actionId) {
        try {
            AnAction action = ActionManager.getInstance().getAction(actionId);
            if (action == null) {
                return null;
            }
            ShortcutSet set = action.getShortcutSet();
            Object[] shortcuts = set.getShortcuts();
            KeyboardShortcut shortcut = (KeyboardShortcut)ContainerUtil.findInstance((Object[])shortcuts, KeyboardShortcut.class);
            if (shortcut == null) {
                return null;
            }
            KeyStroke accelerator = shortcut.getFirstKeyStroke();
            return CosyKeymapUtil.getKeyStrokeKeys(accelerator);
        }
        catch (Exception e) {
            LOGGER.warn("fail to get shortcut for " + actionId, (Throwable)e);
            return null;
        }
    }

    public static List<String> getKeyStrokeKeys(KeyStroke accelerator) {
        if (CosyKeymapUtil.isNativeMacShortcuts()) {
            List<String> keys = CosyKeymapUtil.getMacModifiersText(accelerator.getModifiers());
            String key = KeymapUtil.getKeyText((int)accelerator.getKeyCode());
            keys.add(key);
            return keys;
        }
        ArrayList<String> keys = new ArrayList<String>();
        int modifiers = accelerator.getModifiers();
        if (modifiers > 0) {
            List<String> modifierKeys = CosyKeymapUtil.getModifiersText(modifiers);
            if (modifierKeys == null) {
                return null;
            }
            keys.addAll(modifierKeys);
        }
        int code = accelerator.getKeyCode();
        if (CosyKeymapUtil.isSimplifiedMacShortcuts()) {
            keys.add(CosyKeymapUtil.getSimplifiedMacKeyText(code));
        } else {
            keys.add(KeymapUtil.getKeyText((int)code));
        }
        return keys;
    }

    private static String getSimplifiedMacKeyText(int code) {
        switch (code) {
            case 3: {
                return "Cancel";
            }
            case 8: {
                return "Backspace";
            }
            case 9: {
                return "Tab";
            }
            case 10: {
                return "Enter";
            }
            case 12: {
                return "Clear";
            }
            case 16: {
                return "Shift";
            }
            case 17: {
                return "Control";
            }
            case 18: {
                return "Alt";
            }
            case 19: {
                return "Pause";
            }
            case 20: {
                return "Caps Lock";
            }
            case 27: {
                return "Escape";
            }
            case 32: {
                return "Space";
            }
            case 33: {
                return "Page Up";
            }
            case 34: {
                return "Page Down";
            }
            case 35: {
                return "End";
            }
            case 36: {
                return "Home";
            }
            case 37: {
                return "Left";
            }
            case 38: {
                return "Up";
            }
            case 39: {
                return "Right";
            }
            case 40: {
                return "Down";
            }
            case 106: {
                return "NumPad *";
            }
            case 107: {
                return "NumPad +";
            }
            case 108: {
                return "NumPad ,";
            }
            case 109: {
                return "NumPad -";
            }
            case 110: {
                return "NumPad .";
            }
            case 111: {
                return "NumPad /";
            }
            case 112: {
                return "F1";
            }
            case 113: {
                return "F2";
            }
            case 114: {
                return "F3";
            }
            case 115: {
                return "F4";
            }
            case 116: {
                return "F5";
            }
            case 117: {
                return "F6";
            }
            case 118: {
                return "F7";
            }
            case 119: {
                return "F8";
            }
            case 120: {
                return "F9";
            }
            case 121: {
                return "F10";
            }
            case 122: {
                return "F11";
            }
            case 123: {
                return "F12";
            }
            case 127: {
                return "Delete";
            }
            case 144: {
                return "Num Lock";
            }
            case 145: {
                return "Scroll Lock";
            }
            case 154: {
                return "Print Screen";
            }
            case 155: {
                return "Insert";
            }
            case 156: {
                return "Help";
            }
            case 157: {
                return "Meta";
            }
            case 224: {
                return "Up";
            }
            case 225: {
                return "Down";
            }
            case 226: {
                return "Left";
            }
            case 227: {
                return "Right";
            }
            case 524: {
                return "Windows";
            }
            case 525: {
                return "Context Menu";
            }
            case 61440: {
                return "F13";
            }
            case 61441: {
                return "F14";
            }
            case 61442: {
                return "F15";
            }
            case 61443: {
                return "F16";
            }
            case 61444: {
                return "F17";
            }
            case 61445: {
                return "F18";
            }
            case 61446: {
                return "F19";
            }
            case 61447: {
                return "F20";
            }
            case 61448: {
                return "F21";
            }
            case 61449: {
                return "F22";
            }
            case 61450: {
                return "F23";
            }
            case 61451: {
                return "F24";
            }
            case 65312: {
                return "Compose";
            }
            case 65368: {
                return "Begin";
            }
            case 65406: {
                return "Alt Graph";
            }
        }
        return KeymapUtil.getKeyText((int)code);
    }

    private static boolean isNativeMacShortcuts() {
        return SystemInfo.isMac && !CosyKeymapUtil.isSimplifiedMacShortcuts();
    }

    private static boolean isSimplifiedMacShortcuts() {
        return SystemInfo.isMac && Registry.is((String)"ide.macos.disable.native.shortcut.symbols", (boolean)false);
    }

    @NotNull
    private static List<String> getModifiersText(int modifiers) {
        List<String> keyModifiersText;
        if (CosyKeymapUtil.isNativeMacShortcuts()) {
            return CosyKeymapUtil.getMacModifiersText(modifiers);
        }
        if (CosyKeymapUtil.isSimplifiedMacShortcuts()) {
            keyModifiersText = CosyKeymapUtil.getSimplifiedMacKeyModifiersText(modifiers);
        } else {
            String text = InputEvent.getModifiersExText(modifiers);
            if (text.isEmpty()) {
                return new ArrayList<String>();
            }
            keyModifiersText = Arrays.asList(text.split("\\+"));
        }
        List<String> list = keyModifiersText;
        if (list == null) {
            CosyKeymapUtil.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    static List<String> getMacModifiersText(int modifiers) {
        ArrayList<String> buf = new ArrayList<String>();
        if ((modifiers & 2) != 0) {
            buf.add(CosyKeymapUtil.get("\u2303", "Ctrl"));
        }
        if ((modifiers & 8) != 0) {
            buf.add(CosyKeymapUtil.get("\u2325", "Alt"));
        }
        if ((modifiers & 1) != 0) {
            buf.add(CosyKeymapUtil.get("\u21e7", "Shift"));
        }
        if ((modifiers & 0x20) != 0) {
            buf.add(Toolkit.getProperty("AWT.altGraph", "Alt Graph"));
        }
        if ((modifiers & 0x10) != 0) {
            buf.add(Toolkit.getProperty("AWT.button1", "Button1"));
        }
        if ((modifiers & 4) != 0) {
            buf.add(CosyKeymapUtil.get("\u2318", "Cmd"));
        }
        ArrayList<String> arrayList = buf;
        if (arrayList == null) {
            CosyKeymapUtil.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @NotNull
    private static String get(@NotNull String value, @NotNull String replacement) {
        if (value == null) {
            CosyKeymapUtil.$$$reportNull$$$0(2);
        }
        if (replacement == null) {
            CosyKeymapUtil.$$$reportNull$$$0(3);
        }
        if (Registry.is((String)"ide.macos.disable.native.shortcut.symbols", (boolean)false)) {
            String string = replacement;
            if (string == null) {
                CosyKeymapUtil.$$$reportNull$$$0(4);
            }
            return string;
        }
        Font font = UIUtil.getLabelFont();
        String string = font != null && font.canDisplayUpTo(value) != -1 ? replacement : value;
        if (string == null) {
            CosyKeymapUtil.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static List<String> getSimplifiedMacKeyModifiersText(int modifiers) {
        ArrayList<String> buf = new ArrayList<String>();
        if ((modifiers & 4) != 0) {
            buf.add("Cmd");
        }
        if ((modifiers & 2) != 0) {
            buf.add("Ctrl");
        }
        if ((modifiers & 8) != 0) {
            buf.add("Opt");
        }
        if ((modifiers & 1) != 0) {
            buf.add("Shift");
        }
        if ((modifiers & 0x20) != 0) {
            buf.add("Alt Graph");
        }
        if ((modifiers & 0x10) != 0) {
            buf.add("Button1");
        }
        return buf;
    }

    public static String getKeyStrokeShortcutText(KeyStroke keyStroke) {
        KeyboardShortcut shortcut = new KeyboardShortcut(keyStroke, null);
        return KeymapUtil.getShortcutText((Shortcut)shortcut);
    }

    public static String getEscKeyText() {
        if (SystemInfo.isMac) {
            return "esc";
        }
        return "Esc";
    }

    public static String getKeyWithModifiers(int keyCode, int ... modifierMasks) {
        return CosyKeymapUtil.getKeyStrokeShortcutText(CosyKeymapUtil.getKeyStroke(keyCode, modifierMasks));
    }

    public static KeyStroke getKeyStroke(int keyCode, int ... modifierMasks) {
        int combinedModifiers = 0;
        for (int modifier : modifierMasks) {
            combinedModifiers |= modifier;
        }
        return KeyStroke.getKeyStroke(keyCode, combinedModifiers);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/alibabacloud/intellij/qoder/util/CosyKeymapUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiersText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getMacModifiersText";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/alibabacloud/intellij/qoder/util/CosyKeymapUtil";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

