/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.util;

import com.intellij.diff.fragments.DiffFragment;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.fragments.LineFragmentImpl;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class DiffUtil {
    public static LineFragment addOffset(LineFragment fragment, int lineOffset, int offsetOfLine) {
        int startLine1 = fragment.getStartLine1() + lineOffset;
        int endLine1 = fragment.getEndLine1() + lineOffset;
        int startLine2 = fragment.getStartLine2() + lineOffset;
        int endLine2 = fragment.getEndLine2() + lineOffset;
        int startOffset1 = fragment.getStartOffset1() + offsetOfLine;
        int endOffset1 = fragment.getEndOffset1() + offsetOfLine;
        int startOffset2 = fragment.getStartOffset2() + offsetOfLine;
        int endOffset2 = fragment.getEndOffset2() + offsetOfLine;
        return new LineFragmentImpl(startLine1, endLine1, startLine2, endLine2, startOffset1, endOffset1, startOffset2, endOffset2, fragment.getInnerFragments());
    }

    public static boolean isDeleteWord(String originText, String newText, LineFragment fragment, DiffFragment innerFragment) {
        Document originDoc = EditorFactory.getInstance().createDocument((CharSequence)originText);
        Document newDoc = EditorFactory.getInstance().createDocument((CharSequence)newText);
        if (innerFragment.getStartOffset1() == innerFragment.getStartOffset2() && innerFragment.getEndOffset1() > innerFragment.getEndOffset2()) {
            int originStartOffset = originDoc.getLineStartOffset(fragment.getStartLine1());
            int newStartOffset = newDoc.getLineStartOffset(fragment.getStartLine2());
            String originWord = originDoc.getText(new TextRange(originStartOffset + innerFragment.getStartOffset1(), originStartOffset + innerFragment.getEndOffset1()));
            String newWord = newDoc.getText(new TextRange(newStartOffset + innerFragment.getStartOffset2(), newStartOffset + innerFragment.getEndOffset2()));
            return originWord.startsWith(newWord);
        }
        return false;
    }

    public static boolean isValidDiffs(List<LineFragment> diffs, String origin, String newText) {
        String[] newLines = newText.split("\n", -1);
        String[] originLines = origin.split("\n", -1);
        for (LineFragment diff : diffs) {
            Object[] rangeLines;
            String line;
            if (diff.getInnerFragments() != null && !diff.getInnerFragments().isEmpty()) {
                return true;
            }
            if (!(diff.getEndLine1() == diff.getStartLine1() && diff.getEndLine2() != diff.getStartLine2() ? DiffUtil.isValidChange(line = StringUtils.join((Object[])(rangeLines = Arrays.copyOfRange(newLines, diff.getStartLine2(), diff.getEndLine2())), (String)"\n")) : diff.getEndLine1() != diff.getStartLine1() && diff.getEndLine2() == diff.getStartLine2() && DiffUtil.isValidChange(line = StringUtils.join((Object[])(rangeLines = Arrays.copyOfRange(originLines, diff.getStartLine1(), diff.getEndLine1())), (String)"\n")))) continue;
            return true;
        }
        return false;
    }

    private static boolean isValidChange(String content) {
        return StringUtils.isNotBlank((CharSequence)StringUtils.strip((String)content, (String)"\r\n\t {};()<>"));
    }

    public static void applyDiff(Project project, Document document, String newCode, List<LineFragment> diffs, int startLine) {
        if (diffs == null || diffs.isEmpty()) {
            return;
        }
        WriteCommandAction.runWriteCommandAction((Project)project, (String)"Apply Tongyi Inline Edit", (String)"TONGYI", () -> {
            for (int i = diffs.size() - 1; i >= 0; --i) {
                LineFragment diff = (LineFragment)diffs.get(i);
                String[] newCodeLines = newCode.split("\n", -1);
                Object replacement = "";
                if (diff.getStartLine2() < diff.getEndLine2()) {
                    replacement = String.join((CharSequence)"\n", Arrays.copyOfRange(newCodeLines, diff.getStartLine2(), diff.getEndLine2()));
                    if (diff.getEndLine2() < newCodeLines.length) {
                        replacement = (String)replacement + "\n";
                    }
                }
                String finalReplacement = replacement;
                if (diff.getStartLine1() != diff.getEndLine1()) {
                    int startOffset = document.getLineStartOffset(startLine + diff.getStartLine1());
                    int endOffset = document.getLineEndOffset(startLine + diff.getEndLine1() - 1);
                    document.replaceString(startOffset, endOffset, (CharSequence)finalReplacement);
                    continue;
                }
                int insertOffset = 0;
                int lineNumber = startLine + diff.getStartLine1();
                insertOffset = lineNumber >= document.getLineCount() ? document.getTextLength() : document.getLineEndOffset(lineNumber);
                document.insertString(insertOffset, (CharSequence)finalReplacement);
            }
        }, (PsiFile[])new PsiFile[0]);
    }
}

