/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.util;

import com.alibabacloud.intellij.qoder.util.FileUtil;
import com.alibabacloud.intellij.qoder.util.StringUtils;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.TextRange;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.ObjectUtils;
import org.jetbrains.annotations.NotNull;

public class DocumentUtils {
    private static final Logger log = Logger.getInstance(DocumentUtils.class);

    public static String getCompleteLine(@NotNull Document document, int line) {
        if (document == null) {
            DocumentUtils.$$$reportNull$$$0(0);
        }
        if (document.getLineCount() < line || line < 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int startLineHead = document.getLineStartOffset(line);
        int startLineEnd = document.getLineEndOffset(line);
        String currentLine = document.getText(new TextRange(startLineHead, startLineEnd));
        sb.append(currentLine);
        while (line > 0 && !StringUtils.isJavaLineEnding(currentLine = document.getText(new TextRange(startLineHead = document.getLineStartOffset(--line), startLineEnd = document.getLineEndOffset(line))))) {
            sb.insert(0, currentLine);
        }
        return sb.toString();
    }

    public static String getCurrentLine(@NotNull Editor editor) {
        if (editor == null) {
            DocumentUtils.$$$reportNull$$$0(1);
        }
        int caretOffset = editor.getCaretModel().getOffset();
        return DocumentUtils.getLineByOffset(editor, caretOffset);
    }

    public static String getLineSuffixByOffset(Document document, int offset) {
        int line = document.getLineNumber(offset);
        int lineEndOffset = document.getLineEndOffset(line);
        return document.getText(new TextRange(offset, lineEndOffset));
    }

    public static String getLinePrefixByOffset(Document document, int offset) {
        int line = document.getLineNumber(offset);
        int lineStartOffset = document.getLineStartOffset(line);
        return document.getText(new TextRange(lineStartOffset, offset));
    }

    public static String getLineByOffset(@NotNull Editor editor, int offset) {
        if (editor == null) {
            DocumentUtils.$$$reportNull$$$0(2);
        }
        int line = editor.getDocument().getLineNumber(offset);
        int startLineHead = editor.getDocument().getLineStartOffset(line);
        int startLineEnd = editor.getDocument().getLineEndOffset(line);
        return editor.getDocument().getText(new TextRange(startLineHead, startLineEnd));
    }

    public static boolean isValidEditorDocument(Document document) {
        return document != null && !document.getClass().getName().contains("com.intellij.openapi.editor.textarea.TextAreaDocument") && !document.getClass().getName().contains("com.intellij.openapi.editor.textarea.TextComponentDocument");
    }

    public static String filterDocumentSlashR(Document document, String content) {
        if (document instanceof DocumentImpl && !((DocumentImpl)document).acceptsSlashR()) {
            return org.apache.commons.lang3.StringUtils.remove((String)content, (char)'\r');
        }
        return content;
    }

    public static String convertSeparatorToSlashN(String content) {
        String separator = FileUtil.getLineSeparator(content);
        return org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)separator) || org.apache.commons.lang3.StringUtils.equals((CharSequence)separator, (CharSequence)"\n") ? content : org.apache.commons.lang3.StringUtils.replace((String)content, (String)separator, (String)"\n");
    }

    public static String convertSeparator(String content, String beforeSeparator, String afterSeparator) {
        return org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)afterSeparator) || org.apache.commons.lang3.StringUtils.equals((CharSequence)beforeSeparator, (CharSequence)afterSeparator) ? content : org.apache.commons.lang3.StringUtils.replace((String)content, (String)beforeSeparator, (String)afterSeparator);
    }

    public static void saveAllUnsavedFiles() {
        try {
            ApplicationManager.getApplication().invokeAndWait(() -> FileDocumentManager.getInstance().saveAllDocuments(), ModalityState.current());
            SwingUtilities.invokeAndWait(() -> FileDocumentManager.getInstance().saveAllDocuments());
            FileDocumentManager.getInstance().saveAllDocuments();
        }
        catch (Exception e) {
            log.warn("saveAllUnsavedFiles error", (Throwable)e);
        }
    }

    public static String getDocumentLines(Document document, int fromLine, int toLine) {
        int maxLineCount = document.getLineCount() - 1;
        fromLine = DocumentUtils.minNumber(maxLineCount, fromLine);
        if (fromLine >= document.getLineCount()) {
            return "";
        }
        toLine = DocumentUtils.minNumber(maxLineCount, toLine);
        int startOffset = document.getLineStartOffset(fromLine);
        int endOffset = document.getLineEndOffset(toLine);
        int textLength = document.getTextLength();
        return document.getText(new TextRange(DocumentUtils.minNumber(startOffset, textLength).intValue(), DocumentUtils.minNumber(endOffset, textLength).intValue()));
    }

    public static Integer minNumber(Integer number1, Integer number2) {
        if (ObjectUtils.allNotNull((Object[])new Object[]{number1, number2})) {
            int minValue = number1 >= 0 && number2 >= 0 ? Math.min(number1, number2) : Math.max(number1, number2);
            return Math.max(minValue, 0);
        }
        Integer minNumber = number1 == null ? number2 : number1;
        return minNumber == null ? 0 : minNumber;
    }

    public static int getSafeLineStartOffset(@NotNull Document document, int lineNumber) {
        if (document == null) {
            DocumentUtils.$$$reportNull$$$0(3);
        }
        if (lineNumber < 0) {
            return 0;
        }
        if (lineNumber >= document.getLineCount()) {
            return document.getTextLength() - 1;
        }
        return document.getLineStartOffset(lineNumber);
    }

    public static int getSafeLineEndOffset(@NotNull Document document, int lineNumber) {
        if (document == null) {
            DocumentUtils.$$$reportNull$$$0(4);
        }
        if (lineNumber < 0) {
            return 0;
        }
        if (lineNumber >= document.getLineCount()) {
            return document.getTextLength() - 1;
        }
        return document.getLineEndOffset(lineNumber);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/alibabacloud/intellij/qoder/util/DocumentUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getCompleteLine";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getCurrentLine";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getLineByOffset";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getSafeLineStartOffset";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getSafeLineEndOffset";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

