/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.util;

import com.alibabacloud.intellij.qoder.util.ReflectUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class FileEditorManagerUtil {
    private static final Logger log = Logger.getInstance(FileEditorManagerUtil.class);
    private static final Method METHOD_GET_SELECTED_TEXT_EDITOR_WITH_LOCK_FREE;

    public static Editor getEditor(FileEditorManager editorManager) {
        if (null != METHOD_GET_SELECTED_TEXT_EDITOR_WITH_LOCK_FREE) {
            try {
                log.debug("getSelectedTextEditor with lock free by reflection");
                return (Editor)METHOD_GET_SELECTED_TEXT_EDITOR_WITH_LOCK_FREE.invoke((Object)editorManager, true);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                log.warn("Failed to getSelectedTextEditor with lock free by reflection", (Throwable)e);
            }
        }
        return null;
    }

    static {
        Class<?> aClass = ReflectUtil.classForNameQuietly("com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl");
        METHOD_GET_SELECTED_TEXT_EDITOR_WITH_LOCK_FREE = ReflectUtil.getMethod(aClass, "getSelectedTextEditor", Boolean.TYPE);
    }
}

