/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.util;

import com.alibabacloud.intellij.qoder.common.CosyConfig;
import com.alibabacloud.intellij.qoder.common.CosySetting;
import com.alibabacloud.intellij.qoder.handle.CustomSchemeHandlerFactory;
import com.alibabacloud.intellij.qoder.search.enums.DocumentOpenModeEnum;
import com.alibabacloud.intellij.qoder.ui.config.CosyPersistentSetting;
import com.alibabacloud.intellij.qoder.util.ProjectUtils;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.jcef.JBCefApp;
import com.intellij.ui.jcef.JBCefBrowser;
import com.jetbrains.cef.JCefAppConfig;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.cef.CefApp;
import org.cef.CefSettings;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.callback.CefSchemeHandlerFactory;
import org.cef.handler.CefLifeSpanHandler;
import org.cef.handler.CefLifeSpanHandlerAdapter;
import org.cef.handler.CefLoadHandler;
import org.cef.handler.CefLoadHandlerAdapter;
import org.cef.network.CefRequest;
import org.jetbrains.annotations.NotNull;

public class JCefUtil {
    private static final Logger LOGGER = Logger.getInstance(JCefUtil.class);
    public static final Map<String, JBCefBrowser> jBCefBrowserMap = new HashMap<String, JBCefBrowser>();

    public static synchronized void removeJBCefBrowser(@NotNull Project project) {
        JBCefBrowser browser;
        if (project == null) {
            JCefUtil.$$$reportNull$$$0(0);
        }
        if (null != (browser = jBCefBrowserMap.get(project.getBasePath()))) {
            if (!browser.isDisposed()) {
                browser.dispose();
            }
            jBCefBrowserMap.remove(project.getBasePath());
        }
    }

    public static synchronized JBCefBrowser getJBCefBrowser(@NotNull Project project) {
        if (project == null) {
            JCefUtil.$$$reportNull$$$0(1);
        }
        JCefUtil.initCefSettings();
        LOGGER.debug("start to init jcef browser");
        JBCefBrowser browser = new JBCefBrowser();
        JCefUtil.registerLifeHandler(browser);
        return browser;
    }

    public static void initDocumentSettings() {
        CosySetting setting = CosyPersistentSetting.getInstance().getState();
        if (setting != null && DocumentOpenModeEnum.OPEN_IN_WEB.equals((Object)setting.getDefaultDocumentOpenMode())) {
            return;
        }
        JCefUtil.initCefSettings();
    }

    public static void initCefSettings() {
        if (!JBCefApp.isSupported()) {
            return;
        }
        try {
            JCefAppConfig config = JCefAppConfig.getInstance();
            CefSettings cefSettings = config.getCefSettings();
            cefSettings.user_agent = "Mozilla/5.0 (Android 6.0)";
            Color bgColor = EditorColorsManager.getInstance().getGlobalScheme().getDefaultBackground();
            CefSettings cefSettings2 = cefSettings;
            Objects.requireNonNull(cefSettings2);
            cefSettings.background_color = new CefSettings.ColorType(cefSettings2, bgColor.getAlpha(), bgColor.getRed(), bgColor.getGreen(), bgColor.getBlue());
        }
        catch (Exception e) {
            LOGGER.warn("Unsupported JBCefBrowser:" + e.getMessage());
        }
    }

    public static void registerLifeSpanHandler(JBCefBrowser paramJBCefBrowser) {
        CefLifeSpanHandlerAdapter cefLifeSpanHandlerAdapter = new CefLifeSpanHandlerAdapter(){

            public void onAfterCreated(CefBrowser param1CefBrowser) {
                CefApp.getInstance().registerSchemeHandlerFactory("file", CosyConfig.isQoderEnabled() ? "qoder" : "lingma", (CefSchemeHandlerFactory)new CustomSchemeHandlerFactory());
            }
        };
        paramJBCefBrowser.getJBCefClient().addLifeSpanHandler((CefLifeSpanHandler)cefLifeSpanHandlerAdapter, paramJBCefBrowser.getCefBrowser());
        JBCefBrowser jBCefBrowser = paramJBCefBrowser;
        Project activeProject = ProjectUtils.getActiveProject();
        Disposer.register((Disposable)activeProject, () -> paramJBCefBrowser.getJBCefClient().removeLifeSpanHandler((CefLifeSpanHandler)cefLifeSpanHandlerAdapter, paramJBCefBrowser.getCefBrowser()));
    }

    public static void registerLifeHandler(final JBCefBrowser jcefBrowser) {
        jcefBrowser.getJBCefClient().addLifeSpanHandler((CefLifeSpanHandler)new CefLifeSpanHandlerAdapter(){

            public void onAfterCreated(CefBrowser browser) {
                LOGGER.info("onAfterCreated: " + browser.getURL());
                super.onAfterCreated(browser);
            }
        }, jcefBrowser.getCefBrowser());
        jcefBrowser.getJBCefClient().addLoadHandler((CefLoadHandler)new CefLoadHandlerAdapter(){

            public void onLoadStart(CefBrowser browser, CefFrame frame, CefRequest.TransitionType transitionType) {
                LOGGER.info("onLoadStart: " + browser.getURL());
                super.onLoadStart(browser, frame, transitionType);
            }

            public void onLoadEnd(CefBrowser browser, CefFrame frame, int httpStatusCode) {
                LOGGER.info("onLoadEnd: " + browser.getURL());
                jcefBrowser.getCefBrowser().executeJavaScript("window.addEventListener('message', (event) => {\n  window.cefQuery({\n    request: JSON.stringify(event.data) \n  });\n});", jcefBrowser.getCefBrowser().getURL(), 0);
            }
        }, jcefBrowser.getCefBrowser());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "project";
        objectArray2[1] = "com/alibabacloud/intellij/qoder/util/JCefUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "removeJBCefBrowser";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getJBCefBrowser";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

