/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.util;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;

public class KeyboardUtil {
    public static String getShortcutText(String actionId) {
        return KeyboardUtil.getShortcutText(actionId, "Missing shortcut key");
    }

    public static String getShortcutText(String actionId, String defaultText) {
        AnAction action = ActionManager.getInstance().getAction(actionId);
        return null == action ? defaultText : StringUtil.defaultIfEmpty((String)KeymapUtil.getFirstKeyboardShortcutText((AnAction)action), (String)defaultText);
    }

    public static int getShortcutKeyCode(String actionId) {
        AnAction action = ActionManager.getInstance().getAction(actionId);
        Object[] shortcuts = action.getShortcutSet().getShortcuts();
        KeyboardShortcut shortcut = (KeyboardShortcut)ContainerUtil.findInstance((Object[])shortcuts, KeyboardShortcut.class);
        if (shortcut == null && shortcut.getFirstKeyStroke() != null) {
            return -1;
        }
        return shortcut.getFirstKeyStroke().getKeyCode();
    }

    public static class KeyboardTypingRecord {
        private static final long MAX_TIME = 1600L;
        private LinkedList<KeyboardTypingStat> list = new LinkedList();

        public void record(int key) {
            this.ensureTime();
            this.list.add(new KeyboardTypingStat(key));
        }

        public boolean contains(int key) {
            this.ensureTime();
            return this.list.stream().anyMatch(stat -> stat.getKey() == key);
        }

        public boolean containsAny(int ... keys) {
            return this.list.stream().anyMatch(stat -> Arrays.stream(keys).anyMatch(key -> key == stat.getKey()));
        }

        private void ensureTime() {
            KeyboardTypingStat stat;
            Iterator iterator = this.list.iterator();
            while (iterator.hasNext() && (stat = (KeyboardTypingStat)iterator.next()).getTime() < System.currentTimeMillis() - 1600L) {
                iterator.remove();
            }
        }
    }

    static class KeyboardTypingStat {
        private int key;
        private long time;

        public KeyboardTypingStat(int key) {
            this.key = key;
            this.time = System.currentTimeMillis();
        }

        public int getKey() {
            return this.key;
        }

        public long getTime() {
            return this.time;
        }
    }
}

