/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.util;

import com.alibabacloud.intellij.qoder.util.language.LanguageMapping;
import com.intellij.openapi.diagnostic.Logger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.apache.commons.collections4.Trie;
import org.apache.commons.collections4.trie.PatriciaTrie;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public class LanguageUtil {
    private static Logger log = Logger.getInstance(LanguageUtil.class);
    public static final String PLAINTEXT = "plaintext";
    private static LanguageMapping languageMapping = LanguageMapping.buildLanguageMapping();
    static Set<String> allKeywords = new HashSet<String>(Arrays.asList("if", "else", "switch", "case", "default", "for", "do", "while", "break", "continue", "return", "try", "catch", "finally", "throw", "throws", "goto", "public", "private", "protected", "static", "final", "abstract", "native", "synchronized", "transient", "volatile", "strictfp", "const", "extern", "register", "explicit", "export", "override", "virtual", "readonly", "unsafe", "internal", "friend", "class", "interface", "enum", "struct", "union", "type", "typedef", "typename", "extends", "implements", "instanceof", "typeof", "sizeof", "typeid", "decltype", "void", "var", "let", "const", "bool", "boolean", "byte", "char", "short", "int", "long", "float", "double", "string", "object", "null", "undefined", "true", "false", "new", "this", "super", "delete", "instanceof", "package", "import", "module", "namespace", "using", "extern", "crate", "mod", "use", "try", "catch", "finally", "throw", "throws", "except", "raise", "function", "fun", "def", "fn", "func", "lambda", "proc", "method", "ref", "mut", "ptr", "sizeof", "alignof", "move", "box", "async", "await", "synchronized", "volatile", "thread_local", "operator", "and", "or", "not", "xor", "in", "is", "as", "None", "pass", "yield", "from", "global", "nonlocal", "assert", "del", "elif", "with", "impl", "trait", "where", "dyn", "macro", "pub", "Self", "self", "match", "chan", "defer", "fallthrough", "func", "go", "interface", "map", "range", "select", "val", "var", "when", "typealias", "constructor", "delegate", "dynamic", "field", "file", "get", "init", "param", "property", "receiver", "set", "actual", "annotation", "companion", "crossinline", "data", "expect", "infix", "inline", "inner", "lateinit", "noinline", "open", "operator", "out", "reified", "sealed", "suspend", "tailrec", "vararg", "checked", "decimal", "delegate", "event", "fixed", "foreach", "lock", "object", "params", "sbyte", "stackalloc", "string", "uint", "ulong", "unchecked", "ushort", "alignas", "alignof", "and_eq", "asm", "bitand", "bitor", "char16_t", "char32_t", "compl", "constexpr", "const_cast", "dynamic_cast", "explicit", "friend", "inline", "mutable", "noexcept", "not_eq", "nullptr", "or_eq", "reinterpret_cast", "static_assert", "static_cast", "template", "wchar_t", "xor_eq", "debugger", "undefined", "with", "yield", "implements", "interface", "declare", "module", "namespace"));
    static Trie<String, String> trie = new PatriciaTrie();
    public static Map<String, String> LANGUAGE_TO_EXT;

    public static String guessExtensionByMarkdownLanguage(String language) {
        if (language == null) {
            return "";
        }
        return LANGUAGE_TO_EXT.getOrDefault(language.toLowerCase(), language.toLowerCase());
    }

    public static String getLanguageByFilePath(String filePath) {
        try {
            String name = filePath.toLowerCase(Locale.ROOT);
            String fileName = FilenameUtils.getName((String)name);
            if (StringUtils.isBlank((CharSequence)fileName)) {
                return PLAINTEXT;
            }
            return languageMapping.getLanguages(fileName);
        }
        catch (Exception e) {
            log.warn("getLanguageByFilePath failed! path: " + filePath, (Throwable)e);
            return PLAINTEXT;
        }
    }

    public static String getExtensionByFileName(String name) {
        try {
            String fileExt = FilenameUtils.getExtension((String)name);
            if (StringUtils.isBlank((CharSequence)fileExt)) {
                return fileExt;
            }
            return fileExt;
        }
        catch (Exception e) {
            e.printStackTrace();
            int index = name.lastIndexOf(".");
            log.warn("getExtensionByFileName name is " + name);
            if (index == -1) {
                return "";
            }
            log.warn("getExtensionByFileName suffix is " + name.substring(index + 1));
            return name.substring(index + 1);
        }
    }

    public static boolean isKeyword(String word) {
        return allKeywords.contains(word);
    }

    public static boolean isKeywordPrefix(String prefix) {
        SortedMap result = trie.prefixMap((Object)prefix);
        return result != null && !result.isEmpty();
    }

    static {
        for (String keyword : allKeywords) {
            trie.put((Object)keyword, (Object)keyword);
        }
        LANGUAGE_TO_EXT = new HashMap<String, String>(){
            {
                this.put("java", "java");
                this.put("python", "py");
                this.put("javascript", "js");
                this.put("typescript", "ts");
                this.put("tsx", "tsx");
                this.put("go", "go");
                this.put("c", "c");
                this.put("cpp", "cpp");
                this.put("c++", "cpp");
                this.put("xml", "xml");
                this.put("html", "html");
                this.put("sql", "sql");
                this.put("sqlite", "sql");
                this.put("php", "php");
                this.put("kotlin", "kt");
                this.put("yaml", "yml");
                this.put("properties", "properties");
                this.put("csharp", "cs");
                this.put("c_sharp", "cs");
                this.put("css", "css");
                this.put("scss", "scss");
                this.put("vue", "vue");
            }
        };
    }
}

