/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.util;

import com.alibabacloud.intellij.qoder.common.BuildFeature;
import com.alibabacloud.intellij.qoder.common.CosyCacheKeys;
import com.alibabacloud.intellij.qoder.common.CosyConfig;
import com.alibabacloud.intellij.qoder.core.Cosy;
import com.alibabacloud.intellij.qoder.core.lsp.model.AuthGrantInfoResult;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.AuthGrantInfo;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.AuthStatus;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.AuthUserTypeEnum;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.AuthWhitelistStatusEnum;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.UserPlanEnum;
import com.alibabacloud.intellij.qoder.core.lsp.model.params.GetGrantInfosParams;
import com.alibabacloud.intellij.qoder.icons.QoderIcons;
import com.alibabacloud.intellij.qoder.service.UserAuthService;
import com.alibabacloud.intellij.qoder.ui.config.AuthOrgItem;
import com.alibabacloud.intellij.qoder.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.qoder.ui.search.topic.AuthStateChangeNotifier;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.Icon;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class LoginUtil {
    private static final Logger LOGGER = Logger.getInstance(LoginUtil.class);
    private static Lock authReportLock = new ReentrantLock();
    private static Condition waitLoginState = authReportLock.newCondition();
    private static AtomicReference<AuthStatus> loginResult = new AtomicReference();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean waitAuthLogin(long time, TimeUnit unit) throws Exception {
        authReportLock.lock();
        try {
            boolean bl = waitLoginState.await(time, unit);
            return bl;
        }
        finally {
            authReportLock.unlock();
        }
    }

    public static void notifyAuthLogin() {
        authReportLock.lock();
        try {
            waitLoginState.signalAll();
        }
        finally {
            authReportLock.unlock();
        }
    }

    public static AuthStatus getAuthStatus(Project project) {
        AuthStatus status = UserAuthService.getInstance().getState(project);
        if (status != null) {
            CosyCacheKeys.KEY_AUTH_STATUS.set((UserDataHolder)ApplicationManager.getApplication(), (Object)status);
        } else {
            status = (AuthStatus)CosyCacheKeys.KEY_AUTH_STATUS.get((UserDataHolder)ApplicationManager.getApplication());
        }
        return status == null || status.getStatus() == null ? AuthStatus.NOT_LOGIN : status;
    }

    public static AuthStatus getAuthStatusCacheFirst(Project project) {
        AuthStatus status = (AuthStatus)CosyCacheKeys.KEY_AUTH_STATUS.get((UserDataHolder)ApplicationManager.getApplication());
        if (status == null && (status = UserAuthService.getInstance().getState(project)) != null) {
            CosyCacheKeys.KEY_AUTH_STATUS.set((UserDataHolder)ApplicationManager.getApplication(), (Object)status);
        }
        return status == null || status.getStatus() == null ? AuthStatus.NOT_LOGIN : status;
    }

    public static void setLoginResult(AuthStatus authStatus) {
        loginResult.getAndSet(authStatus);
        CosyCacheKeys.KEY_AUTH_STATUS.set((UserDataHolder)ApplicationManager.getApplication(), (Object)authStatus);
    }

    public static AuthStatus getLoginResult() {
        return loginResult.get();
    }

    public static void updateAuthStatus(Project project, AuthStatus status, boolean notifyWhenStatusNull) {
        AuthStatus oldStatus = (AuthStatus)CosyCacheKeys.KEY_AUTH_STATUS.get((UserDataHolder)ApplicationManager.getApplication());
        if (!notifyWhenStatusNull && oldStatus == null) {
            CosyCacheKeys.KEY_AUTH_STATUS.set((UserDataHolder)ApplicationManager.getApplication(), (Object)status);
            return;
        }
        if (oldStatus == null || !Objects.equals(oldStatus.getStatus(), status.getStatus()) || !Objects.equals(oldStatus.getWhitelist(), status.getWhitelist())) {
            CosyCacheKeys.KEY_AUTH_STATUS.set((UserDataHolder)ApplicationManager.getApplication(), (Object)status);
            ApplicationManager.getApplication().invokeLater(() -> {
                if (!project.isDisposed()) {
                    ((AuthStateChangeNotifier)project.getMessageBus().syncPublisher(AuthStateChangeNotifier.AUTH_CHANGE_NOTIFICATION)).notifyChangeAuth(status);
                }
            });
        } else {
            CosyCacheKeys.KEY_AUTH_STATUS.set((UserDataHolder)ApplicationManager.getApplication(), (Object)status);
        }
    }

    public static void resetLoginResult() {
        loginResult.set(null);
    }

    public static String getWhitelistText(AuthStatus status) {
        String whiteListText = CosyBundle.message("settings.login.account.tips.whitelist.unknown", new Object[0]);
        if (status.getWhitelist() != null) {
            if (status.getWhitelist().intValue() == AuthWhitelistStatusEnum.NOT_WHITELIST.getValue()) {
                whiteListText = CosyBundle.message("settings.login.account.tips.whitelist.not.apply", new Object[0]);
            } else if (status.getWhitelist().intValue() == AuthWhitelistStatusEnum.NO_LICENCE.getValue()) {
                whiteListText = CosyBundle.message("settings.login.account.tips.whitelist.not.apply", new Object[0]);
            } else if (status.getWhitelist().intValue() == AuthWhitelistStatusEnum.PASS.getValue()) {
                whiteListText = CosyBundle.message("settings.login.account.tips.whitelist.passed", new Object[0]);
            } else if (status.getWhitelist().intValue() == AuthWhitelistStatusEnum.WAIT_PASS.getValue()) {
                whiteListText = CosyBundle.message("settings.login.account.tips.whitelist.wait.pass", new Object[0]);
            }
        }
        return whiteListText;
    }

    public static Icon getProfilerIcon(Project project, AuthStatus status) {
        if (status == null) {
            status = LoginUtil.getAuthStatusCacheFirst(project);
        }
        Icon icon = QoderIcons.EditionEnterpriseStandardIcon;
        if (status == null) {
            return icon;
        }
        Icon userIcon = LoginUtil.getIcon(project, status);
        if (null != userIcon) {
            icon = userIcon;
            return icon;
        }
        if (CosyConfig.getFeature(BuildFeature.VPC_ENABLED.getKey(), false)) {
            icon = QoderIcons.EditionEnterpriseDedicatedIcon;
            return icon;
        }
        if (AuthUserTypeEnum.UserTypePersonalStandard.getUserType().equals(status.getUserType()) || StringUtils.isBlank((CharSequence)status.getOrgName())) {
            icon = QoderIcons.EditionIndividualIcon;
            return icon;
        }
        if (AuthUserTypeEnum.UserTypeEnterpriseDedicated.getUserType().equals(status.getUserType())) {
            icon = QoderIcons.EditionEnterpriseDedicatedIcon;
        }
        return icon;
    }

    private static Icon getIcon(Project project, AuthStatus status) {
        UserPlanEnum userType;
        if (null != Cosy.INSTANCE.getLanguageService(project) && null != (userType = UserPlanEnum.getByUserType(status.getUserType()))) {
            return userType.getIcon();
        }
        return null;
    }

    public static List<AuthOrgItem> getOrgItems(Project project, AuthStatus status) {
        ArrayList<AuthOrgItem> orgItems = new ArrayList<AuthOrgItem>();
        try {
            GetGrantInfosParams getGrantInfosParams = GetGrantInfosParams.builder().userId(status.getId()).build();
            AuthGrantInfoResult authGrantInfoResult = Cosy.INSTANCE.getLanguageService(project).getGrantInfoResult(getGrantInfosParams, 3000L);
            if (authGrantInfoResult != null) {
                List<AuthGrantInfo> authGrantInfos = authGrantInfoResult.getAccountInfo();
                if (CollectionUtils.isNotEmpty(authGrantInfos)) {
                    for (AuthGrantInfo info : authGrantInfos) {
                        LOGGER.debug("get login grant info:" + info);
                        if ("personal".equals(info.getGrantType())) {
                            AuthOrgItem org = new AuthOrgItem(info.getUserId(), null, info.getUserName(), "personal");
                            org.setAvatarRealIcon(QoderIcons.EditionIndividualIcon);
                            orgItems.add(org);
                            continue;
                        }
                        if (!"organization".equals(info.getGrantType())) continue;
                        String userId = info.getUserId();
                        if (StringUtils.isBlank((CharSequence)userId)) {
                            userId = status.getId();
                        }
                        AuthOrgItem org = new AuthOrgItem(userId, info.getOrgId(), info.getOrgName(), "org");
                        org.setAvatarRealIcon(LoginUtil.getProfilerIcon(project, status));
                        orgItems.add(org);
                    }
                } else if (authGrantInfoResult.getErrorCode() != null) {
                    LOGGER.warn("get auth grant info error, errorMsg is " + authGrantInfoResult.getErrorMessage() + ",errorCode is " + authGrantInfoResult.getErrorCode());
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("get auth grant info error, errorMsg is " + e.getMessage());
        }
        return orgItems;
    }
}

