/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.util;

import com.alibabacloud.intellij.qoder.common.CosyConfig;
import com.alibabacloud.intellij.qoder.common.CosySetting;
import com.alibabacloud.intellij.qoder.core.Cosy;
import com.alibabacloud.intellij.qoder.ui.config.CosyPersistentSetting;
import com.alibabacloud.intellij.qoder.util.ProcessReader;
import com.alibabacloud.intellij.qoder.util.ThreadUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.util.SystemProperties;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinNT;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class ProcessUtils {
    private static final Logger log = Logger.getInstance(ProcessUtils.class);
    public static final String WINDOWS_OS = "win";
    public static final String LINUX_OS = "nux";
    public static final String LINIX_OS = "nix";
    public static final String MAC_OS = "mac";
    public static final String COSY_PROCESS_NAME = CosyConfig.isQoderEnabled() ? "Qoder" : "Lingma";
    public static final String COSY_PROCESS_DESCRIPTION = CosyConfig.isQoderEnabled() ? "Qoder" : "Lingma";
    public static final int TASK_KILL_TIMEOUT = 5;

    public static boolean isProcessAlive(long pid) {
        String command;
        String osName = System.getProperty("os.name").toLowerCase();
        if (ProcessUtils.isWindowsPlatform()) {
            log.info(String.format("Check alive Windows mode. Pid: [%d]", pid));
            command = "C:\\Windows\\System32\\cmd.exe /c C:\\Windows\\System32\\tasklist.exe /FI \"PID eq " + pid + "\"";
        } else if (osName.contains(LINIX_OS) || osName.contains(LINUX_OS) || osName.contains(MAC_OS)) {
            log.info(String.format("Check alive Linux/Unix mode. Pid: [%d]", pid));
            command = "ps -p " + pid;
        } else {
            log.info(String.format("Unsupported OS: Check alive for Pid: [%d] return false", pid));
            return false;
        }
        return ProcessUtils.isProcessIdRunning(pid, command);
    }

    public static boolean isWindowsPlatform() {
        String osName = System.getProperty("os.name").toLowerCase();
        return osName.indexOf(WINDOWS_OS) >= 0;
    }

    private static boolean isProcessIdRunning(long pid, String command) {
        log.info(String.format("Command [%s]", command));
        try {
            String strLine;
            Runtime rt = Runtime.getRuntime();
            Process pr = rt.exec(command);
            InputStreamReader isReader = new InputStreamReader(pr.getInputStream());
            BufferedReader bReader = new BufferedReader(isReader);
            while ((strLine = bReader.readLine()) != null) {
                if (!strLine.contains(pid + " ")) continue;
                return true;
            }
            return false;
        }
        catch (Exception ex) {
            log.warn(String.format("Got exception using system command [%s].", command), (Throwable)ex);
            return true;
        }
    }

    public static void killProcess(long pid) {
        log.info("Kill cosy process: " + pid);
        Runtime rt = Runtime.getRuntime();
        String osName = System.getProperty("os.name").toLowerCase();
        try {
            Process process = null;
            if (ProcessUtils.isWindowsPlatform()) {
                log.info(String.format("Kill process in Windows mode. Pid: [%d]", pid));
                process = rt.exec("C:\\Windows\\System32\\taskkill.exe /F /T /PID " + pid);
            } else if (osName.contains(LINIX_OS) || osName.contains(LINUX_OS) || osName.contains(MAC_OS)) {
                log.info(String.format("Kill process in Linux/Unix mode. Pid: [%d]", pid));
                process = rt.exec("kill " + pid);
            } else {
                log.info(String.format("Unsupported OS: Check alive for Pid: [%d] return false", pid));
            }
            if (process != null) {
                ProcessReader reader = new ProcessReader(process);
                reader.start();
                log.info("Wait for process killing");
                process.waitFor(5L, TimeUnit.SECONDS);
                log.info("Process killing output:" + reader.getOutput());
                reader.interrupt();
            }
        }
        catch (Exception e) {
            log.warn("Kill process encountered exception");
        }
    }

    public static List<Long> findCosyPidList() {
        return ProcessUtils.getPidListByNameNative(COSY_PROCESS_NAME);
    }

    public static List<Long> getPidListByNameNative(String name) {
        log.info(String.format("Get pid list with native api. Name: [%s]", name));
        String cosyPath = ProcessUtils.getCosyPath();
        log.info("Cosy path: " + cosyPath);
        return ProcessHandle.allProcesses().filter(process -> process.info().command().map(e -> e.contains(name) && e.contains(cosyPath)).orElse(false)).map(ProcessHandle::pid).collect(Collectors.toList());
    }

    public static String getCosyPath() {
        CosySetting setting = CosyPersistentSetting.getInstance().getState();
        Path defaultPath = CosyConfig.isQoderEnabled() ? Paths.get(SystemProperties.getUserHome(), ".qoder", "shared_client") : Paths.get(SystemProperties.getUserHome(), ".lingma");
        return null == setting || null == setting.getLocalStoragePath() ? defaultPath.toString() : setting.getLocalStoragePath();
    }

    public static List<Long> getPidListFromName(String name) {
        String osName = System.getProperty("os.name").toLowerCase();
        if (ProcessUtils.isWindowsPlatform()) {
            log.info(String.format("Get pid list Windows mode. Name: [%s]", name));
            String[] command = new String[]{"powershell", "-Command", "Get-Process -Name " + name + " | Select-Object Id,Path"};
            List<Long> pids = ProcessUtils.getPidListByPowerShell(command);
            if (pids.isEmpty() && (pids = ProcessUtils.getPidListByWmic(command = new String[]{"cmd", "/c", "wmic process where \"name='" + name + ".exe'\" get processid,executablepath"})).isEmpty() && ((pids = ProcessUtils.getPidListWindows(command = new String[]{"cmd", "/c", "tasklist /FI \"IMAGENAME eq " + name + ".exe\""})) == null || pids.isEmpty())) {
                command = new String[]{"c:\\windows\\system32\\cmd.exe", "/c", "c:\\windows\\system32\\tasklist.exe /FI \"IMAGENAME eq " + name + ".exe\""};
                pids = ProcessUtils.getPidListWindows(command);
            }
            return pids;
        }
        if (!osName.contains(LINIX_OS) && !osName.contains(LINUX_OS)) {
            if (osName.contains(MAC_OS)) {
                log.info(String.format("Get pid list MacOS mode. Name: [%s]", name));
                String[] command = new String[]{"/bin/sh", "-c", "ps -eo pid,command | grep " + name};
                List<Long> pids = ProcessUtils.getPidList(command);
                if (pids == null || pids.isEmpty()) {
                    command = new String[]{"pgrep", name};
                    pids = ProcessUtils.getPidListByGrep(command);
                }
                return pids;
            }
            log.info(String.format("Unsupported OS: Get pid list for Name: [%s] return empty list", name));
            return null;
        }
        log.info(String.format("Get pid list Linux/Unix mode. Name: [%s]", name));
        String[] command = new String[]{"/bin/sh", "-c", "ps -eo pid,command | grep " + name};
        return ProcessUtils.getPidList(command);
    }

    private static List<Long> getPidList(String[] command) {
        log.info(String.format("getPidList Command [%s]", String.join((CharSequence)",", command)));
        try {
            Runtime rt = Runtime.getRuntime();
            Process pr = rt.exec(command);
            InputStreamReader isReader = new InputStreamReader(pr.getInputStream());
            BufferedReader bReader = new BufferedReader(isReader);
            String cosyPath = ProcessUtils.getCosyPath();
            return ProcessUtils.runProcessCommand(pr, bReader, new FutureTask(() -> {
                String strLine;
                ArrayList<Long> pidList = new ArrayList<Long>();
                while ((strLine = bReader.readLine()) != null) {
                    String[] outputs;
                    if (!strLine.contains(COSY_PROCESS_DESCRIPTION) || !strLine.contains(cosyPath) || !strLine.contains("start") || (outputs = strLine.trim().split("\\s+")).length <= 0) continue;
                    try {
                        pidList.add(Long.parseLong(outputs[0]));
                    }
                    catch (Exception e) {
                        log.warn(String.format("Parse [%s] and add pid list encountered exception: %s", strLine, e.getMessage()));
                    }
                }
                return pidList;
            }));
        }
        catch (Exception ex) {
            log.warn(String.format("Got exception using system command [%s].", String.join((CharSequence)",", command)), (Throwable)ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> List<T> runProcessCommand(Process process, BufferedReader reader, RunnableFuture<List<T>> future) {
        try {
            ThreadUtil.execute(future);
            List list = (List)future.get(1L, TimeUnit.SECONDS);
            return list;
        }
        catch (TimeoutException e) {
            log.warn("runProcessCommand timeout: " + e.getMessage(), (Throwable)e);
            future.cancel(true);
            List list = Collections.emptyList();
            return list;
        }
        catch (Exception e) {
            log.warn("runProcessCommand error", (Throwable)e);
            List list = Collections.emptyList();
            return list;
        }
        finally {
            try {
                if (null != process && process.isAlive()) {
                    process.destroyForcibly();
                }
                if (null != reader) {
                    reader.close();
                }
            }
            catch (Exception e) {
                log.warn("close reader or failed", (Throwable)e);
            }
        }
    }

    private static List<Long> getPidListWindows(String[] command) {
        log.info(String.format("getPidListWindows Command [%s]", String.join((CharSequence)",", command)));
        try {
            Runtime rt = Runtime.getRuntime();
            Process pr = rt.exec(command);
            InputStreamReader isReader = new InputStreamReader(pr.getInputStream());
            BufferedReader bReader = new BufferedReader(isReader);
            return ProcessUtils.runProcessCommand(pr, bReader, new FutureTask(() -> {
                String strLine;
                ArrayList<Long> pidList = new ArrayList<Long>();
                while ((strLine = bReader.readLine()) != null) {
                    String[] outputs;
                    log.info("windows get pid output:" + strLine);
                    if (!strLine.contains(COSY_PROCESS_DESCRIPTION) || (outputs = strLine.trim().split("[\\s\t]+")).length <= 0) continue;
                    try {
                        pidList.add(Long.parseLong(outputs[1]));
                    }
                    catch (Exception e) {
                        log.warn(String.format("Parse [%s] and add pid list encountered exception: %s", strLine, e.getMessage()));
                    }
                }
                return pidList;
            }));
        }
        catch (Exception ex) {
            log.warn(String.format("Got exception using system command [%s].", String.join((CharSequence)",", command)), (Throwable)ex);
            return null;
        }
    }

    private static List<Long> getPidListByGrep(String[] command) {
        log.info(String.format("getPidListByGrep Command [%s]", String.join((CharSequence)",", command)));
        ArrayList<Long> pids = new ArrayList<Long>();
        try {
            ProcessBuilder pb = new ProcessBuilder(command);
            pb.redirectErrorStream(true);
            Process process = pb.start();
            BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));
            return ProcessUtils.runProcessCommand(process, in, new FutureTask(() -> {
                String line;
                while ((line = in.readLine()) != null) {
                    try {
                        pids.add(Long.parseLong(line.trim()));
                    }
                    catch (Exception e) {
                        log.warn(String.format("Parse [%s] and add pid list encountered exception: %s", line, e.getMessage()));
                    }
                }
                return pids;
            }));
        }
        catch (Exception ex) {
            log.warn(String.format("Got exception using system command [%s].", String.join((CharSequence)",", command)), (Throwable)ex);
            return pids;
        }
    }

    private static List<Long> getPidListByWmic(String[] command) {
        log.info(String.format("getPidListByWmic Command [%s]", String.join((CharSequence)",", command)));
        return ProcessUtils.getPidListByWindowsProcess(command, 1);
    }

    private static List<Long> getPidListByPowerShell(String[] command) {
        log.info(String.format("getPidListByPowerShell Command [%s]", String.join((CharSequence)",", command)));
        return ProcessUtils.getPidListByWindowsProcess(command, 0);
    }

    @NotNull
    private static List<Long> getPidListByWindowsProcess(String[] command, int targetIndex) {
        ArrayList<Long> pids = new ArrayList<Long>();
        try {
            ProcessBuilder pb = new ProcessBuilder(command);
            pb.redirectErrorStream(true);
            Process process = pb.start();
            BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));
            List<String> lines = ProcessUtils.runProcessCommand(process, in, new FutureTask(() -> {
                ArrayList<String> outLines = new ArrayList<String>();
                String cosyPath = ProcessUtils.getCosyPath();
                try {
                    String line;
                    while ((line = in.readLine()) != null) {
                        String[] parts;
                        log.info("windows pid output: " + line);
                        if (!line.contains(COSY_PROCESS_DESCRIPTION) || !line.contains(cosyPath) || (parts = line.trim().split("\\s+")).length <= targetIndex || null == parts[targetIndex]) continue;
                        outLines.add(parts[targetIndex]);
                    }
                }
                catch (Exception e) {
                    log.warn("getPidListByWindowsProcess error", (Throwable)e);
                }
                return outLines;
            }));
            log.info("pid-get process ended.");
            for (String s : lines) {
                if (!StringUtils.isNotEmpty((CharSequence)s)) continue;
                try {
                    pids.add(Long.parseLong(s.trim()));
                }
                catch (Exception e) {
                    log.warn(String.format("Parse [%s] and add pid list encountered exception: %s", lines, e.getMessage()));
                }
            }
        }
        catch (Exception ex) {
            log.warn(String.format("Got exception using system command [%s].", String.join((CharSequence)",", command)), (Throwable)ex);
        }
        ArrayList<Long> arrayList = pids;
        if (arrayList == null) {
            ProcessUtils.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    public static Long getPid(Process process) {
        Long pid = System.getProperty("os.name").toLowerCase().contains("windows") ? ProcessUtils.windowsProcessId(process) : ProcessUtils.unixLikeProcessId(process);
        return pid;
    }

    private static Long unixLikeProcessId(Process process) {
        Class<?> clazz = process.getClass();
        try {
            if ("java.lang.UNIXProcess".equals(clazz.getName()) || "java.lang.ProcessImpl".equals(clazz.getName())) {
                Field pidField = clazz.getDeclaredField("pid");
                pidField.setAccessible(true);
                Object value = pidField.get(process);
                if (value instanceof Integer) {
                    log.debug("Detected pid: {}", new Object[]{value});
                    return ((Integer)value).longValue();
                }
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException exception) {
            // empty catch block
        }
        return null;
    }

    private static Long windowsProcessId(Process process) {
        if (process.getClass().getName().equals("java.lang.Win32Process") || process.getClass().getName().equals("java.lang.ProcessImpl")) {
            try {
                Field f = process.getClass().getDeclaredField("handle");
                f.setAccessible(true);
                long handl = f.getLong(process);
                Kernel32 kernel = Kernel32.INSTANCE;
                WinNT.HANDLE handle = new WinNT.HANDLE();
                handle.setPointer(Pointer.createConstant((long)handl));
                int ret = kernel.GetProcessId(handle);
                log.debug("Detected windows pid: {}", new Object[]{ret});
                return ret;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static boolean checkAndWaitCosyState(@NotNull ProgressIndicator progressIndicator, @NotNull Project project) {
        if (progressIndicator == null) {
            ProcessUtils.$$$reportNull$$$0(1);
        }
        if (project == null) {
            ProcessUtils.$$$reportNull$$$0(2);
        }
        boolean succeed = false;
        if (!Cosy.INSTANCE.checkCosy(project, true)) {
            succeed = Cosy.INSTANCE.checkAndWaitCosyState(progressIndicator, project);
        } else {
            log.info("Cosy state is OK, login/logout directly.");
            succeed = true;
        }
        return succeed;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/alibabacloud/intellij/qoder/util/ProcessUtils";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPidListByWindowsProcess";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/alibabacloud/intellij/qoder/util/ProcessUtils";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkAndWaitCosyState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

