/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.util;

import com.alibabacloud.intellij.qoder.common.CosySetting;
import com.alibabacloud.intellij.qoder.constants.CosyKey;
import com.alibabacloud.intellij.qoder.shared.cache.CacheManager;
import com.alibabacloud.intellij.qoder.shared.cache.TrieCacheManager;
import com.alibabacloud.intellij.qoder.ui.config.CosyPersistentSetting;
import com.alibabacloud.intellij.qoder.util.StringUtils;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.JavaPsiFacadeImpl;
import com.intellij.psi.impl.search.AllClassesSearchExecutor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiElementFilter;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.serviceContainer.AlreadyDisposedException;
import java.awt.Window;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class ProjectUtils {
    private static final Logger log = Logger.getInstance(ProjectUtils.class);
    private static Map<String, Boolean> projectClassCacheStateMap;
    private static boolean JDKLoaded;
    public static final Lock lock;
    public static final Lock JDKLock;

    public static String getProjectBaseDir(Project project) {
        if (project == null) {
            return null;
        }
        String path = project.getBasePath();
        if (path == null) {
            return project.getPresentableUrl();
        }
        return path.replace('/', File.separatorChar);
    }

    public static void updateProjectClassCacheState(Project project, Boolean state) {
        if (project == null || state == null) {
            return;
        }
        if (projectClassCacheStateMap == null) {
            projectClassCacheStateMap = new ConcurrentHashMap<String, Boolean>();
        }
        projectClassCacheStateMap.put(project.getLocationHash(), state);
    }

    public static boolean getProjectClassCacheState(Project project) {
        Boolean result;
        if (project == null) {
            return Boolean.FALSE;
        }
        if (projectClassCacheStateMap == null) {
            projectClassCacheStateMap = new ConcurrentHashMap<String, Boolean>();
        }
        if ((result = projectClassCacheStateMap.get(project.getLocationHash())) == null) {
            return Boolean.FALSE;
        }
        return result;
    }

    public static void addVariableCache(Project project, VirtualFile virtualFile) {
        if (project == null || virtualFile == null) {
            return;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile);
        PsiElement[] variables = PsiTreeUtil.collectElements((PsiElement)psiFile, (PsiElementFilter)new PsiElementFilter(){

            public boolean isAccepted(PsiElement e) {
                return e instanceof PsiVariable;
            }
        });
        List psiVariables = Arrays.stream(variables).map(v -> (PsiVariable)v).collect(Collectors.toList());
        HashMap variableData = new HashMap();
        variableData.put(project.getLocationHash(), psiVariables);
        ApplicationManager.getApplication().putUserData(CosyKey.fileVariableKey, variableData);
    }

    public static void addProjectScopeClassesCache(Project project) {
        if (project == null || project.isDisposed()) {
            return;
        }
        CosySetting setting = CosyPersistentSetting.getInstance().getState();
        if (setting == null || setting.getParameter() == null) {
            return;
        }
        if (lock.tryLock()) {
            try {
                if (DumbService.isDumb((Project)project)) {
                    return;
                }
                if (projectClassCacheStateMap == null) {
                    projectClassCacheStateMap = new ConcurrentHashMap<String, Boolean>();
                }
                if (projectClassCacheStateMap.get(project.getLocationHash()) != null && Boolean.TRUE.equals(projectClassCacheStateMap.get(project.getLocationHash()))) {
                    return;
                }
                ApplicationManager.getApplication().invokeLater(() -> {
                    try {
                        long startTime = System.currentTimeMillis();
                        projectClassCacheStateMap.put(project.getLocationHash(), Boolean.TRUE);
                        log.info(String.format("Start caching project %s", project.getName()));
                        ArrayList<String> classNames = new ArrayList<String>();
                        AllClassesSearchExecutor.processClassNames((Project)project, (GlobalSearchScope)GlobalSearchScope.projectScope((Project)project), s -> {
                            classNames.add((String)s);
                            return true;
                        });
                        TrieCacheManager.getProjectClassTrieCache().batchSet(classNames);
                        log.info(String.format("All cache finished for project %s took %d ms", project.getName(), System.currentTimeMillis() - startTime));
                        projectClassCacheStateMap.put(project.getLocationHash(), Boolean.TRUE);
                    }
                    catch (IndexNotReadyException indexNotReadyException) {
                        projectClassCacheStateMap.put(project.getLocationHash(), Boolean.FALSE);
                        log.debug("addProjectScopeClassesCache when index is not ready, cannot preload class name list");
                    }
                    catch (AlreadyDisposedException alreadyDisposedException) {
                        projectClassCacheStateMap.put(project.getLocationHash(), Boolean.FALSE);
                        log.warn("addProjectScopeClassesCache when service container is already disposed");
                    }
                    catch (Exception e) {
                        projectClassCacheStateMap.put(project.getLocationHash(), Boolean.FALSE);
                        log.warn("AddProjectScopeClassesCache has exception", (Throwable)e);
                    }
                });
            }
            catch (Exception e) {
                log.warn("AddProjectScopeClassesCache has exception: " + e.getMessage());
            }
            finally {
                lock.unlock();
            }
        }
    }

    public static List<String> loadAllClassNames(Project project, String prefix, Predicate<String> filter) {
        ArrayList<String> potentialClassesNames = new ArrayList<String>();
        if (TrieCacheManager.getProjectClassTrieCache().getSize() == 0) {
            ProjectUtils.addProjectScopeClassesCache(project);
            return potentialClassesNames;
        }
        Optional optionalClasses = TrieCacheManager.getProjectClassTrieCache().get(prefix);
        log.debug(String.format("Finish get cache for %s, class size %d", prefix, optionalClasses.isPresent() ? ((List)optionalClasses.get()).size() : 0));
        if (optionalClasses.isPresent() && !((Collection)optionalClasses.get()).isEmpty()) {
            potentialClassesNames.addAll((Collection)optionalClasses.get());
        }
        return potentialClassesNames;
    }

    public static List<PsiClass> getPsiClassByName(Project project, List<String> fullNames) {
        if (fullNames == null || project == null) {
            log.warn("getPsiClassByName failed caused by project or names null");
            return Collections.emptyList();
        }
        ArrayList<PsiClass> result = new ArrayList<PsiClass>();
        for (String fullName : fullNames) {
            Optional optionalPsiClass = CacheManager.getInheritClassCache().getByFullName(StringUtils.extractClassNameFromFullPath(fullName), fullName);
            if (optionalPsiClass.isPresent()) {
                result.add((PsiClass)optionalPsiClass.get());
                continue;
            }
            PsiClass psiClass = JavaPsiFacadeImpl.getInstanceEx((Project)project).findClass(fullName);
            if (psiClass != null) {
                CacheManager.getInheritClassCache().set(psiClass);
                result.add(psiClass);
                continue;
            }
            result.add(null);
        }
        return result;
    }

    public static Project getProjectByPath(String workspacePath) {
        Project[] projects;
        for (Project project : projects = ProjectManager.getInstance().getOpenProjects()) {
            String path = ProjectUtils.getProjectBaseDir(project);
            if (path == null || !path.equals(workspacePath)) continue;
            return project;
        }
        return null;
    }

    public static Project getActiveProject() {
        Project[] projects = ProjectManager.getInstance().getOpenProjects();
        Project activeProject = null;
        Project showingProject = null;
        for (Project project : projects) {
            if (!project.isOpen()) continue;
            Window window = WindowManager.getInstance().suggestParentWindow(project);
            if (window != null && window.isActive()) {
                activeProject = project;
                break;
            }
            if (window == null || !window.isShowing()) continue;
            showingProject = project;
        }
        if (activeProject == null) {
            activeProject = showingProject;
        }
        return activeProject;
    }

    static {
        JDKLoaded = false;
        lock = new ReentrantLock();
        JDKLock = new ReentrantLock();
    }
}

