/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.util;

import com.alibabacloud.intellij.qoder.common.CosyCacheKeys;
import com.alibabacloud.intellij.qoder.core.Cosy;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.GlobalEndpointConfig;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;

public class QoderAgentUtil {
    private static Logger log = Logger.getInstance(QoderAgentUtil.class);

    public static GlobalEndpointConfig getGlobalEndpointConfigDirectly(Project project) {
        if (Cosy.INSTANCE.checkCosy(project)) {
            GlobalEndpointConfig globalConfig = Cosy.INSTANCE.getLanguageService(project).getEndpointConfig(2000L);
            if (globalConfig == null) {
                globalConfig = (GlobalEndpointConfig)CosyCacheKeys.KEY_ENDPOINT_CONFIG.get((UserDataHolder)project);
                log.info("getGlobalEndpointConfigDirectly encountered null, use cached endpoint=" + (globalConfig == null ? "" : globalConfig.getEndpoint()));
                QoderAgentUtil.addDefaultEndpointToCache(project);
            } else {
                CosyCacheKeys.KEY_ENDPOINT_CONFIG.set((UserDataHolder)project, (Object)globalConfig);
                log.info("getGlobalEndpointConfigDirectly succeed, use cached endpoint=" + globalConfig.getEndpoint());
            }
            return globalConfig;
        }
        log.info("getGlobalEndpointConfigDirectly encountered cosy instance not ready, use cached endpoint=" + (CosyCacheKeys.KEY_ENDPOINT_CONFIG.get((UserDataHolder)project) == null ? "" : ((GlobalEndpointConfig)CosyCacheKeys.KEY_ENDPOINT_CONFIG.get((UserDataHolder)project)).getEndpoint()));
        return (GlobalEndpointConfig)CosyCacheKeys.KEY_ENDPOINT_CONFIG.get((UserDataHolder)project);
    }

    public static void addDefaultEndpointToCache(Project project) {
        GlobalEndpointConfig globalEndpointConfig = new GlobalEndpointConfig();
        globalEndpointConfig.setEndpoint("");
        CosyCacheKeys.KEY_ENDPOINT_CONFIG.set((UserDataHolder)project, (Object)globalEndpointConfig);
    }
}

