/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import java.awt.Color;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.tuple.Pair;

public class SchemaColorUtil {
    private static final Logger LOGGER = Logger.getInstance(SchemaColorUtil.class);
    private static final Pattern PATTERN = Pattern.compile("\\{\\{(.+?):(.+?)\\}\\}");
    private static Map<String, Class<?>> colorClasses = new HashMap();

    private static void registerColorClass(String key, String classFullName) {
        try {
            Class<?> clazz = Class.forName(classFullName);
            colorClasses.put(key, clazz);
        }
        catch (Exception e) {
            LOGGER.warn("register color class error:" + classFullName + " caused by " + e.getMessage());
        }
    }

    private static void findColorClass(String classFullName) {
        try {
            Class<?> clazz = Class.forName(classFullName);
            if (clazz != null) {
                Field[] fields;
                for (Field field : fields = clazz.getDeclaredFields()) {
                    LOGGER.info("find color class:" + classFullName + " " + field.getName());
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("find color class error:" + classFullName, (Throwable)e);
        }
    }

    public static List<Pair<String, String>> getSchemaColorList(String text) {
        ArrayList<Pair<String, String>> list = new ArrayList<Pair<String, String>>();
        Matcher matcher = PATTERN.matcher(text);
        while (matcher.find()) {
            String styleName = matcher.group(1).trim();
            String defaultValue = matcher.group(2).trim();
            list.add((Pair<String, String>)Pair.of((Object)styleName, (Object)defaultValue));
        }
        return list;
    }

    public static String applySchemaColor(String text) {
        EditorColorsManager manager = EditorColorsManager.getInstance();
        EditorColorsScheme scheme = manager.getGlobalScheme();
        List<Pair<String, String>> list = SchemaColorUtil.getSchemaColorList(text);
        for (Pair<String, String> pair : list) {
            String[] styleNamArgs;
            String styleNames = (String)pair.getLeft();
            String defaultValue = (String)pair.getRight();
            String key = String.format("{{%s:%s}}", styleNames, defaultValue);
            String targetHexColor = null;
            for (String styleName : styleNamArgs = styleNames.split("\\|")) {
                String[] args = styleName.split("\\.");
                String className = args[0];
                String fieldName = args[1];
                Class<?> clazz = colorClasses.get(className);
                if (clazz == null) continue;
                try {
                    TextAttributes attributes;
                    Field field = clazz.getDeclaredField(fieldName);
                    if (field == null) continue;
                    field.setAccessible(true);
                    Object value = field.get(null);
                    if (value == null || !(value instanceof TextAttributesKey) || (attributes = scheme.getAttributes((TextAttributesKey)value)) == null) continue;
                    Color fontColor = attributes.getForegroundColor();
                    if (fontColor == null) break;
                    targetHexColor = String.format("#%02x%02x%02x", fontColor.getRed(), fontColor.getGreen(), fontColor.getBlue());
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            targetHexColor = targetHexColor == null ? defaultValue : targetHexColor;
            text = text.replace(key, targetHexColor);
        }
        return text;
    }

    static {
        SchemaColorUtil.registerColorClass("default", "com.intellij.openapi.editor.DefaultLanguageHighlighterColors");
        SchemaColorUtil.registerColorClass("xml", "com.intellij.openapi.editor.XmlHighlighterColors");
        SchemaColorUtil.registerColorClass("highlight", "com.intellij.openapi.editor.HighlighterColors");
        SchemaColorUtil.registerColorClass("json", "com.intellij.json.highlighting.JsonSyntaxHighlighterFactory");
        SchemaColorUtil.registerColorClass("markdown", "org.intellij.plugins.markdown.highlighting.MarkdownHighlighterColors");
    }
}

