/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.util;

import com.alibabacloud.intellij.qoder.chat.enums.AgentTagEnum;
import com.alibabacloud.intellij.qoder.common.BuildFeature;
import com.alibabacloud.intellij.qoder.common.CosyConfig;
import com.alibabacloud.intellij.qoder.common.VpcFeature;
import com.alibabacloud.intellij.qoder.constants.InputConstants;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.AuthStatus;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.CustomCommand;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.CustomContext;
import com.alibabacloud.intellij.qoder.core.lsp.model.params.CustomCommandGetResult;
import com.alibabacloud.intellij.qoder.ui.search.enums.ChatContextTypeEnum;
import com.alibabacloud.intellij.qoder.ui.search.enums.SessionTypeEnum;
import com.alibabacloud.intellij.qoder.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.qoder.ui.search.model.SuggestPrompt;
import com.alibabacloud.intellij.qoder.util.LoginUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class SuggestPromptUtil {
    private static Logger logger = Logger.getInstance(SuggestPromptUtil.class);
    public static List<String> CONTEXT_SUPPORT_DRILL_DOWN = new ArrayList<String>(){
        private static final long serialVersionUID = 2583804104168930708L;
        {
            this.add(ChatContextTypeEnum.FILE.getType());
            this.add(ChatContextTypeEnum.GIT_COMMIT.getType());
            this.add(ChatContextTypeEnum.FOLDER.getType());
            this.add(ChatContextTypeEnum.RULE.getType());
        }
    };

    public static boolean isSupportDrillDown(Project project, String contextType) {
        if (CONTEXT_SUPPORT_DRILL_DOWN.contains(contextType)) {
            return true;
        }
        if (ChatContextTypeEnum.TEAM_DOCS.getType().equals(contextType)) {
            AuthStatus authStatus = LoginUtil.getAuthStatusCacheFirst(project);
            return StringUtils.isNotBlank((CharSequence)authStatus.getOrgId());
        }
        return false;
    }

    public static Map<String, SuggestPrompt> getAgentSuggestPrompt(Project project, String sessionType) {
        if (SessionTypeEnum.DEVELOPER.getType().equals(sessionType) || SessionTypeEnum.ASSISTANT.getType().equals(sessionType) || SessionTypeEnum.INLINE.getType().equals(sessionType)) {
            return Collections.emptyMap();
        }
        if (!CosyConfig.getFeature(BuildFeature.VPC_ENABLED.getKey(), false)) {
            return InputConstants.AGENT_SUGGEST_PROMPT_MAP;
        }
        List<String> features = new ArrayList<String>();
        features = CosyConfig.getFeature(BuildFeature.VPC_ENABLED_FEATURES.getKey(), features);
        HashMap<String, SuggestPrompt> agentMap = new HashMap<String, SuggestPrompt>(InputConstants.AGENT_SUGGEST_PROMPT_MAP_FOR_VPC);
        if (CollectionUtils.isNotEmpty(features) && features.contains(VpcFeature.FEATURE_WORKSPACE.getFeature())) {
            agentMap.put("workspace", new SuggestPrompt(AgentTagEnum.WORKSPACE.getId(), AgentTagEnum.WORKSPACE.getName(), null, "agent"));
        }
        return agentMap;
    }

    public static Map<String, SuggestPrompt> getScopeSuggestPrompt(Project project) {
        AuthStatus authStatus = LoginUtil.getAuthStatusCacheFirst(project);
        if (StringUtils.isNotBlank((CharSequence)authStatus.getOrgId())) {
            return InputConstants.SCOPE_SUGGEST_PROMPT_MAP;
        }
        LinkedHashMap<String, SuggestPrompt> scopeSuggestPromptMap = new LinkedHashMap<String, SuggestPrompt>();
        for (Map.Entry<String, SuggestPrompt> suggestPromptEntry : InputConstants.SCOPE_SUGGEST_PROMPT_MAP.entrySet()) {
            SuggestPrompt suggestPrompt = new SuggestPrompt(suggestPromptEntry.getValue());
            if (ChatContextTypeEnum.TEAM_DOCS.getType().equals(suggestPromptEntry.getKey())) {
                suggestPrompt.setHint(CosyBundle.message("individual.team.doc.hint", new Object[0]));
                suggestPrompt.setLinkText(CosyBundle.message("individual.team.doc.learn.more", new Object[0]));
                suggestPrompt.setEnabled(false);
            }
            scopeSuggestPromptMap.put(suggestPromptEntry.getKey(), suggestPrompt);
        }
        return scopeSuggestPromptMap;
    }

    public static Map<String, SuggestPrompt> getAllSuggestPromptOfTag(Project project, String sessionType) {
        HashMap<String, SuggestPrompt> allSuggestPromptMap = new HashMap<String, SuggestPrompt>();
        if (SessionTypeEnum.CHAT.getType().equals(sessionType)) {
            allSuggestPromptMap.putAll(InputConstants.WELCOMING_SUGGEST_PROMPT_MAP);
        }
        allSuggestPromptMap.putAll(SuggestPromptUtil.getAgentSuggestPrompt(project, sessionType));
        for (Map.Entry<String, SuggestPrompt> scopeSuggestPromptEntry : SuggestPromptUtil.getScopeSuggestPrompt(project).entrySet()) {
            if (!scopeSuggestPromptEntry.getValue().isEnabled()) continue;
            allSuggestPromptMap.put(scopeSuggestPromptEntry.getKey(), scopeSuggestPromptEntry.getValue());
        }
        allSuggestPromptMap.putAll(InputConstants.CUSTOM_SUGGEST_PROMPT_MAP);
        return allSuggestPromptMap;
    }

    public static Map<String, SuggestPrompt> getAllSuggestPrompt(Project project, String sessionType) {
        HashMap<String, SuggestPrompt> allSuggestPromptMap = new HashMap<String, SuggestPrompt>();
        allSuggestPromptMap.putAll(InputConstants.WELCOMING_SUGGEST_PROMPT_MAP);
        allSuggestPromptMap.putAll(InputConstants.CONTEXT_SUGGEST_PROMPT_MAP);
        allSuggestPromptMap.putAll(InputConstants.WELCOMING_HELP_MAP);
        allSuggestPromptMap.putAll(SuggestPromptUtil.getAgentSuggestPrompt(project, sessionType));
        allSuggestPromptMap.putAll(SuggestPromptUtil.getScopeSuggestPrompt(project));
        allSuggestPromptMap.putAll(InputConstants.CUSTOM_SUGGEST_PROMPT_MAP);
        allSuggestPromptMap.putAll(InputConstants.NEW_TASK_SUGGEST_PROMPT_MAP);
        return allSuggestPromptMap;
    }

    public static Map<String, SuggestPrompt> updateCustomSuggestPrompt(Project project, CustomCommandGetResult customCommandGetResult) {
        try {
            List<CustomCommand> customCommands = customCommandGetResult.getCommands();
            List<CustomContext> customContexts = customCommandGetResult.getContextProviders();
            String positionRelativeToSystem = customCommandGetResult.getCommandShowPosition();
            if (StringUtils.isNotBlank((CharSequence)positionRelativeToSystem)) {
                InputConstants.CUSTOM_SUGGEST_POSITION.put("RELATIVE_TO_SYSTEM", positionRelativeToSystem);
            }
            if (customCommands != null) {
                InputConstants.CUSTOM_SUGGEST_PROMPT_MAP.clear();
                for (CustomCommand customCommand : customCommands) {
                    SuggestPrompt suggestPrompt = new SuggestPrompt(customCommand.getIdentifier(), "/" + customCommand.getName(), customCommand.getDisplayName(), customCommand.getName(), null, "task", false);
                    suggestPrompt.setRequiredContextItems(customCommand.getRequiredContextItems());
                    suggestPrompt.setRequiredContextProviders(customCommand.getRequiredContextProviders());
                    suggestPrompt.setNeedClearContext(customCommand.getNeedClearContext());
                    InputConstants.CUSTOM_SUGGEST_PROMPT_MAP.put(customCommand.getName(), suggestPrompt);
                }
            } else {
                InputConstants.CUSTOM_SUGGEST_PROMPT_MAP.clear();
            }
            InputConstants.SCOPE_SUGGEST_PROMPT_MAP.clear();
            if (customContexts != null) {
                for (CustomContext customContext : customContexts) {
                    boolean drillDownEnable = SuggestPromptUtil.isSupportDrillDown(project, customContext.getName());
                    SuggestPrompt suggestPrompt = new SuggestPrompt(customContext.getIdentifier(), "@" + customContext.getName(), customContext.getDisplayName(), customContext.getName(), null, "context", drillDownEnable);
                    suggestPrompt.setComponentType(customContext.getComponentType());
                    suggestPrompt.setSourceType(customContext.getSourceType());
                    HashMap<String, Object> extra = new HashMap<String, Object>();
                    extra.put("contextType", customContext.getName());
                    suggestPrompt.setExtra(extra);
                    InputConstants.SCOPE_SUGGEST_PROMPT_MAP.put(customContext.getName(), suggestPrompt);
                }
            }
        }
        catch (Exception e) {
            logger.error("updateCustomSuggestPrompt error", (Throwable)e);
        }
        return InputConstants.CUSTOM_SUGGEST_PROMPT_MAP;
    }

    private static List<CustomContext> mockGitContext() {
        ArrayList<CustomContext> customContexts = new ArrayList<CustomContext>();
        CustomContext gitDiffContext = new CustomContext("codeChanges", "", "11111gitDiff", "general", "system");
        CustomContext gitCommitContext = new CustomContext("gitCommit", "", "22222gitCommit", "comboBox", "system");
        customContexts.add(gitDiffContext);
        customContexts.add(gitCommitContext);
        return customContexts;
    }
}

