/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.util;

import com.alibabacloud.intellij.qoder.common.CosyConfig;
import com.intellij.openapi.diagnostic.Logger;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class ZipUtil {
    private static final Logger log = Logger.getInstance(ZipUtil.class);
    private static final int BUFFER_SIZE = 8192;
    private static final String EXTENSION_FOLDER = "extension";

    /*
     * Enabled aggressive exception aggregation
     */
    public static String readZipFileToString(File srcZipFile, String targetFileName) {
        try (ZipFile zipFile = new ZipFile(srcZipFile);){
            String string;
            block13: {
                InputStream zipInputStream = zipFile.getInputStream(zipFile.getEntry(targetFileName));
                try {
                    string = IOUtils.toString((InputStream)zipInputStream, (Charset)StandardCharsets.UTF_8);
                    if (zipInputStream == null) break block13;
                }
                catch (Throwable throwable) {
                    if (zipInputStream != null) {
                        try {
                            zipInputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                zipInputStream.close();
            }
            return string;
        }
        catch (IOException e) {
            log.error("fail to read " + targetFileName + " from " + srcZipFile + " Cause " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static File unZip(File srcFile, String destDirPath, List<String> excludeDirs, Set<String> binaryDirs) throws RuntimeException {
        if (!srcFile.exists()) {
            throw new RuntimeException(srcFile.getPath() + " not found");
        }
        File finalDir = null;
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(srcFile);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (ZipUtil.isExclude(excludeDirs, entry.getName())) continue;
                if (entry.isDirectory()) {
                    File dir = new File(destDirPath, entry.getName());
                    dir.mkdirs();
                    if (!binaryDirs.contains(dir.getName())) continue;
                    finalDir = dir;
                    continue;
                }
                File targetFile = new File(destDirPath, entry.getName());
                if (!targetFile.getParentFile().exists()) {
                    targetFile.getParentFile().mkdirs();
                }
                if (targetFile.exists()) {
                    targetFile.delete();
                }
                targetFile.createNewFile();
                InputStream is = zipFile.getInputStream(entry);
                FileUtils.copyToFile((InputStream)is, (File)targetFile);
                targetFile.setExecutable(true);
            }
        }
        catch (Exception e) {
            try {
                throw new RuntimeException("unzip error:" + srcFile, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(zipFile);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)zipFile);
        return finalDir;
    }

    private static boolean isExclude(List<String> excludeDirs, String entryName) {
        for (String excludeDir : excludeDirs) {
            if (!entryName.contains(excludeDir)) continue;
            return true;
        }
        return false;
    }

    public static void toZip(List<File> srcFiles, OutputStream out) throws Exception {
        ZipOutputStream zos = null;
        FileInputStream in = null;
        try {
            zos = new ZipOutputStream(out);
            for (File srcFile : srcFiles) {
                int len;
                byte[] buf = new byte[8192];
                zos.putNextEntry(new ZipEntry(srcFile.getName()));
                in = new FileInputStream(srcFile);
                while ((len = in.read(buf)) != -1) {
                    zos.write(buf, 0, len);
                }
                zos.closeEntry();
                in.close();
            }
        }
        catch (Exception e) {
            try {
                throw new RuntimeException("zip error:" + srcFiles, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(zos);
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)zos);
        IOUtils.closeQuietly(in);
    }

    public static String getEntryToString(String zipResource, String entryName) throws IOException {
        byte[] bytes = ZipUtil.getEntryToBytes(zipResource, entryName);
        if (bytes == null) {
            return null;
        }
        return new String(bytes);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] getEntryToBytes(String zipResource, String entryName) throws IOException {
        InputStream ins = ZipUtil.class.getResourceAsStream(zipResource);
        if (ins == null) {
            return null;
        }
        try (ZipInputStream zin = new ZipInputStream(ins);){
            int len;
            ZipEntry entry = null;
            do {
                if ((entry = zin.getNextEntry()) == null) return null;
            } while (entry.isDirectory() || !entry.getName().equals(entryName));
            byte[] buf = new byte[8192];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while ((len = zin.read(buf)) != -1) {
                baos.write(buf, 0, len);
            }
            baos.flush();
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public static List<String> getEntryFilePaths(String zipResource, List<String> excludeDirs) {
        ArrayList<String> paths = new ArrayList<String>();
        InputStream ins = ZipUtil.class.getResourceAsStream(zipResource);
        if (ins == null) {
            return null;
        }
        try (ZipInputStream zin = new ZipInputStream(ins);){
            ZipEntry entry;
            while ((entry = zin.getNextEntry()) != null) {
                if (entry.isDirectory() || ZipUtil.isExclude(excludeDirs, entry.getName())) continue;
                paths.add(entry.getName());
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return paths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkZipBinary(String destDirPath, String archType) {
        Path targetDir = Paths.get(destDirPath, new String[0]);
        if (!Files.exists(targetDir, new LinkOption[0])) {
            return false;
        }
        InputStream stream = ZipUtil.class.getResourceAsStream(CosyConfig.getCosyBinaryResource());
        if (stream == null) {
            return false;
        }
        try (ZipInputStream zis = new ZipInputStream(stream);){
            while (true) {
                ZipEntry entry;
                if ((entry = zis.getNextEntry()) != null) {
                    String[] parts = entry.getName().split("[/\\\\]");
                    if (parts.length > 1 && !ZipUtil.needUnzip(parts[1], archType)) continue;
                    Path targetPath = targetDir.resolve(entry.getName());
                    if (Files.exists(targetPath, new LinkOption[0])) continue;
                    log.warn("check zip binary not found file " + targetPath);
                    boolean bl = false;
                    return bl;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            log.warn("check zip binary error", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            IOUtils.closeQuietly((InputStream)stream);
        }
        return true;
    }

    public static File unZipBinary(String destDirPath, String archType) throws Exception {
        InputStream stream;
        Path targetDir = Paths.get(destDirPath, new String[0]);
        if (!Files.exists(targetDir, new LinkOption[0])) {
            log.info("create dir " + targetDir);
            Files.createDirectories(targetDir, new FileAttribute[0]);
        }
        if ((stream = ZipUtil.class.getResourceAsStream(CosyConfig.getCosyBinaryResource())) == null) {
            log.warn("unzip binary error, cosy binary resource not found");
            return null;
        }
        File finalDir = null;
        try (ZipInputStream zis = new ZipInputStream(stream);){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                boolean newFile;
                boolean delete;
                boolean mkdir;
                String[] parts = entry.getName().split("[/\\\\]");
                if (parts.length > 1 && !ZipUtil.needUnzip(parts[1], archType)) continue;
                log.info("unzip binary:" + entry.getName());
                Path targetPath = targetDir.resolve(entry.getName());
                if (entry.isDirectory()) {
                    if (!Files.exists(targetPath, new LinkOption[0])) {
                        Files.createDirectories(targetPath, new FileAttribute[0]);
                    }
                    if (parts.length <= 1 || !parts[parts.length - 1].equalsIgnoreCase(archType)) continue;
                    finalDir = targetPath.toFile();
                    continue;
                }
                File targetFile = new File(destDirPath, entry.getName());
                if (!targetFile.getParentFile().exists() && !(mkdir = targetFile.getParentFile().mkdirs())) {
                    log.warn("create dir " + targetFile.getParentFile().getAbsolutePath() + " failed");
                }
                if (targetFile.exists() && !(delete = targetFile.delete())) {
                    log.warn("delete file " + targetFile.getAbsolutePath() + " failed");
                }
                if (!(newFile = targetFile.createNewFile())) {
                    log.warn("create file " + targetFile.getAbsolutePath() + " failed");
                }
                FileUtils.copyToFile((InputStream)zis, (File)targetFile);
                boolean setExecutable = targetFile.setExecutable(true);
                if (setExecutable) continue;
                log.warn("set file " + targetFile.getAbsolutePath() + " executable failed");
            }
        }
        catch (Exception e) {
            throw new RuntimeException("unzip error:", e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)stream);
        }
        return finalDir;
    }

    private static boolean needUnzip(String entryName, String archType) {
        return entryName.equalsIgnoreCase(archType) || entryName.equals(EXTENSION_FOLDER);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getCosyVersion() {
        try {
            URL classUrl = ZipUtil.class.getResource("/" + ZipUtil.class.getName().replace('.', '/') + ".class");
            log.info("====class URL: " + classUrl);
            if (classUrl == null) return null;
            if (!"jar".equals(classUrl.getProtocol())) return null;
            String jarPath = classUrl.getPath();
            if (!jarPath.contains("!")) return null;
            if ((jarPath = jarPath.substring(0, jarPath.indexOf("!"))).startsWith("file:")) {
                jarPath = jarPath.substring(5);
            }
            jarPath = URLDecoder.decode(jarPath, StandardCharsets.UTF_8);
            log.info("====jar path: " + jarPath);
            try (ZipFile jarFile = new ZipFile(jarPath);){
                String fileName;
                ZipEntry entry;
                String entryName;
                Enumeration<? extends ZipEntry> entries = jarFile.entries();
                do {
                    if (!entries.hasMoreElements()) return null;
                } while (!(entryName = (entry = entries.nextElement()).getName()).startsWith("binaries/") || entry.isDirectory() || !(fileName = entryName.substring("binaries/".length())).startsWith("qoder-") || !fileName.endsWith(".zip"));
                String version = fileName.substring(6, fileName.length() - 4);
                log.info("====found version: " + version);
                String string = version;
                return string;
            }
        }
        catch (Exception e) {
            log.warn("Failed to get cosy version", (Throwable)e);
        }
        return null;
    }
}

