/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.util.language;

import com.alibabacloud.intellij.qoder.util.LanguageUtil;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.intellij.openapi.diagnostic.Logger;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class LanguageMapping {
    private static final Logger LOGGER = Logger.getInstance(LanguageMapping.class);
    private static final String OTHER_LANGUAGE = "others";
    public static final String PLAINTEXT = "plaintext";
    private Map<String, String> extToLang = new HashMap<String, String>();
    private Map<String, List<String>> langToExts = new HashMap<String, List<String>>();
    private Map<String, String> prefixToLang = new HashMap<String, String>();

    public void addExtension(String lang, String extName) {
        this.langToExts.computeIfAbsent(lang, k -> new ArrayList()).add(extName);
        this.extToLang.put(extName, lang);
    }

    public void addPrefix(String lang, String prefix) {
        this.prefixToLang.put(prefix, lang);
    }

    public List<String> getExtensions(String lang) {
        return this.langToExts.getOrDefault(lang, new ArrayList());
    }

    public String getLanguages(String fileName) {
        String fileExt = LanguageUtil.getExtensionByFileName(fileName = fileName.toLowerCase(Locale.ROOT));
        if (!fileExt.isEmpty()) {
            String langType;
            Object tmpFileExt = fileExt;
            if (!((String)tmpFileExt).startsWith(".")) {
                tmpFileExt = "." + (String)tmpFileExt;
            }
            if ((langType = this.extToLang.get(tmpFileExt)) != null) {
                return langType;
            }
        }
        for (Map.Entry<String, String> entry : this.prefixToLang.entrySet()) {
            if (!fileName.startsWith(entry.getKey())) continue;
            return entry.getValue();
        }
        if (!(fileExt = StringUtils.strip((String)fileExt, (String)".")).isEmpty()) {
            return fileExt;
        }
        return PLAINTEXT;
    }

    public boolean isValid() {
        return !this.extToLang.isEmpty() && !this.prefixToLang.isEmpty();
    }

    public void readJson(String jsonStr) throws JsonSyntaxException {
        Gson gson = new Gson();
        LangJsonObject langObj = (LangJsonObject)gson.fromJson(jsonStr, LangJsonObject.class);
        for (Map.Entry<String, String> entry : langObj.suffix.entrySet()) {
            String[] exts;
            for (String ext : exts = entry.getValue().split(",")) {
                this.addExtension(entry.getKey(), ext);
            }
        }
        for (Map.Entry<String, String> entry : langObj.prefix.entrySet()) {
            String[] prefixes;
            for (String prefix : prefixes = entry.getValue().split(",")) {
                this.addPrefix(entry.getKey(), prefix);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static LanguageMapping buildLanguageMapping() {
        LanguageMapping typeSet = new LanguageMapping();
        try (InputStream is = LanguageMapping.class.getResourceAsStream("/completion/language.json");){
            if (is == null) {
                LanguageMapping languageMapping = typeSet;
                return languageMapping;
            }
            String languageJson = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
            typeSet.readJson(languageJson);
            return typeSet;
        }
        catch (Exception e) {
            LOGGER.info("Failed to parse language.json: " + e.getMessage(), (Throwable)e);
        }
        return typeSet;
    }

    @Generated
    public Map<String, String> getExtToLang() {
        return this.extToLang;
    }

    @Generated
    public Map<String, List<String>> getLangToExts() {
        return this.langToExts;
    }

    @Generated
    public Map<String, String> getPrefixToLang() {
        return this.prefixToLang;
    }

    public static class LangJsonObject {
        private Map<String, String> prefix;
        private Map<String, String> suffix;

        @Generated
        public LangJsonObject() {
        }

        @Generated
        public Map<String, String> getPrefix() {
            return this.prefix;
        }

        @Generated
        public Map<String, String> getSuffix() {
            return this.suffix;
        }

        @Generated
        public void setPrefix(Map<String, String> prefix) {
            this.prefix = prefix;
        }

        @Generated
        public void setSuffix(Map<String, String> suffix) {
            this.suffix = suffix;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LangJsonObject)) {
                return false;
            }
            LangJsonObject other = (LangJsonObject)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<String, String> this$prefix = this.getPrefix();
            Map<String, String> other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Map<String, String> this$suffix = this.getSuffix();
            Map<String, String> other$suffix = other.getSuffix();
            return !(this$suffix == null ? other$suffix != null : !((Object)this$suffix).equals(other$suffix));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof LangJsonObject;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, String> $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Map<String, String> $suffix = this.getSuffix();
            result = result * 59 + ($suffix == null ? 43 : ((Object)$suffix).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "LanguageMapping.LangJsonObject(prefix=" + this.getPrefix() + ", suffix=" + this.getSuffix() + ")";
        }
    }
}

