/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.util.markdown;

import com.alibabacloud.intellij.qoder.util.markdown.MarkdownParser;
import com.intellij.openapi.util.text.StringUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class LightMarkdownParser
implements MarkdownParser {
    private static final Pattern PATTERN_SINGLE_QUOTE = Pattern.compile("(`([^\uff08\uff09\u3002]*?)`)+");
    private static final Pattern PATTERN_URL = Pattern.compile("\\[(.*?)\\]\\(([^\\)]+)(?:\\s|\\n|\\r)?\\)");

    @Override
    public String convert2Html(String markdown) {
        markdown = StringUtil.escapeXmlEntities((String)markdown);
        markdown = this.escapeSingleQuote(markdown);
        markdown = this.escapeUrl(markdown);
        markdown = markdown.replace("\n", "<br/>");
        return markdown;
    }

    public String escapeSingleQuote(String content) {
        Matcher matcher = PATTERN_SINGLE_QUOTE.matcher(content);
        while (matcher.find()) {
            String group = matcher.group();
            String data = StringUtils.removeEnd((String)group, (String)"`");
            data = StringUtils.removeStart((String)data, (String)"`");
            content = content.replace(group, String.format("<span class=\"markdown-punctuation\">%s</span>", data));
        }
        return content;
    }

    public String escapeUrl(String content) {
        Matcher matcher = PATTERN_URL.matcher(content);
        while (matcher.find()) {
            String group = matcher.group();
            String name = matcher.group(1);
            String url = matcher.group(2);
            if (StringUtils.isBlank((CharSequence)name)) {
                name = url;
            }
            content = content.replace(group, String.format("<a href=\"%s\">%s</a>", url, name));
        }
        return content;
    }
}

