/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.util.transfer;

import com.alibabacloud.intellij.qoder.ui.search.model.ChatContextTag;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;

public class ObjectEncoder {
    public static final String LINGMA_OBJECT_PREFIX = "lingma:";

    public static String encodeToStringByUrl(String str) {
        try {
            return URLEncoder.encode(str, StandardCharsets.UTF_8);
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static String decodeFromStringByUrl(String str) {
        if (str == null) {
            return "";
        }
        try {
            return URLDecoder.decode(str, StandardCharsets.UTF_8);
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static String encodeObject(ChatContextTag tag) throws IOException {
        return LINGMA_OBJECT_PREFIX + Base64.getEncoder().encodeToString(ObjectEncoder.serialize(tag));
    }

    public static byte[] serialize(ChatContextTag tag) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
                oos.writeObject(tag);
                byArray = baos.toByteArray();
            }
            return byArray;
        }
    }

    public static ChatContextTag decodeObject(String str) throws IOException, ClassNotFoundException {
        if (!str.startsWith(LINGMA_OBJECT_PREFIX)) {
            return null;
        }
        String data = str.substring(LINGMA_OBJECT_PREFIX.length());
        byte[] bytes = Base64.getDecoder().decode(data);
        return (ChatContextTag)ObjectEncoder.deserialize(bytes);
    }

    public static Object deserialize(byte[] bytes) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        try (ObjectInputStream ois = new ObjectInputStream(bais);){
            Object object = ois.readObject();
            return object;
        }
    }
}

