"use strict";
/**
 * This is the entry point for the extension.
 *
 * Note: This file has been significantly modified from its original contents. a fork of Continue (https://github.com/continuedev/continue).
 */
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.activate = activate;
exports.deactivate = deactivate;
const vscode = __importStar(require("vscode"));
const command_1 = require("./product/command");
async function dynamicImportAndActivate(context) {
    const { activateExtension } = await Promise.resolve().then(() => __importStar(require('./activation/activate')));
    try {
        return activateExtension(context);
    }
    catch (e) {
        console.log('Error activating extension: ', e);
        vscode.window
            .showInformationMessage('Error activating the Lingma IDE extension.', 'View Logs', 'Retry')
            .then((selection) => {
            if (selection === 'View Logs') {
                vscode.commands.executeCommand(command_1.Command.viewLogs);
            }
            else if (selection === 'Retry') {
                // Reload VS Code window
                vscode.commands.executeCommand('workbench.action.reloadWindow');
            }
        });
    }
}
function activate(context) {
    dynamicImportAndActivate(context);
}
function deactivate() { }
//# sourceMappingURL=extension.js.map