"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.VsCodeMessenger = void 0;
const vscode = __importStar(require("vscode"));
const message_1 = require("../product/message");
const command_1 = require("../product/command");
const i18n_1 = require("../util/i18n");
const CORE_TO_WEBVIEW_PASS_THROUGH = ['refreshSubmenuItems'];
class VsCodeMessenger {
    inProcessMessenger;
    webviewProtocol;
    ide;
    async isVSCodeExtensionInstalled(extensionId) {
        return vscode.extensions.getExtension(extensionId) !== undefined;
    }
    async attemptInstallExtension(extensionId) {
        const extension = vscode.extensions.getExtension(extensionId);
        if (extension) {
            return;
        }
        try {
            await vscode.commands.executeCommand('workbench.extensions.installExtension', extensionId);
        }
        catch (error) {
            vscode.window.showErrorMessage(`Failed to install extension: ${extensionId}`);
            console.error(error);
        }
    }
    async attemptUninstallExtension(extensionId) {
        const extension = vscode.extensions.getExtension(extensionId);
        if (!extension) {
            return;
        }
        try {
            await vscode.commands.executeCommand('workbench.extensions.uninstallExtension', extensionId);
        }
        catch (error) {
            console.error(error);
        }
    }
    onWebview(messageType, handler) {
        this.webviewProtocol.on(messageType, handler);
    }
    onCore(messageType, handler) {
        this.inProcessMessenger.externalOn(messageType, handler);
    }
    onWebviewOrCore(messageType, handler) {
        this.onWebview(messageType, handler);
        this.onCore(messageType, handler);
    }
    constructor(inProcessMessenger, webviewProtocol, ide) {
        this.inProcessMessenger = inProcessMessenger;
        this.webviewProtocol = webviewProtocol;
        this.ide = ide;
        /** PASS THROUGH FROM CORE TO WEBVIEW AND BACK **/
        CORE_TO_WEBVIEW_PASS_THROUGH.forEach((messageType) => {
            this.onCore(messageType, async (msg) => {
                return this.webviewProtocol.request(messageType, msg.data);
            });
        });
        /** WEBVIEW ONLY LISTENERS **/
        this.onWebview('invokeVSCodeCommandById', (msg) => {
            const commandId = msg.data.commandId;
            const args = msg.data.args ?? [];
            vscode.commands.executeCommand(commandId, ...args);
        });
        // welcome stuff
        this.onWebview('markNewOnboardingComplete', async (msg) => {
            return await vscode.commands.executeCommand(command_1.Command.markNewOnboardingComplete);
        });
        this.onWebview('closeOverlay', (msg) => {
            vscode.commands.executeCommand(command_1.Command.hideOverlay);
            vscode.commands.executeCommand('workbench.action.focusActiveEditorGroup');
        });
        this.onWebview('lockOverlay', (msg) => {
            vscode.commands.executeCommand(command_1.Command.lockOverlay);
        });
        this.onWebview('unlockOverlay', (msg) => {
            vscode.commands.executeCommand(command_1.Command.unlockOverlay);
        });
        this.onWebview('closeWindow', (msg) => {
            vscode.commands.executeCommand('workbench.action.closeWindow');
        });
        this.onWebview('hideOverlayLoadingMessage', (msg) => {
            vscode.commands.executeCommand(command_1.Command.hideOverlayLoadingMessage);
        });
        this.onWebview('importUserSettingsFromVSCode', async (msg) => {
            try {
                return await vscode.commands.executeCommand(command_1.Command.importUserSettingsFromVSCode);
            }
            catch (error) {
                return false;
            }
        });
        this.onWebview('importUserSettingsFromCursor', async (msg) => {
            try {
                return await vscode.commands.executeCommand(command_1.Command.importUserSettingsFromCursor);
            }
            catch (error) {
                return false;
            }
        });
        this.onWebview('reloadWindow', (msg) => {
            vscode.commands.executeCommand('workbench.action.reloadWindow');
        });
        this.onWebview('showImportingExtsMessage', (msg) => {
            vscode.window.showInformationMessage((0, i18n_1.t)(`从 VS Code 导入扩展仍在进行中，可能耗时较长，请耐心等待……`, `Importing extensions from VS Code is still in progress, it may take a while, please wait patiently...`));
        });
        this.onWebview('installVscodeExtension', (msg) => {
            this.attemptInstallExtension(msg.data.extensionId);
        });
        this.onWebview('uninstallVscodeExtension', (msg) => {
            this.attemptUninstallExtension(msg.data.extensionId);
        });
        this.onWebview('is_vscode_extension_installed', async (msg) => {
            const isInstalled = await this.isVSCodeExtensionInstalled(msg.data.extensionId);
            return isInstalled;
        });
        this.onWebview(message_1.MESSAGE_WELCOME_OPEN_FOLDER, (msg) => {
            vscode.commands.executeCommand('workbench.action.files.openFolder');
        });
        this.onWebview(message_1.MESSAGE_INSTALL_COMMAND_LINE, (msg) => {
            vscode.commands.executeCommand('workbench.action.installCommandLine');
        });
        this.onWebview(message_1.MESSAGE_CLOSE_LANDING_OVERLAY, (msg) => {
            vscode.commands.executeCommand(command_1.Command.unlockOverlay);
            vscode.commands.executeCommand(command_1.Command.hideOverlay);
        });
        this.onWebview(message_1.MESSAGE_TOGGLE_DEV_TOOLS, (msg) => {
            vscode.commands.executeCommand('workbench.action.toggleDevTools');
            vscode.commands.executeCommand(command_1.Command.viewLogs);
        });
        this.onWebview('openExternal', (msg) => {
            const url = msg.data.url;
            if (url) {
                vscode.env.openExternal(vscode.Uri.parse(url));
            }
        });
        /** BOTH CORE AND WEBVIEW **/
        this.onWebviewOrCore(message_1.MESSAGE_GET_IDE_SETTINGS, async (msg) => {
            return ide.getIdeSettings();
        });
        this.onWebviewOrCore(message_1.MESSAGE_GET_IDE_INFO, async (msg) => {
            return ide.getIdeInfo();
        });
        this.onWebviewOrCore(message_1.MESSAGE_GET_USER_AUTH, (msg) => ide.getUserAuth());
        // 调用lingma插件登录（阿里云中国站）
        this.onWebview('login.cn', () => {
            vscode.commands.executeCommand('aicoding.login', { regionEnv: 'cn', loginDedicatedType: 'standard' });
        });
        // 调用lingma插件登录（阿里云国际站）
        this.onWebview('login.alibabacloud', () => {
            vscode.commands.executeCommand('aicoding.login', { regionEnv: 'intl', loginDedicatedType: 'standard' });
        });
        // 调用lingma插件登录（专属版）
        this.onWebview('login.dedicated', () => {
            vscode.commands.executeCommand('aicoding.login', { regionEnv: '', loginDedicatedType: 'dedicated' });
        });
        // 调用lingma打开设置
        this.onWebview('lingma.extension.openSettings', () => {
            vscode.commands.executeCommand('aicoding.openSettings');
        });
        // 切换主题
        this.onWebview('setColorTheme', async (msg) => {
            const themeId = msg.data.themeId;
            await vscode.workspace.getConfiguration().update('workbench.colorTheme', themeId, vscode.ConfigurationTarget.Global);
        });
        // 导入插件完成（当引导已结束时导入完成才需调用；在引导流程中完成导入无需调用）
        this.onWebview('showImportExtsSuccessMessage', (msg) => {
            const restartAction = (0, i18n_1.t)('重启窗口', 'Reload Window');
            // const ignoreAction = t('忽略', 'Ignore');
            vscode.window.showInformationMessage((0, i18n_1.t)('已成功导入 VS Code 扩展和设置，请重新加载窗口', 'VS Code extensions and settings have been successfully imported. Please reload the window.'), {
                modal: true,
                detail: (0, i18n_1.t)('你的个性化设置已准备就绪 —— 重启 IDE 以确保扩展正常运行，未成功安装的扩展可手动从市场中查找并安装。', 'Your personalized workspace is ready — restart the IDE to ensure extensions work properly, and manually install any that failed from the marketplace.')
            }, restartAction).then(selection => {
                if (selection === restartAction) {
                    vscode.commands.executeCommand('workbench.action.reloadWindow');
                }
                // 如果选择忽略或者直接关闭，不需要做任何操作
            });
        });
    }
}
exports.VsCodeMessenger = VsCodeMessenger;
//# sourceMappingURL=VsCodeMessenger.js.map