"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.VsCodeIde = void 0;
const vscode = __importStar(require("vscode"));
const ideUtils_1 = require("./util/ideUtils");
const configuration_1 = require("./product/configuration");
const viewTypes_1 = require("./product/viewTypes");
class VsCodeIde {
    ideUtils;
    constructor() {
        this.ideUtils = new ideUtils_1.VsCodeIdeUtils();
    }
    getIdeInfo() {
        return Promise.resolve({
            ideType: 'vscode',
            name: vscode.env.appName,
            version: vscode.version,
            remoteName: vscode.env.remoteName || 'local',
            extensionVersion: vscode.extensions.getExtension(viewTypes_1.EXTENSION_AUTH_PREFIX)
                ?.packageJSON.version,
        });
    }
    getIdeSettingsSync() {
        const settings = vscode.workspace.getConfiguration(configuration_1.APPLICATION_NAME);
        const remoteConfigServerUrl = settings.get('remoteConfigServerUrl', undefined);
        const ideSettings = {
            remoteConfigServerUrl,
            remoteConfigSyncPeriod: settings.get('remoteConfigSyncPeriod', 60),
            userToken: settings.get('userToken', ''),
            enableControlServerBeta: settings.get('enableContinueForTeams', false),
            pauseCodebaseIndexOnStart: settings.get('pauseCodebaseIndexOnStart', false),
            enableDebugLogs: settings.get('enableDebugLogs', false),
        };
        return ideSettings;
    }
    async getIdeSettings() {
        return this.getIdeSettingsSync();
    }
    async getUserAuth() {
        const creds = await this.ideUtils.getUserCredentials();
        return creds;
    }
    async updateUserCredentials(auth) {
        await this.ideUtils.updateUserCredentials(auth);
    }
}
exports.VsCodeIde = VsCodeIde;
//# sourceMappingURL=ideProtocol.js.map