"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.TOOL_COMMANDS = exports.InstallableTool = void 0;
exports.getIntegrationTab = getIntegrationTab;
exports.handleIntegrationShortcutKey = handleIntegrationShortcutKey;
exports.extractCodeFromMarkdown = extractCodeFromMarkdown;
/* eslint-disable @typescript-eslint/naming-convention */
const vscode = __importStar(require("vscode"));
const command_1 = require("../product/command");
// import { ToWebviewProtocol } from "core/protocol";
var InstallableTool;
(function (InstallableTool) {
    InstallableTool["SUPERMAVEN"] = "supermaven";
})(InstallableTool || (exports.InstallableTool = InstallableTool = {}));
exports.TOOL_COMMANDS = {
    [InstallableTool.SUPERMAVEN]: {
        command: 'workbench.extensions.installExtension',
        args: 'supermaven.supermaven',
    },
};
function getIntegrationTab(webviewName) {
    const tabs = vscode.window.tabGroups.all.flatMap((tabGroup) => tabGroup.tabs);
    return tabs.find((tab) => {
        const viewType = tab.input?.viewType;
        return viewType?.endsWith(webviewName);
    });
}
async function handleIntegrationShortcutKey(protocol, integrationName, sidebar, webviews) {
    const isOverlayVisible = await vscode.commands.executeCommand(command_1.IdeInnerCommand.isOverlayVisible);
    let currentTab = await sidebar.webviewProtocol.request('getCurrentTab', undefined, webviews);
    if (isOverlayVisible && currentTab === integrationName) {
        // close overlay
        await vscode.commands.executeCommand(command_1.Command.hideOverlay);
        await vscode.commands.executeCommand('workbench.action.focusActiveEditorGroup');
        return;
    }
    await sidebar.webviewProtocol?.request(protocol, undefined, webviews);
    if (!isOverlayVisible) {
        // If overlay isn't open, open it first
        // Navigate to creator tab via webview protocol
        await vscode.commands.executeCommand(command_1.Command.startOnboarding);
    }
}
function extractCodeFromMarkdown(text) {
    // Match code blocks with optional language specification
    const codeBlockRegex = /```[\w-]*\n([\s\S]*?)\n```/m;
    let match = text.match(codeBlockRegex);
    if (!match) {
        const lines = text.split('\n');
        if (lines[0].trim().startsWith('```') &&
            lines[lines.length - 1].trim().startsWith('```')) {
            // remove first and last line
            const codeLines = lines.slice(1, -1);
            match = ['', codeLines.join('\n')];
        }
    }
    // If it's a code block, return the code inside
    // Otherwise return the original text
    return match ? match[1] : text;
}
//# sourceMappingURL=integrationUtils.js.map