"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.VsCodeWebviewProtocol = void 0;
exports.showTutorial = showTutorial;
const node_fs_1 = __importDefault(require("node:fs"));
const path_1 = __importDefault(require("path"));
const uuid_1 = require("uuid");
const vscode = __importStar(require("vscode"));
const vscode_1 = require("./util/vscode");
const viewTypes_1 = require("./product/viewTypes");
const configuration_1 = require("./product/configuration");
async function showTutorial() {
    const tutorialPath = path_1.default.join((0, vscode_1.getExtensionUri)().fsPath, 'media', 'welcome.md');
    // Ensure keyboard shortcuts match OS
    if (process.platform !== 'darwin') {
        let tutorialContent = node_fs_1.default.readFileSync(tutorialPath, 'utf8');
        tutorialContent = tutorialContent
            .replaceAll('⌘', '^')
            .replaceAll('Cmd', 'Ctrl');
        node_fs_1.default.writeFileSync(tutorialPath, tutorialContent);
    }
    const doc = await vscode.workspace.openTextDocument(vscode.Uri.file(tutorialPath));
    await vscode.window.showTextDocument(doc, { preview: false });
}
class VsCodeWebviewProtocol {
    reloadConfig;
    listeners = new Map();
    send(messageType, data, messageId, specificWebviews) {
        const id = messageId ?? (0, uuid_1.v4)();
        if (specificWebviews) {
            specificWebviews.forEach((name) => {
                try {
                    const webview = this.webviews.get(name);
                    if (webview) {
                        webview.postMessage({
                            messageType,
                            data,
                            messageId: id,
                        });
                    }
                }
                catch (error) {
                    console.error(`Failed to post message to webview ${name}:`, error);
                }
            });
        }
        else {
            this.webviews.forEach((webview) => {
                webview.postMessage({
                    messageType,
                    data,
                    messageId: id,
                });
            });
        }
        return id;
    }
    on(messageType, handler) {
        if (!this.listeners.has(messageType)) {
            this.listeners.set(messageType, []);
        }
        this.listeners.get(messageType)?.push(handler);
    }
    _webviews = new Map();
    _webviewListeners = new Map();
    get webviews() {
        return this._webviews;
    }
    resetWebviews() {
        this._webviews.clear();
        this._webviewListeners.forEach((listener) => listener.dispose());
        this._webviewListeners.clear();
    }
    resetWebviewToDefault() {
        const defaultViewKey = viewTypes_1.AI_IDE_CHAT_VIEW_ID;
        // Remove all entries except for the chat view
        this._webviews.forEach((value, key) => {
            if (key !== defaultViewKey) {
                this._webviews.delete(key);
            }
        });
        // Dispose and remove all listeners except for the chat view
        this._webviewListeners.forEach((listener, key) => {
            if (key !== defaultViewKey) {
                listener.dispose();
                this._webviewListeners.delete(key);
            }
        });
    }
    addWebview(viewType, webView) {
        this._webviews.set(viewType, webView);
        const listener = webView.onDidReceiveMessage(async (msg) => {
            if (!msg.messageType || !msg.messageId) {
                throw new Error(`Invalid webview protocol msg: ${JSON.stringify(msg)}`);
            }
            const respond = (message) => this.send(msg.messageType, message, msg.messageId);
            const handlers = this.listeners.get(msg.messageType) || [];
            for (const handler of handlers) {
                try {
                    const response = await handler(msg);
                    if (response &&
                        typeof response[Symbol.asyncIterator] === 'function') {
                        let next = await response.next();
                        while (!next.done) {
                            respond(next.value);
                            next = await response.next();
                        }
                        respond({ done: true, content: next.value?.content });
                    }
                    else {
                        respond(response || {});
                    }
                }
                catch (e) {
                    respond({ done: true, error: e });
                    console.error(`Error handling webview message: ${JSON.stringify({ msg }, null, 2)}\n\n${e}`);
                    let message = e.message;
                    if (e.cause) {
                        if (e.cause.name === 'ConnectTimeoutError') {
                            message = `Connection timed out. If you expect it to take a long time to connect, you can increase the timeout in config.json by setting "requestOptions": { "timeout": 10000 }. You can find the full config reference here: `;
                        }
                        else if (e.cause.code === 'ECONNREFUSED') {
                            message = `Connection was refused. This likely means that there is no server running at the specified URL. If you are running your own server you may need to set the "apiBase" parameter in config.json. For example, you can set up an OpenAI-compatible server like here: `;
                        }
                        else {
                            message = `The request failed with "${e.cause.name}": ${e.cause.message}. If you're having trouble setting up Lingma IDE, please see the troubleshooting guide for help.`;
                        }
                    }
                    // Lingma IDE login issues
                    else if (message.includes('401') &&
                        message.includes(configuration_1.OUTPUT_CHANNEL)) {
                        vscode.window
                            .showErrorMessage(message, 'Login To Lingma IDE', 'Show Logs')
                            .then((selection) => {
                            if (selection === 'Login To Lingma IDE') {
                                // Redirect to auth login URL
                                vscode.env.openExternal(vscode.Uri.parse(`${viewTypes_1.SIGN_IN_WEB_URL}?callback=${configuration_1.APPLICATION_NAME}://${viewTypes_1.EXTENSION_AUTH_PREFIX}/auth`));
                            }
                            else if (selection === 'Show Logs') {
                                vscode.commands.executeCommand('workbench.action.toggleDevTools');
                            }
                        });
                    }
                    // Lingma IDE Free trial ended case
                    else if (message.includes('403') &&
                        message.includes(configuration_1.OUTPUT_CHANNEL)) {
                        vscode.window
                            .showErrorMessage(message, 'View Lingma IDE Pricing', 'Show Logs')
                            .then((selection) => {
                            if (selection === 'View Lingma IDE Pricing') {
                                // Redirect to auth login URL
                                vscode.env.openExternal(vscode.Uri.parse(viewTypes_1.PRICING_WEB_URL));
                            }
                            else if (selection === 'Show Logs') {
                                vscode.commands.executeCommand('workbench.action.toggleDevTools');
                            }
                        });
                    }
                    else if (message.includes('https://proxy-server')) {
                        message = message.split('\n').filter((l) => l !== '')[1];
                        try {
                            message = JSON.parse(message).message;
                        }
                        catch { }
                        if (message.includes('exceeded')) {
                            message +=
                                ' To keep using Lingma IDE, you can set up a local model or use your own API key.';
                        }
                        vscode.window
                            .showInformationMessage(message, 'Add API Key', 'Use Local Model')
                            .then((selection) => {
                            if (selection === 'Add API Key') {
                                this.request('addApiKey', undefined);
                            }
                            else if (selection === 'Use Local Model') {
                                this.request('setupLocalModel', undefined);
                            }
                        });
                    }
                    else if (message.includes('Please sign in with GitHub')) {
                        vscode.window
                            .showInformationMessage(message, 'Sign In', 'Use API key / local model')
                            .then((selection) => {
                            if (selection === 'Sign In') {
                                vscode.authentication
                                    .getSession('github', [], {
                                    createIfNone: true,
                                })
                                    .then(() => {
                                    this.reloadConfig();
                                });
                            }
                            else if (selection === 'Use API key / local model') {
                                this.request('openOnboarding', undefined);
                            }
                        });
                    }
                    else {
                        vscode.window
                            .showErrorMessage(message, 'Show Logs', 'Troubleshooting')
                            .then((selection) => {
                            if (selection === 'Show Logs') {
                                vscode.commands.executeCommand('workbench.action.toggleDevTools');
                            }
                            else if (selection === 'Troubleshooting') {
                                vscode.env.openExternal(vscode.Uri.parse(viewTypes_1.TROUBLESHOOTING_WEB_URL));
                            }
                        });
                    }
                }
            }
        });
        this._webviewListeners.set(viewType, listener);
    }
    removeWebview(name) {
        const webView = this._webviews.get(name);
        if (webView) {
            this._webviews.delete(name);
            this._webviewListeners.get(name)?.dispose();
            this._webviewListeners.delete(name);
        }
    }
    constructor(reloadConfig) {
        this.reloadConfig = reloadConfig;
        vscode.commands.registerCommand('qoder.landingDataExchange.ide2ext', async (type, params) => {
            if (type === 'webview:handle') {
                const { messageType, data, messageId } = params;
                const handlers = this.listeners.get(messageType) || [];
                if (handlers.length > 0) {
                    try {
                        // 返回第一个 handler 的返回值
                        const result = await handlers[0]({ messageType, data, messageId });
                        return result;
                    }
                    catch (e) {
                        console.error(`Error handling webview message: ${JSON.stringify({ messageType, data, messageId }, null, 2)}\n\n${e}`);
                        throw e; // 重新抛出错误，让命令调用者能感知到
                    }
                }
                return undefined;
            }
        });
    }
    invoke(messageType, data, messageId) {
        throw new Error('Method not implemented.');
    }
    onError(handler) {
        throw new Error('Method not implemented.');
    }
    request(messageType, data, specificWebviews) {
        const messageId = (0, uuid_1.v4)();
        return new Promise(async (resolve) => {
            let i = 0;
            while (this.webviews.size === 0) {
                if (i >= 10) {
                    resolve(undefined);
                    return;
                }
                else {
                    await new Promise((res) => setTimeout(res, i >= 5 ? 1000 : 500));
                    i++;
                }
            }
            this.send(messageType, data, messageId, specificWebviews);
            const disposables = [];
            this.webviews.forEach((webview, name) => {
                const disposable = webview.onDidReceiveMessage((msg) => {
                    if (msg.messageId === messageId) {
                        resolve(msg.data);
                        disposables.forEach((d) => d.dispose());
                    }
                });
                disposables.push(disposable);
            });
        });
    }
}
exports.VsCodeWebviewProtocol = VsCodeWebviewProtocol;
//# sourceMappingURL=webviewProtocol.js.map