'use strict';

const withDefaults = require('../shared.webpack.config');
const webpack = require('webpack');
const path = require('path');

module.exports = withDefaults({
	context: __dirname,
	output: {
		filename: '[name].js',
		path: path.join(__dirname, 'dist'),
		libraryTarget: 'commonjs',
	},
	entry: {
		extension: './src/extension.ts',
	},
	externals: {
		vscode: "commonjs vscode",
		bufferutil: "bufferutil",
		"utf-8-validate": "utf-8-validate",
	},
	plugins: [
		new webpack.IgnorePlugin({
			resourceRegExp: /crypto\/build\/Release\/sshcrypto\.node$/,
		}),
		new webpack.IgnorePlugin({
			resourceRegExp: /cpu-features/,
		})
	]
});
